/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.views;

import com.example.vibe.ui.theme.ThemeManager;
import com.example.vibe.ui.theme.VibeTheme;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TypingIndicatorWidget
extends Composite {
    private static final int ANIMATION_INTERVAL_MS = 150;
    private static final int DOT_COUNT = 3;
    private static final int DOT_SIZE = 6;
    private static final int DOT_SPACING = 4;
    private Canvas dotsCanvas;
    private Label textLabel;
    private Runnable animationRunnable;
    private int animationFrame = 0;
    private boolean isAnimating = false;
    private final VibeTheme theme = ThemeManager.getInstance().getTheme();

    public TypingIndicatorWidget(Composite parent) {
        super(parent, 0);
        this.createContents();
        this.createAnimationRunnable();
    }

    private void createContents() {
        this.setBackground(this.theme.getAssistantMessageBackground());
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 12;
        layout.marginHeight = 8;
        layout.horizontalSpacing = 8;
        this.setLayout((Layout)layout);
        this.dotsCanvas = new Canvas((Composite)this, 0x20000000);
        this.dotsCanvas.setBackground(this.getBackground());
        GridData dotsData = new GridData(16384, 0x1000000, false, false);
        dotsData.widthHint = 26;
        dotsData.heightHint = 14;
        this.dotsCanvas.setLayoutData((Object)dotsData);
        this.dotsCanvas.addPaintListener(this::paintDots);
        this.textLabel = new Label((Composite)this, 0);
        this.textLabel.setText("AI \u043e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u0435\u0442 \u0437\u0430\u043f\u0440\u043e\u0441");
        this.textLabel.setBackground(this.getBackground());
        this.textLabel.setForeground(this.theme.getTextMuted());
        this.textLabel.setFont(this.theme.getFont());
        this.textLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.setVisible(false);
        GridData myData = new GridData(4, 0x1000000, true, false);
        myData.exclude = true;
        this.setLayoutData(myData);
    }

    private void paintDots(PaintEvent e) {
        GC gc = e.gc;
        gc.setAntialias(1);
        Point size = this.dotsCanvas.getSize();
        int baseY = size.y / 2;
        int i = 0;
        while (i < 3) {
            int frameOffset = (this.animationFrame - i + 6) % 6;
            int bounceY = 0;
            if (frameOffset < 3) {
                bounceY = -frameOffset * 2;
                if (frameOffset > 1) {
                    bounceY = -(3 - frameOffset) * 2;
                }
            }
            int x = i * 10;
            int y = baseY + bounceY - 3;
            gc.setBackground(this.theme.getAccent());
            gc.fillOval(x, y, 6, 6);
            ++i;
        }
    }

    private void createAnimationRunnable() {
        this.animationRunnable = () -> {
            if (this.isDisposed() || !this.isAnimating) {
                return;
            }
            this.animationFrame = (this.animationFrame + 1) % 6;
            if (!this.dotsCanvas.isDisposed()) {
                this.dotsCanvas.redraw();
            }
            if (this.isAnimating && !this.isDisposed()) {
                this.getDisplay().timerExec(150, this.animationRunnable);
            }
        };
    }

    public void show() {
        if (this.isDisposed()) {
            return;
        }
        this.moveBelow(null);
        this.setVisible(true);
        GridData data = (GridData)this.getLayoutData();
        if (data != null) {
            data.exclude = false;
        }
        if (!this.isAnimating) {
            this.isAnimating = true;
            this.animationFrame = 0;
            this.getDisplay().timerExec(150, this.animationRunnable);
        }
        this.getParent().layout(true, true);
    }

    public void hide() {
        if (this.isDisposed()) {
            return;
        }
        this.isAnimating = false;
        this.setVisible(false);
        GridData data = (GridData)this.getLayoutData();
        if (data != null) {
            data.exclude = true;
        }
        this.getParent().layout(true, true);
    }

    public void setText(String text) {
        if (!this.textLabel.isDisposed()) {
            this.textLabel.setText(text);
        }
    }

    public boolean isShowing() {
        return this.getVisible() && this.isAnimating;
    }

    public void dispose() {
        this.isAnimating = false;
        super.dispose();
    }
}

