/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.views;

import com.example.vibe.core.review.BslReviewIssue;
import com.example.vibe.core.review.BslReviewResult;
import com.example.vibe.ui.theme.ThemeManager;
import com.example.vibe.ui.theme.VibeTheme;
import com.example.vibe.ui.views.ReviewIssueWidget;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ReviewResultWidget
extends Composite {
    private final VibeTheme theme;
    private final BslReviewResult result;
    private final List<ReviewIssueWidget> issueWidgets = new ArrayList<ReviewIssueWidget>();
    private Color successColor;
    private Color criticalBgColor;

    public ReviewResultWidget(Composite parent, BslReviewResult result) {
        super(parent, 0);
        this.theme = ThemeManager.getInstance().getTheme();
        this.result = result;
        this.initializeColors();
        this.createContents();
    }

    private void initializeColors() {
        Display display = this.getDisplay();
        this.successColor = new Color((Device)display, 40, 167, 69);
        this.criticalBgColor = new Color((Device)display, 255, 235, 238);
    }

    private void createContents() {
        this.setBackground(this.theme.getAssistantMessageBackground());
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 12;
        layout.marginHeight = 10;
        layout.verticalSpacing = 8;
        this.setLayout((Layout)layout);
        Label titleLabel = new Label((Composite)this, 0);
        titleLabel.setText("\ud83d\udccb \u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043a\u043e\u0434\u0430");
        titleLabel.setFont(this.theme.getFontBold());
        titleLabel.setForeground(this.theme.getText());
        titleLabel.setBackground(this.getBackground());
        if (this.result.getFilePath() != null) {
            Label fileLabel = new Label((Composite)this, 0);
            fileLabel.setText("\u0424\u0430\u0439\u043b: " + this.result.getFilePath());
            fileLabel.setFont(this.theme.getFontMono());
            fileLabel.setForeground(this.theme.getTextMuted());
            fileLabel.setBackground(this.getBackground());
        }
        this.createSummary();
        Label separator = new Label((Composite)this, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        List reportableIssues = this.result.getReportableIssues();
        if (reportableIssues.isEmpty()) {
            this.createSuccessMessage();
        } else {
            this.createIssuesList(reportableIssues);
        }
    }

    private void createSummary() {
        Composite summaryRow = new Composite((Composite)this, 0);
        summaryRow.setBackground(this.getBackground());
        summaryRow.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout rowLayout = new GridLayout(4, false);
        rowLayout.marginWidth = 0;
        rowLayout.marginHeight = 4;
        rowLayout.horizontalSpacing = 16;
        summaryRow.setLayout((Layout)rowLayout);
        int total = this.result.getTotalCount();
        int reportable = this.result.getReportableCount();
        int critical = this.result.getCriticalCount();
        this.createStatLabel(summaryRow, "\u041d\u0430\u0439\u0434\u0435\u043d\u043e:", String.valueOf(total), this.theme.getTextMuted());
        this.createStatLabel(summaryRow, "\u0412\u0430\u0436\u043d\u044b\u0445:", String.valueOf(reportable), reportable > 0 ? this.theme.getAccent() : this.successColor);
        if (critical > 0) {
            Label criticalLabel = new Label(summaryRow, 0);
            criticalLabel.setText("\ud83d\udd34 \u041a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0445: " + critical);
            criticalLabel.setFont(this.theme.getFontBold());
            criticalLabel.setForeground(this.getDisplay().getSystemColor(3));
            criticalLabel.setBackground(summaryRow.getBackground());
        }
        this.createStatLabel(summaryRow, "\u0412\u0440\u0435\u043c\u044f:", this.result.getAnalysisTimeMs() + " \u043c\u0441", this.theme.getTextMuted());
    }

    private void createStatLabel(Composite parent, String label, String value, Color valueColor) {
        Composite stat = new Composite(parent, 0);
        stat.setBackground(parent.getBackground());
        GridLayout statLayout = new GridLayout(2, false);
        statLayout.marginWidth = 0;
        statLayout.marginHeight = 0;
        statLayout.horizontalSpacing = 4;
        stat.setLayout((Layout)statLayout);
        Label labelPart = new Label(stat, 0);
        labelPart.setText(label);
        labelPart.setFont(this.theme.getFont());
        labelPart.setForeground(this.theme.getTextMuted());
        labelPart.setBackground(stat.getBackground());
        Label valuePart = new Label(stat, 0);
        valuePart.setText(value);
        valuePart.setFont(this.theme.getFontBold());
        valuePart.setForeground(valueColor);
        valuePart.setBackground(stat.getBackground());
    }

    private void createSuccessMessage() {
        Composite successBox = new Composite((Composite)this, 0);
        successBox.setBackground(this.successColor);
        successBox.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout boxLayout = new GridLayout(1, false);
        boxLayout.marginWidth = 12;
        boxLayout.marginHeight = 8;
        successBox.setLayout((Layout)boxLayout);
        Label successLabel = new Label(successBox, 0);
        successLabel.setText("\u2705 \u041f\u0440\u043e\u0431\u043b\u0435\u043c \u043d\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e! \u041a\u043e\u0434 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u0430\u043c.");
        successLabel.setFont(this.theme.getFontBold());
        successLabel.setForeground(this.getDisplay().getSystemColor(1));
        successLabel.setBackground(successBox.getBackground());
    }

    private void createIssuesList(List<BslReviewIssue> issues) {
        Label issuesHeader = new Label((Composite)this, 0);
        issuesHeader.setText("\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043d\u044b\u0435 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b (" + issues.size() + "):");
        issuesHeader.setFont(this.theme.getFontBold());
        issuesHeader.setForeground(this.theme.getText());
        issuesHeader.setBackground(this.getBackground());
        Composite issuesContainer = new Composite((Composite)this, 0);
        issuesContainer.setBackground(this.getBackground());
        issuesContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout issuesLayout = new GridLayout(1, false);
        issuesLayout.marginWidth = 0;
        issuesLayout.marginHeight = 0;
        issuesLayout.verticalSpacing = 4;
        issuesContainer.setLayout((Layout)issuesLayout);
        for (BslReviewIssue issue : issues) {
            ReviewIssueWidget issueWidget = new ReviewIssueWidget(issuesContainer, issue);
            issueWidget.setLayoutData(new GridData(4, 0x1000000, true, false));
            if (issue.isCritical()) {
                issueWidget.setBackground(this.criticalBgColor);
            }
            this.issueWidgets.add(issueWidget);
        }
    }

    public BslReviewResult getResult() {
        return this.result;
    }

    public List<ReviewIssueWidget> getIssueWidgets() {
        return new ArrayList<ReviewIssueWidget>(this.issueWidgets);
    }

    public void dispose() {
        for (ReviewIssueWidget widget : this.issueWidgets) {
            if (widget.isDisposed()) continue;
            widget.dispose();
        }
        this.issueWidgets.clear();
        if (this.successColor != null && !this.successColor.isDisposed()) {
            this.successColor.dispose();
        }
        if (this.criticalBgColor != null && !this.criticalBgColor.isDisposed()) {
            this.criticalBgColor.dispose();
        }
        super.dispose();
    }
}

