/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.views;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;

public class AgentRunComposite
extends Composite {
    private AgentState currentState = AgentState.IDLE;
    private String currentOperation;
    private int toolCallsTotal;
    private int toolCallsCompleted;
    private final List<AgentRunListener> listeners = new CopyOnWriteArrayList<AgentRunListener>();
    private Composite headerComposite;
    private Label stateLabel;
    private Label operationLabel;
    private ProgressBar progressBar;
    private Label progressLabel;
    private Button cancelButton;
    private Composite toolsComposite;
    private final List<ToolStatusWidget> toolWidgets = new ArrayList<ToolStatusWidget>();
    private Font boldFont;
    private Color activeColor;
    private Color completedColor;
    private Color errorColor;
    private Color bgColor;

    public AgentRunComposite(Composite parent, int style) {
        super(parent, style);
        this.createResources();
        this.createContents();
        this.updateState(AgentState.IDLE);
    }

    private void createResources() {
        FontData[] fontData;
        Display display = this.getDisplay();
        FontData[] fontDataArray = fontData = this.getFont().getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fd = fontDataArray[n2];
            fd.setStyle(1);
            ++n2;
        }
        this.boldFont = new Font((Device)display, fontData);
        this.activeColor = new Color((Device)display, 59, 130, 246);
        this.completedColor = new Color((Device)display, 34, 197, 94);
        this.errorColor = new Color((Device)display, 239, 68, 68);
        this.bgColor = new Color((Device)display, 249, 250, 251);
    }

    private void createContents() {
        this.setBackground(this.bgColor);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 12;
        layout.marginHeight = 8;
        layout.verticalSpacing = 8;
        this.setLayout((Layout)layout);
        this.createHeader();
        this.createProgressSection();
        this.createToolsSection();
    }

    private void createHeader() {
        this.headerComposite = new Composite((Composite)this, 0);
        this.headerComposite.setBackground(this.bgColor);
        this.headerComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout headerLayout = new GridLayout(3, false);
        headerLayout.marginWidth = 0;
        headerLayout.marginHeight = 0;
        this.headerComposite.setLayout((Layout)headerLayout);
        this.stateLabel = new Label(this.headerComposite, 0);
        this.stateLabel.setFont(this.boldFont);
        this.stateLabel.setBackground(this.bgColor);
        this.stateLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.operationLabel = new Label(this.headerComposite, 0);
        this.operationLabel.setBackground(this.bgColor);
        this.operationLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.cancelButton = new Button(this.headerComposite, 8);
        this.cancelButton.setText("\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c");
        this.cancelButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.cancelButton.addListener(13, e -> {
            for (AgentRunListener listener : this.listeners) {
                listener.onCancelRequested();
            }
        });
    }

    private void createProgressSection() {
        Composite progressComposite = new Composite((Composite)this, 0);
        progressComposite.setBackground(this.bgColor);
        progressComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout progressLayout = new GridLayout(2, false);
        progressLayout.marginWidth = 0;
        progressLayout.marginHeight = 0;
        progressComposite.setLayout((Layout)progressLayout);
        this.progressBar = new ProgressBar(progressComposite, 65536);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        GridData progressData = new GridData(4, 0x1000000, true, false);
        progressData.heightHint = 8;
        this.progressBar.setLayoutData((Object)progressData);
        this.progressLabel = new Label(progressComposite, 0);
        this.progressLabel.setBackground(this.bgColor);
        this.progressLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
    }

    private void createToolsSection() {
        this.toolsComposite = new Composite((Composite)this, 0);
        this.toolsComposite.setBackground(this.bgColor);
        this.toolsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout toolsLayout = new GridLayout(1, false);
        toolsLayout.marginWidth = 0;
        toolsLayout.marginHeight = 0;
        toolsLayout.verticalSpacing = 4;
        this.toolsComposite.setLayout((Layout)toolsLayout);
    }

    public void updateState(AgentState state) {
        if (this.isDisposed()) {
            return;
        }
        this.currentState = state;
        Display.getDefault().asyncExec(() -> {
            boolean showProgress;
            Color stateColor;
            String stateText;
            if (this.isDisposed()) {
                return;
            }
            boolean enableCancel = switch (state) {
                case AgentState.IDLE -> {
                    stateText = "\u25cf \u0413\u043e\u0442\u043e\u0432";
                    stateColor = this.completedColor;
                    showProgress = false;
                    yield false;
                }
                case AgentState.THINKING -> {
                    stateText = "\u25c9 \u041e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u044e...";
                    stateColor = this.activeColor;
                    showProgress = true;
                    yield true;
                }
                case AgentState.TOOL_EXECUTING -> {
                    stateText = "\u2699 \u0412\u044b\u043f\u043e\u043b\u043d\u044f\u044e \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442";
                    stateColor = this.activeColor;
                    showProgress = true;
                    yield true;
                }
                case AgentState.AWAITING_CONFIRMATION -> {
                    stateText = "\u23f8 \u041e\u0436\u0438\u0434\u0430\u043d\u0438\u0435 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f";
                    stateColor = this.activeColor;
                    showProgress = false;
                    yield true;
                }
                case AgentState.COMPLETED -> {
                    stateText = "\u2713 \u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e";
                    stateColor = this.completedColor;
                    showProgress = false;
                    yield false;
                }
                case AgentState.CANCELLED -> {
                    stateText = "\u2715 \u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e";
                    stateColor = this.errorColor;
                    showProgress = false;
                    yield false;
                }
                case AgentState.ERROR -> {
                    stateText = "\u26a0 \u041e\u0448\u0438\u0431\u043a\u0430";
                    stateColor = this.errorColor;
                    showProgress = false;
                    yield false;
                }
                default -> {
                    stateText = "\u25cf";
                    stateColor = this.activeColor;
                    showProgress = false;
                    yield false;
                }
            };
            this.stateLabel.setText(stateText);
            this.stateLabel.setForeground(stateColor);
            this.progressBar.setVisible(showProgress);
            this.cancelButton.setEnabled(enableCancel);
            this.layout(true, true);
        });
    }

    public void setCurrentOperation(String operation) {
        this.currentOperation = operation;
        Display.getDefault().asyncExec(() -> {
            if (this.isDisposed() || this.operationLabel.isDisposed()) {
                return;
            }
            this.operationLabel.setText(operation != null ? operation : "");
            this.headerComposite.layout(true);
        });
    }

    public void updateProgress(int completed, int total) {
        this.toolCallsCompleted = completed;
        this.toolCallsTotal = total;
        Display.getDefault().asyncExec(() -> {
            if (this.isDisposed()) {
                return;
            }
            if (total > 0) {
                int percentage = completed * 100 / total;
                this.progressBar.setSelection(percentage);
                this.progressLabel.setText(String.format("%d/%d", completed, total));
            } else {
                this.progressBar.setSelection(0);
                this.progressLabel.setText("");
            }
        });
    }

    public ToolStatusWidget addToolStatus(String toolName, String toolCallId) {
        ToolStatusWidget[] widget = new ToolStatusWidget[1];
        Display.getDefault().syncExec(() -> {
            if (this.isDisposed() || this.toolsComposite.isDisposed()) {
                return;
            }
            toolStatusWidgetArray[0] = new ToolStatusWidget(this.toolsComposite, toolName, toolCallId);
            widget[0].setLayoutData(new GridData(4, 0x1000000, true, false));
            this.toolWidgets.add(widget[0]);
            this.toolsComposite.layout(true, true);
            this.layout(true, true);
        });
        return widget[0];
    }

    public void clearToolStatuses() {
        Display.getDefault().asyncExec(() -> {
            if (this.isDisposed() || this.toolsComposite.isDisposed()) {
                return;
            }
            for (ToolStatusWidget widget : this.toolWidgets) {
                if (widget.isDisposed()) continue;
                widget.dispose();
            }
            this.toolWidgets.clear();
            this.toolsComposite.layout(true, true);
        });
    }

    public void reset() {
        this.clearToolStatuses();
        this.setCurrentOperation(null);
        this.updateProgress(0, 0);
        this.updateState(AgentState.IDLE);
    }

    public void addListener(AgentRunListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(AgentRunListener listener) {
        this.listeners.remove(listener);
    }

    public AgentState getCurrentState() {
        return this.currentState;
    }

    public void dispose() {
        if (this.boldFont != null && !this.boldFont.isDisposed()) {
            this.boldFont.dispose();
        }
        if (this.activeColor != null && !this.activeColor.isDisposed()) {
            this.activeColor.dispose();
        }
        if (this.completedColor != null && !this.completedColor.isDisposed()) {
            this.completedColor.dispose();
        }
        if (this.errorColor != null && !this.errorColor.isDisposed()) {
            this.errorColor.dispose();
        }
        if (this.bgColor != null && !this.bgColor.isDisposed()) {
            this.bgColor.dispose();
        }
        this.listeners.clear();
        super.dispose();
    }

    public static interface AgentRunListener {
        public void onCancelRequested();
    }

    public static enum AgentState {
        IDLE,
        THINKING,
        TOOL_EXECUTING,
        AWAITING_CONFIRMATION,
        COMPLETED,
        CANCELLED,
        ERROR;

    }

    public static class ToolStatusWidget
    extends Composite {
        private final String toolName;
        private final String toolCallId;
        private ToolStatus status = ToolStatus.PENDING;
        private Label statusIcon;
        private Label nameLabel;
        private Label detailLabel;

        public ToolStatusWidget(Composite parent, String toolName, String toolCallId) {
            super(parent, 0);
            this.toolName = toolName;
            this.toolCallId = toolCallId;
            this.createContents();
        }

        private void createContents() {
            GridLayout layout = new GridLayout(3, false);
            layout.marginWidth = 4;
            layout.marginHeight = 2;
            layout.horizontalSpacing = 8;
            this.setLayout((Layout)layout);
            this.statusIcon = new Label((Composite)this, 0);
            this.statusIcon.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.updateStatusIcon();
            this.nameLabel = new Label((Composite)this, 0);
            this.nameLabel.setText(this.getDisplayName(this.toolName));
            this.nameLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.detailLabel = new Label((Composite)this, 0);
            this.detailLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }

        private String getDisplayName(String name) {
            return switch (name) {
                case "read_file" -> "\u0427\u0442\u0435\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430";
                case "edit_file" -> "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430";
                case "list_files" -> "\u0421\u043f\u0438\u0441\u043e\u043a \u0444\u0430\u0439\u043b\u043e\u0432";
                case "grep" -> "\u041f\u043e\u0438\u0441\u043a \u0442\u0435\u043a\u0441\u0442\u0430";
                case "search_codebase" -> "\u041f\u043e\u0438\u0441\u043a \u043f\u043e \u043a\u043e\u0434\u0443";
                default -> name;
            };
        }

        private void updateStatusIcon() {
            String icon = switch (this.status) {
                case ToolStatus.PENDING -> "\u25cb";
                case ToolStatus.EXECUTING -> "\u25c9";
                case ToolStatus.COMPLETED -> "\u2713";
                case ToolStatus.FAILED -> "\u2715";
                case ToolStatus.SKIPPED -> "\u25cb";
                default -> throw new IncompatibleClassChangeError();
            };
            this.statusIcon.setText(icon);
        }

        public void updateStatus(ToolStatus newStatus) {
            this.status = newStatus;
            Display.getDefault().asyncExec(() -> {
                if (!this.isDisposed()) {
                    this.updateStatusIcon();
                    this.layout(true);
                }
            });
        }

        public void updateStatus(ToolStatus newStatus, String detail) {
            this.status = newStatus;
            Display.getDefault().asyncExec(() -> {
                if (!this.isDisposed()) {
                    this.updateStatusIcon();
                    this.detailLabel.setText(detail != null ? detail : "");
                    this.layout(true);
                }
            });
        }

        public String getToolCallId() {
            return this.toolCallId;
        }

        public static enum ToolStatus {
            PENDING,
            EXECUTING,
            COMPLETED,
            FAILED,
            SKIPPED;

        }
    }
}

