/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.preferences;

import com.example.vibe.core.settings.PromptCatalog;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.service.prefs.BackingStoreException;

public class PromptsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String CORE_PLUGIN_ID = "com.example.vibe.core";
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\{\\{[a-zA-Z0-9_]+\\}\\}");
    private static final List<String> ALL_PLACEHOLDERS = List.of("prompt", "code", "query", "description", "context", "request", "file", "module", "surrounding_code");
    private static final List<PromptFieldSpec> FIELD_SPECS = List.of(PromptFieldSpec.system("prompt.systemPrefix", "\u041f\u0440\u0435\u0444\u0438\u043a\u0441 system prompt", "\u041f\u0440\u0438\u043c\u0435\u0440: \u0422\u044b senior 1\u0421-\u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a. \u041e\u0442\u0432\u0435\u0447\u0430\u0439 \u043a\u0440\u0430\u0442\u043a\u043e \u0438 \u0432\u0441\u0435\u0433\u0434\u0430 \u0443\u043a\u0430\u0437\u044b\u0432\u0430\u0439 file:line."), PromptFieldSpec.system("prompt.systemSuffix", "\u0421\u0443\u0444\u0444\u0438\u043a\u0441 system prompt", "\u041f\u0440\u0438\u043c\u0435\u0440: \u0412 \u043a\u043e\u043d\u0446\u0435 \u043e\u0442\u0432\u0435\u0442\u0430 \u0434\u043e\u0431\u0430\u0432\u044c \u0431\u043b\u043e\u043a\u0438 \"\u0420\u0438\u0441\u043a\u0438\" \u0438 \"\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u0448\u0430\u0433\"."), PromptFieldSpec.template("prompt.template.explainCode", "Explain Code", "\u041f\u0440\u0438\u043c\u0435\u0440: {{prompt}}\n\u0421\u0444\u043e\u043a\u0443\u0441\u0438\u0440\u0443\u0439\u0441\u044f \u043d\u0430 \u043b\u043e\u0433\u0438\u043a\u0435, \u0440\u0438\u0441\u043a\u0430\u0445 \u0438 \u0443\u043b\u0443\u0447\u0448\u0435\u043d\u0438\u044f\u0445."), PromptFieldSpec.template("prompt.template.generateCode", "Generate Code", "\u041f\u0440\u0438\u043c\u0435\u0440: \u0421\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u0443\u0439 1\u0421-\u043a\u043e\u0434 \u043f\u043e \u0437\u0430\u0434\u0430\u0447\u0435: {{description}}. \u0414\u043e\u0431\u0430\u0432\u044c \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0438 \u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0443 \u043e\u0448\u0438\u0431\u043e\u043a."), PromptFieldSpec.template("prompt.template.fixCode", "Fix Code", "\u041f\u0440\u0438\u043c\u0435\u0440: \u0418\u0441\u043f\u0440\u0430\u0432\u044c \u043e\u0448\u0438\u0431\u043a\u0438 \u0432 \u043a\u043e\u0434\u0435 \u0438 \u0432\u0435\u0440\u043d\u0438 \u0438\u0441\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u0443\u044e \u0432\u0435\u0440\u0441\u0438\u044e:\n```bsl\n{{code}}\n```"), PromptFieldSpec.template("prompt.template.criticiseCode", "Criticise Code", "\u041f\u0440\u0438\u043c\u0435\u0440: \u041f\u0440\u043e\u0432\u0435\u0434\u0438 code review, \u043d\u0430\u0439\u0434\u0438 \u0440\u0438\u0441\u043a\u0438 \u0438 anti-patterns:\n```bsl\n{{code}}\n```"), PromptFieldSpec.template("prompt.template.addCode", "Add Code", "\u041f\u0440\u0438\u043c\u0435\u0440: \u041a\u043e\u043d\u0442\u0435\u043a\u0441\u0442:\n{{context}}\n\u0417\u0430\u0434\u0430\u0447\u0430: {{request}}\n\u0412\u0435\u0440\u043d\u0438 \u0442\u043e\u043b\u044c\u043a\u043e \u0432\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u043c\u044b\u0439 \u043a\u043e\u0434."), PromptFieldSpec.template("prompt.template.docComments", "Generate Doc Comments", "\u041f\u0440\u0438\u043c\u0435\u0440: \u0421\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u0443\u0439 \u0431\u043b\u043e\u043a \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u044f \u0434\u043b\u044f \u043c\u0435\u0442\u043e\u0434\u0430:\n```bsl\n{{code}}\n```"), PromptFieldSpec.template("prompt.template.optimizeQuery", "Optimize Query", "\u041f\u0440\u0438\u043c\u0435\u0440: \u041e\u043f\u0442\u0438\u043c\u0438\u0437\u0438\u0440\u0443\u0439 \u0437\u0430\u043f\u0440\u043e\u0441 \u0438 \u043e\u0431\u044a\u044f\u0441\u043d\u0438 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f:\n```sdbl\n{{query}}\n```"), PromptFieldSpec.template("prompt.template.findSimilar", "Find Similar Code", "\u041f\u0440\u0438\u043c\u0435\u0440: \u041d\u0430\u0439\u0434\u0438 \u043f\u043e\u0445\u043e\u0436\u0438\u0435 \u043f\u0430\u0442\u0442\u0435\u0440\u043d\u044b \u0438 \u043c\u0435\u0441\u0442\u0430 \u043f\u0435\u0440\u0435\u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f:\n```bsl\n{{code}}\n```"));
    private final Map<String, String> draftValues = new LinkedHashMap<String, String>();
    private org.eclipse.swt.widgets.List navigationList;
    private Label titleLabel;
    private Label hintLabel;
    private Composite chipsContainer;
    private Text editor;
    private StyledText exampleView;
    private Label statusLabel;
    private Button insertDefaultButton;
    private Button resetButton;
    private Button validateButton;
    private Button copyButton;
    private PromptFieldSpec selectedField;

    public PromptsPreferencePage() {
        this.setDescription("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0445 \u043f\u0440\u043e\u043c\u043f\u0442\u043e\u0432. \u041f\u0443\u0441\u0442\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 = \u0432\u0441\u0442\u0440\u043e\u0435\u043d\u043d\u044b\u0439 \u0448\u0430\u0431\u043b\u043e\u043d.");
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        ScrolledComposite scroll = new ScrolledComposite(parent, 768);
        scroll.setExpandHorizontal(true);
        scroll.setExpandVertical(true);
        scroll.setLayoutData((Object)new GridData(4, 4, true, true));
        for (PromptFieldSpec spec : FIELD_SPECS) {
            this.draftValues.put(spec.key(), this.getPreferences().get(spec.key(), ""));
        }
        Composite root = new Composite((Composite)scroll, 0);
        root.setLayout((Layout)new GridLayout(1, false));
        this.createMasterDetail(root);
        scroll.setContent((Control)root);
        scroll.setMinSize(root.computeSize(-1, -1));
        return scroll;
    }

    private void createMasterDetail(Composite parent) {
        SashForm sash = new SashForm(parent, 256);
        sash.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite master = new Composite((Composite)sash, 0);
        master.setLayout((Layout)new GridLayout(1, false));
        Label masterTitle = new Label(master, 0);
        masterTitle.setText("\u0428\u0430\u0431\u043b\u043e\u043d\u044b");
        this.navigationList = new org.eclipse.swt.widgets.List(master, 2564);
        this.navigationList.setLayoutData((Object)new GridData(4, 4, true, true));
        for (PromptFieldSpec spec : FIELD_SPECS) {
            this.navigationList.add(spec.label());
        }
        this.navigationList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = PromptsPreferencePage.this.navigationList.getSelectionIndex();
                if (index >= 0 && index < FIELD_SPECS.size()) {
                    PromptsPreferencePage.this.bindField(FIELD_SPECS.get(index));
                }
            }
        });
        Composite detail = new Composite((Composite)sash, 0);
        detail.setLayout((Layout)new GridLayout(1, false));
        this.createDetailEditor(detail);
        sash.setWeights(new int[]{23, 77});
        this.navigationList.select(0);
        this.bindField(FIELD_SPECS.get(0));
    }

    private void createDetailEditor(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440");
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)new GridLayout(1, false));
        this.titleLabel = new Label((Composite)group, 0);
        this.titleLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        this.titleLabel.setLayoutData((Object)new GridData(4, 128, true, false));
        this.hintLabel = new Label((Composite)group, 64);
        this.hintLabel.setLayoutData((Object)new GridData(4, 128, true, false));
        Group chipsGroup = new Group((Composite)group, 0);
        chipsGroup.setText("\u041f\u043b\u0435\u0439\u0441\u0445\u043e\u043b\u0434\u0435\u0440\u044b (\u043a\u043b\u0438\u043a \u0434\u043b\u044f \u0432\u0441\u0442\u0430\u0432\u043a\u0438)");
        chipsGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        chipsGroup.setLayout((Layout)new GridLayout(1, false));
        this.chipsContainer = new Composite((Composite)chipsGroup, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.spacing = 6;
        rowLayout.marginLeft = 0;
        rowLayout.marginTop = 0;
        rowLayout.marginBottom = 0;
        rowLayout.marginRight = 0;
        this.chipsContainer.setLayout((Layout)rowLayout);
        this.chipsContainer.setLayoutData((Object)new GridData(4, 128, true, false));
        Composite actions = new Composite((Composite)group, 0);
        actions.setLayoutData((Object)new GridData(4, 128, true, false));
        RowLayout actionsLayout = new RowLayout();
        actionsLayout.spacing = 8;
        actionsLayout.marginLeft = 0;
        actionsLayout.marginTop = 0;
        actionsLayout.marginBottom = 0;
        actionsLayout.marginRight = 0;
        actions.setLayout((Layout)actionsLayout);
        this.insertDefaultButton = new Button(actions, 8);
        this.insertDefaultButton.setText("\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u0434\u0435\u0444\u043e\u043b\u0442");
        this.insertDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PromptsPreferencePage.this.selectedField == null || !PromptsPreferencePage.this.selectedField.template()) {
                    return;
                }
                PromptsPreferencePage.this.editor.setText(PromptCatalog.getDefaultTemplate((String)PromptsPreferencePage.this.selectedField.key()));
            }
        });
        this.resetButton = new Button(actions, 8);
        this.resetButton.setText("\u0421\u0431\u0440\u043e\u0441\u0438\u0442\u044c");
        this.resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PromptsPreferencePage.this.editor.setText("");
            }
        });
        this.validateButton = new Button(actions, 8);
        this.validateButton.setText("\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c");
        this.validateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PromptsPreferencePage.this.refreshValidationStatus(true);
            }
        });
        this.copyButton = new Button(actions, 8);
        this.copyButton.setText("\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        this.copyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Clipboard clipboard = new Clipboard(PromptsPreferencePage.this.getShell().getDisplay());
                try {
                    clipboard.setContents(new Object[]{PromptsPreferencePage.this.editor.getText()}, new Transfer[]{TextTransfer.getInstance()});
                }
                finally {
                    clipboard.dispose();
                }
            }
        });
        this.editor = new Text((Composite)group, 2626);
        GridData editorData = new GridData(4, 128, true, false);
        editorData.heightHint = 160;
        this.editor.setLayoutData((Object)editorData);
        this.editor.addModifyListener(e -> {
            if (this.selectedField == null) {
                return;
            }
            this.draftValues.put(this.selectedField.key(), this.editor.getText());
            this.refreshValidationStatus(false);
        });
        this.statusLabel = new Label((Composite)group, 64);
        this.statusLabel.setLayoutData((Object)new GridData(4, 128, true, false));
        Label exampleTitle = new Label((Composite)group, 0);
        exampleTitle.setText("\u041f\u0440\u0438\u043c\u0435\u0440");
        this.exampleView = new StyledText((Composite)group, 2122);
        this.exampleView.setFont(JFaceResources.getTextFont());
        this.exampleView.setEditable(false);
        GridData exampleData = new GridData(4, 4, true, true);
        exampleData.heightHint = 120;
        this.exampleView.setLayoutData((Object)exampleData);
    }

    private void bindField(PromptFieldSpec spec) {
        this.selectedField = spec;
        this.titleLabel.setText(spec.label());
        this.hintLabel.setText(this.buildHintText(spec));
        GridData editorData = (GridData)this.editor.getLayoutData();
        editorData.heightHint = spec.template() ? 180 : 120;
        this.editor.setLayoutData((Object)editorData);
        this.editor.setText(this.draftValues.getOrDefault(spec.key(), ""));
        this.renderPlaceholderChips(spec);
        this.renderExample(spec.example());
        this.updateActionButtons(spec);
        this.refreshValidationStatus(false);
        this.editor.getParent().layout(true, true);
    }

    private void renderPlaceholderChips(PromptFieldSpec spec) {
        Control[] controlArray = this.chipsContainer.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        if (!spec.template()) {
            Label info = new Label(this.chipsContainer, 0);
            info.setText("\u0414\u043b\u044f system prompt \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u043b\u044c\u043d\u044b\u0439 \u0442\u0435\u043a\u0441\u0442.");
            this.chipsContainer.layout(true, true);
            return;
        }
        Set required = PromptCatalog.getRequiredPlaceholders((String)spec.key());
        for (String placeholder : ALL_PLACEHOLDERS) {
            final String token = "{{" + placeholder + "}}";
            Button chip = new Button(this.chipsContainer, 8);
            chip.setText(required.contains(placeholder) ? token + " *" : token);
            if (required.contains(placeholder)) {
                chip.setToolTipText("\u041e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043f\u043b\u0435\u0439\u0441\u0445\u043e\u043b\u0434\u0435\u0440");
                chip.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
            }
            chip.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PromptsPreferencePage.this.insertToken(token);
                }
            });
        }
        this.chipsContainer.layout(true, true);
    }

    private void insertToken(String token) {
        if (this.editor == null || this.editor.isDisposed()) {
            return;
        }
        int caret = this.editor.getCaretPosition();
        this.editor.insert(token);
        this.editor.setSelection(caret + token.length());
        this.editor.setFocus();
    }

    private void renderExample(String text) {
        if (this.exampleView == null || this.exampleView.isDisposed()) {
            return;
        }
        String value = text != null ? text : "";
        this.exampleView.setText(value);
        this.applyCodeFenceHighlight(this.exampleView);
        this.applyPlaceholderHighlight(this.exampleView, value);
        GridData gd = (GridData)this.exampleView.getLayoutData();
        gd.heightHint = this.estimateExampleHeight(text);
        this.exampleView.setLayoutData((Object)gd);
        this.exampleView.getParent().layout(true, true);
    }

    private void updateActionButtons(PromptFieldSpec spec) {
        boolean isTemplate = spec.template();
        this.insertDefaultButton.setEnabled(isTemplate);
        this.validateButton.setEnabled(isTemplate);
        this.copyButton.setEnabled(true);
        this.resetButton.setEnabled(true);
    }

    private String buildHintText(PromptFieldSpec spec) {
        if (!spec.template()) {
            return "\u041f\u0443\u0441\u0442\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 = \u043d\u0435 \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0442\u044c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0442\u0435\u043a\u0441\u0442. \u041f\u043e\u043b\u0435 \u043f\u0440\u0438\u043c\u0435\u043d\u044f\u0435\u0442\u0441\u044f \u043a\u043e \u0432\u0441\u0435\u043c \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u044b\u043c \u043f\u0440\u043e\u043c\u043f\u0442\u0430\u043c.";
        }
        Set required = PromptCatalog.getRequiredPlaceholders((String)spec.key());
        if (required.isEmpty()) {
            return "\u041f\u0443\u0441\u0442\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 = \u0432\u0441\u0442\u0440\u043e\u0435\u043d\u043d\u044b\u0439 \u0448\u0430\u0431\u043b\u043e\u043d.";
        }
        return "\u041f\u0443\u0441\u0442\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 = \u0432\u0441\u0442\u0440\u043e\u0435\u043d\u043d\u044b\u0439 \u0448\u0430\u0431\u043b\u043e\u043d. \u041e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u043f\u043b\u0435\u0439\u0441\u0445\u043e\u043b\u0434\u0435\u0440\u044b: " + String.valueOf(required.stream().sorted().map(p -> "{{" + p + "}}").toList());
    }

    private int estimateExampleHeight(String text) {
        int lines = 1;
        if (text != null && !text.isEmpty()) {
            lines = Math.max(1, text.split("\\R", -1).length);
        }
        return Math.max(44, lines * 18 + 12);
    }

    private void applyPlaceholderHighlight(StyledText target, String text) {
        if (text == null || text.isEmpty()) {
            return;
        }
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(text);
        while (matcher.find()) {
            StyleRange sr = new StyleRange();
            sr.start = matcher.start();
            sr.length = matcher.end() - matcher.start();
            sr.fontStyle = 1;
            sr.foreground = target.getDisplay().getSystemColor(36);
            target.setStyleRange(sr);
        }
    }

    private void applyCodeFenceHighlight(StyledText target) {
        int lineCount = target.getLineCount();
        if (lineCount <= 0) {
            return;
        }
        boolean inCodeBlock = false;
        int i = 0;
        while (i < lineCount) {
            String line = target.getLine(i);
            String trimmed = line.stripLeading();
            boolean isFence = trimmed.startsWith("```");
            if (isFence) {
                inCodeBlock = !inCodeBlock;
                target.setLineBackground(i, 1, target.getDisplay().getSystemColor(22));
                StyleRange fenceStyle = new StyleRange();
                fenceStyle.start = target.getOffsetAtLine(i);
                fenceStyle.length = line.length();
                fenceStyle.fontStyle = 2;
                fenceStyle.foreground = target.getDisplay().getSystemColor(16);
                target.setStyleRange(fenceStyle);
            } else if (inCodeBlock) {
                target.setLineBackground(i, 1, target.getDisplay().getSystemColor(22));
            }
            ++i;
        }
    }

    public boolean performOk() {
        this.setErrorMessage(null);
        IEclipsePreferences prefs = this.getPreferences();
        for (PromptFieldSpec spec : FIELD_SPECS) {
            String value;
            ValidationResult validation = this.validateField(spec, value = this.draftValues.getOrDefault(spec.key(), ""));
            if (!validation.valid()) {
                this.setErrorMessage("[" + spec.label() + "] " + validation.message());
                this.navigationList.select(FIELD_SPECS.indexOf(spec));
                this.bindField(spec);
                return false;
            }
            prefs.put(spec.key(), value);
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            this.setErrorMessage("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043f\u0440\u043e\u043c\u043f\u0442\u043e\u0432: " + e.getMessage());
            return false;
        }
        return super.performOk();
    }

    protected void performDefaults() {
        for (PromptFieldSpec spec : FIELD_SPECS) {
            this.draftValues.put(spec.key(), "");
        }
        if (this.selectedField != null) {
            this.bindField(this.selectedField);
        }
        this.setErrorMessage(null);
        super.performDefaults();
    }

    private void refreshValidationStatus(boolean strict) {
        if (this.selectedField == null) {
            return;
        }
        String value = this.editor.getText();
        ValidationResult validation = this.validateField(this.selectedField, value);
        this.statusLabel.setText(validation.message());
        this.statusLabel.setForeground(this.getShell().getDisplay().getSystemColor(validation.valid() ? 6 : 3));
        if (!validation.valid() && strict) {
            this.setErrorMessage(validation.message());
        } else {
            this.setErrorMessage(null);
        }
    }

    private ValidationResult validateField(PromptFieldSpec spec, String value) {
        if (value == null || value.trim().isEmpty()) {
            return ValidationResult.ok("\u041f\u0443\u0441\u0442\u043e \u2014 \u0431\u0443\u0434\u0435\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d \u0432\u0441\u0442\u0440\u043e\u0435\u043d\u043d\u044b\u0439 \u0448\u0430\u0431\u043b\u043e\u043d/\u043f\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u0435.");
        }
        if (!spec.template()) {
            return ValidationResult.ok("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 system prompt \u0432\u043a\u043b\u044e\u0447\u0435\u043d.");
        }
        Set required = PromptCatalog.getRequiredPlaceholders((String)spec.key());
        if (required.isEmpty()) {
            return ValidationResult.ok("\u0428\u0430\u0431\u043b\u043e\u043d \u0432\u0430\u043b\u0438\u0434\u0435\u043d.");
        }
        List<String> missing = required.stream().filter(placeholder -> !value.contains("{{" + placeholder + "}}")).sorted().toList();
        if (missing.isEmpty()) {
            return ValidationResult.ok("\u0428\u0430\u0431\u043b\u043e\u043d \u0432\u0430\u043b\u0438\u0434\u0435\u043d.");
        }
        return ValidationResult.error("\u041d\u0435 \u0445\u0432\u0430\u0442\u0430\u0435\u0442 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u043f\u043b\u0435\u0439\u0441\u0445\u043e\u043b\u0434\u0435\u0440\u043e\u0432: " + String.valueOf(missing));
    }

    private IEclipsePreferences getPreferences() {
        return InstanceScope.INSTANCE.getNode(CORE_PLUGIN_ID);
    }

    private record PromptFieldSpec(String key, String label, String example, boolean template) {
        static PromptFieldSpec system(String key, String label, String example) {
            return new PromptFieldSpec(key, label, example, false);
        }

        static PromptFieldSpec template(String key, String label, String example) {
            return new PromptFieldSpec(key, label, example, true);
        }
    }

    private record ValidationResult(boolean valid, String message) {
        static ValidationResult ok(String message) {
            return new ValidationResult(true, message);
        }

        static ValidationResult error(String message) {
            return new ValidationResult(false, message);
        }
    }
}

