/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.preferences;

import com.example.vibe.core.mcp.config.McpServerConfig;
import com.example.vibe.ui.internal.Messages;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class McpServerEditDialog
extends TitleAreaDialog {
    private McpServerConfig existingConfig;
    private Text nameText;
    private Button enabledCheckbox;
    private Text commandText;
    private Text argsText;
    private List<Map.Entry<String, String>> envVariables = new ArrayList<Map.Entry<String, String>>();
    private TableViewer envTableViewer;
    private Text workingDirText;
    private Spinner connectionTimeoutSpinner;
    private Spinner requestTimeoutSpinner;
    private McpServerConfig savedConfig;

    public McpServerEditDialog(Shell parentShell, McpServerConfig existingConfig) {
        super(parentShell);
        this.existingConfig = existingConfig;
        if (existingConfig != null) {
            existingConfig.getEnv().forEach((k, v) -> {
                boolean bl = this.envVariables.add(new AbstractMap.SimpleEntry<String, String>((String)k, (String)v));
            });
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.existingConfig == null ? Messages.McpServerEditDialog_TitleAdd : Messages.McpServerEditDialog_TitleEdit);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.existingConfig == null ? Messages.McpServerEditDialog_TitleAdd : Messages.McpServerEditDialog_TitleEdit);
        this.setMessage(Messages.McpServerEditDialog_Description);
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)new GridLayout(2, false));
        this.createLabel(container, Messages.McpServerEditDialog_Name);
        this.nameText = new Text(container, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.existingConfig != null) {
            this.nameText.setText(this.existingConfig.getName());
        }
        this.enabledCheckbox = new Button(container, 32);
        this.enabledCheckbox.setText(Messages.McpServerEditDialog_Enabled);
        this.enabledCheckbox.setSelection(this.existingConfig == null || this.existingConfig.isEnabled());
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.enabledCheckbox.setLayoutData((Object)gd);
        this.createLabel(container, Messages.McpServerEditDialog_Command);
        this.commandText = new Text(container, 2048);
        this.commandText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.commandText.setMessage("npx, node, python...");
        if (this.existingConfig != null) {
            this.commandText.setText(this.existingConfig.getCommand());
        }
        this.createLabel(container, Messages.McpServerEditDialog_Arguments);
        this.argsText = new Text(container, 2048);
        this.argsText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.argsText.setMessage("-y @modelcontextprotocol/server-filesystem /path");
        if (this.existingConfig != null && !this.existingConfig.getArgs().isEmpty()) {
            this.argsText.setText(String.join((CharSequence)" ", this.existingConfig.getArgs()));
        }
        this.createLabel(container, Messages.McpServerEditDialog_WorkingDirectory);
        Composite dirComposite = new Composite(container, 0);
        dirComposite.setLayout((Layout)new GridLayout(2, false));
        dirComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.workingDirText = new Text(dirComposite, 2048);
        this.workingDirText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.existingConfig != null && this.existingConfig.getWorkingDirectory() != null) {
            this.workingDirText.setText(this.existingConfig.getWorkingDirectory());
        }
        Button browseButton = new Button(dirComposite, 8);
        browseButton.setText(Messages.McpServerEditDialog_Browse);
        browseButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.browseDirectory()));
        this.createLabel(container, Messages.McpServerEditDialog_Environment);
        this.createEnvTable(container);
        this.createLabel(container, Messages.McpServerEditDialog_ConnectionTimeout);
        this.connectionTimeoutSpinner = new Spinner(container, 2048);
        this.connectionTimeoutSpinner.setMinimum(5);
        this.connectionTimeoutSpinner.setMaximum(120);
        this.connectionTimeoutSpinner.setSelection(this.existingConfig != null ? this.existingConfig.getConnectionTimeoutMs() / 1000 : 30);
        this.createLabel(container, Messages.McpServerEditDialog_RequestTimeout);
        this.requestTimeoutSpinner = new Spinner(container, 2048);
        this.requestTimeoutSpinner.setMinimum(10);
        this.requestTimeoutSpinner.setMaximum(300);
        this.requestTimeoutSpinner.setSelection(this.existingConfig != null ? this.existingConfig.getRequestTimeoutMs() / 1000 : 60);
        return area;
    }

    private void createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
    }

    private void createEnvTable(Composite parent) {
        Composite envComposite = new Composite(parent, 0);
        envComposite.setLayout((Layout)new GridLayout(2, false));
        envComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.envTableViewer = new TableViewer(envComposite, 67584);
        Table table = this.envTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 80;
        table.setLayoutData((Object)gd);
        TableColumn keyCol = new TableColumn(table, 0);
        keyCol.setText(Messages.McpServerEditDialog_EnvKey);
        keyCol.setWidth(120);
        TableColumn valueCol = new TableColumn(table, 0);
        valueCol.setText(Messages.McpServerEditDialog_EnvValue);
        valueCol.setWidth(180);
        this.envTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.envTableViewer.setLabelProvider((IBaseLabelProvider)new EnvLabelProvider());
        this.envTableViewer.setInput(this.envVariables);
        Composite envButtons = new Composite(envComposite, 0);
        envButtons.setLayout((Layout)new GridLayout(1, false));
        envButtons.setLayoutData((Object)new GridData(4, 128, false, false));
        Button addEnvButton = new Button(envButtons, 8);
        addEnvButton.setText(Messages.McpServerEditDialog_AddEnv);
        addEnvButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        addEnvButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.addEnvVariable()));
        Button removeEnvButton = new Button(envButtons, 8);
        removeEnvButton.setText(Messages.McpServerEditDialog_RemoveEnv);
        removeEnvButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        removeEnvButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.removeEnvVariable()));
    }

    private void addEnvVariable() {
        InputDialog keyDialog = new InputDialog(this.getShell(), Messages.McpServerEditDialog_EnvKey, Messages.McpServerEditDialog_EnvKeyPrompt, "", null);
        if (keyDialog.open() == 0) {
            String key = keyDialog.getValue();
            InputDialog valueDialog = new InputDialog(this.getShell(), Messages.McpServerEditDialog_EnvValue, Messages.McpServerEditDialog_EnvValuePrompt, "", null);
            if (valueDialog.open() == 0) {
                this.envVariables.add(new AbstractMap.SimpleEntry<String, String>(key, valueDialog.getValue()));
                this.envTableViewer.refresh();
            }
        }
    }

    private void removeEnvVariable() {
        IStructuredSelection selection = this.envTableViewer.getStructuredSelection();
        if (!selection.isEmpty()) {
            this.envVariables.remove(selection.getFirstElement());
            this.envTableViewer.refresh();
        }
    }

    private void browseDirectory() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setText(Messages.McpServerEditDialog_SelectDirectory);
        String path = dialog.open();
        if (path != null) {
            this.workingDirText.setText(path);
        }
    }

    protected void okPressed() {
        if (!this.validateInput()) {
            return;
        }
        this.savedConfig = this.buildServerConfig();
        super.okPressed();
    }

    private boolean validateInput() {
        if (this.nameText.getText().trim().isEmpty()) {
            this.setErrorMessage(Messages.McpServerEditDialog_NameRequired);
            this.nameText.setFocus();
            return false;
        }
        if (this.commandText.getText().trim().isEmpty()) {
            this.setErrorMessage(Messages.McpServerEditDialog_CommandRequired);
            this.commandText.setFocus();
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public McpServerConfig getServerConfig() {
        return this.savedConfig;
    }

    private McpServerConfig buildServerConfig() {
        String workDir;
        McpServerConfig.Builder builder = McpServerConfig.builder().name(this.nameText.getText().trim()).enabled(this.enabledCheckbox.getSelection()).command(this.commandText.getText().trim()).args(this.parseArgs(this.argsText.getText())).connectionTimeout(this.connectionTimeoutSpinner.getSelection() * 1000).requestTimeout(this.requestTimeoutSpinner.getSelection() * 1000);
        if (this.existingConfig != null) {
            builder.id(this.existingConfig.getId());
        }
        if (!(workDir = this.workingDirText.getText().trim()).isEmpty()) {
            builder.workingDirectory(workDir);
        }
        for (Map.Entry<String, String> entry : this.envVariables) {
            builder.putEnv(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }

    private List<String> parseArgs(String argsString) {
        ArrayList<String> args = new ArrayList<String>();
        if (argsString == null || argsString.trim().isEmpty()) {
            return args;
        }
        StringBuilder current = new StringBuilder();
        boolean inQuotes = false;
        char quoteChar = '\u0000';
        char[] cArray = argsString.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!(c != '\"' && c != '\'' || inQuotes)) {
                inQuotes = true;
                quoteChar = c;
            } else if (c == quoteChar && inQuotes) {
                inQuotes = false;
                quoteChar = '\u0000';
            } else if (c == ' ' && !inQuotes) {
                if (current.length() > 0) {
                    args.add(current.toString());
                    current = new StringBuilder();
                }
            } else {
                current.append(c);
            }
            ++n2;
        }
        if (current.length() > 0) {
            args.add(current.toString());
        }
        return args;
    }

    private static class EnvLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private EnvLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            Map.Entry entry = (Map.Entry)element;
            return columnIndex == 0 ? (String)entry.getKey() : (String)entry.getValue();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

