/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.menu;

import com.example.vibe.core.context.CodeContextAnalyzer;
import com.example.vibe.core.context.Messages;
import com.example.vibe.core.logging.VibeLogger;
import com.example.vibe.ui.internal.VibeUiPlugin;
import com.example.vibe.ui.menu.MenuMessages;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.texteditor.ITextEditor;

public class DynamicMenuContributor
extends CompoundContributionItem {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(DynamicMenuContributor.class);
    private static final String MENU_ID = "com.example.vibe.ui.dynamicMenu";
    private final CodeContextAnalyzer analyzer = new CodeContextAnalyzer();

    protected IContributionItem[] getContributionItems() {
        List<CodeContextAnalyzer.SuggestedAction> chatActions;
        List<CodeContextAnalyzer.SuggestedAction> editActions;
        LOG.debug("getContributionItems: \u043d\u0430\u0447\u0430\u043b\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043f\u0443\u043d\u043a\u0442\u043e\u0432 \u043c\u0435\u043d\u044e");
        ArrayList<Object> items = new ArrayList<Object>();
        String selectedText = this.getSelectedText();
        Object[] objectArray = new Object[1];
        objectArray[0] = selectedText != null ? (selectedText.length() > 50 ? selectedText.substring(0, 50) + "..." : selectedText) : "null";
        LOG.debug("getContributionItems: \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0439 \u0442\u0435\u043a\u0441\u0442=%s", objectArray);
        CodeContextAnalyzer.AnalysisResult result = this.analyzer.analyze(selectedText, null, null);
        LOG.debug("getContributionItems: \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0430\u043d\u0430\u043b\u0438\u0437\u0430 - \u0442\u0438\u043f=%s, \u0441\u0438\u043c\u0432\u043e\u043b=%s", new Object[]{result.getType(), result.getSymbolName()});
        ArrayList<CodeContextAnalyzer.SuggestedAction> actions = new ArrayList<CodeContextAnalyzer.SuggestedAction>(result.getSuggestedActions());
        actions.sort(Comparator.comparingInt(CodeContextAnalyzer.SuggestedAction::getPriority));
        LOG.debug("getContributionItems: \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u043e %d \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0439", new Object[]{actions.size()});
        Map<CodeContextAnalyzer.ActionCategory, List<CodeContextAnalyzer.SuggestedAction>> grouped = this.groupByCategory(actions);
        List<CodeContextAnalyzer.SuggestedAction> quickActions = grouped.get(CodeContextAnalyzer.ActionCategory.QUICK_ACTION);
        if (quickActions != null && !quickActions.isEmpty()) {
            items.add(this.createSeparator("quickActions", Messages.Menu_QuickActions));
            for (CodeContextAnalyzer.SuggestedAction action : quickActions) {
                items.add(this.createCommandItem(action));
            }
        }
        if ((editActions = grouped.get(CodeContextAnalyzer.ActionCategory.EDIT_ACTION)) != null && !editActions.isEmpty()) {
            items.add(this.createSeparator("editActions", Messages.Menu_EditCode));
            for (CodeContextAnalyzer.SuggestedAction action : editActions) {
                items.add(this.createCommandItem(action));
            }
        }
        if ((chatActions = grouped.get(CodeContextAnalyzer.ActionCategory.CHAT_ACTION)) != null && !chatActions.isEmpty()) {
            items.add(new Separator("chatActions"));
            for (CodeContextAnalyzer.SuggestedAction action : chatActions) {
                items.add(this.createCommandItem(action));
            }
        }
        items.add(new Separator("settings"));
        items.add(this.createSettingsSubmenu());
        return items.toArray(new IContributionItem[0]);
    }

    private Map<CodeContextAnalyzer.ActionCategory, List<CodeContextAnalyzer.SuggestedAction>> groupByCategory(List<CodeContextAnalyzer.SuggestedAction> actions) {
        LinkedHashMap<CodeContextAnalyzer.ActionCategory, List<CodeContextAnalyzer.SuggestedAction>> grouped = new LinkedHashMap<CodeContextAnalyzer.ActionCategory, List<CodeContextAnalyzer.SuggestedAction>>();
        for (CodeContextAnalyzer.SuggestedAction action : actions) {
            grouped.computeIfAbsent(action.getCategory(), k -> new ArrayList()).add(action);
        }
        return grouped;
    }

    /*
     * WARNING - void declaration
     */
    private String getSelectedText() {
        LOG.debug("getSelectedText: \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u0442\u0435\u043a\u0441\u0442\u0430");
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            LOG.warn("getSelectedText: \u043e\u043a\u043d\u043e workbench = null");
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            LOG.warn("getSelectedText: \u0430\u043a\u0442\u0438\u0432\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430 = null");
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        LOG.debug("getSelectedText: \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440=%s", new Object[]{editor != null ? editor.getClass().getName() : "null"});
        IEditorPart iEditorPart = editor;
        if (iEditorPart instanceof ITextEditor) {
            void textEditor;
            ITextEditor iTextEditor = (ITextEditor)iEditorPart;
            ITextEditor cfr_ignored_0 = (ITextEditor)iEditorPart;
            ISelection selection = textEditor.getSelectionProvider().getSelection();
            LOG.debug("getSelectedText: selection=%s", new Object[]{selection != null ? selection.getClass().getName() : "null"});
            ISelection iSelection = selection;
            if (iSelection instanceof ITextSelection) {
                void textSelection;
                ITextSelection iTextSelection = (ITextSelection)iSelection;
                ITextSelection cfr_ignored_1 = (ITextSelection)iSelection;
                String text = textSelection.getText();
                LOG.debug("getSelectedText: \u043f\u043e\u043b\u0443\u0447\u0435\u043d \u0442\u0435\u043a\u0441\u0442 \u0434\u043b\u0438\u043d\u043e\u0439 %d \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432", new Object[]{text != null ? text.length() : 0});
                return text;
            }
        }
        LOG.warn("getSelectedText: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0442\u0435\u043a\u0441\u0442 \u0438\u0437 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0430");
        return null;
    }

    private IContributionItem createSeparator(String id, final String label) {
        if (label == null || label.isEmpty()) {
            return new Separator(id);
        }
        return new ContributionItem(id){

            public void fill(Menu menu, int index) {
                MenuItem item = new MenuItem(menu, 2, index);
                item.setEnabled(false);
                MenuItem labelItem = new MenuItem(menu, 8, index + 1);
                labelItem.setText(label);
                labelItem.setEnabled(false);
            }

            public boolean isSeparator() {
                return true;
            }
        };
    }

    private IContributionItem createCommandItem(final CodeContextAnalyzer.SuggestedAction action) {
        LOG.debug("createCommandItem: \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0443\u043d\u043a\u0442\u0430 \u043c\u0435\u043d\u044e id='%s', label='%s', commandId='%s'", new Object[]{action.getId(), action.getLabel(), action.getCommandId()});
        return new ContributionItem(action.getId()){

            public void fill(Menu menu, int index) {
                LOG.debug("fill: \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u043f\u0443\u043d\u043a\u0442\u0430 \u043c\u0435\u043d\u044e '%s' \u0432 \u043f\u043e\u0437\u0438\u0446\u0438\u0438 %d", new Object[]{action.getId(), index});
                MenuItem item = new MenuItem(menu, 8, index);
                Object label = action.getLabel();
                String shortcut = DynamicMenuContributor.this.getCommandShortcut(action.getCommandId());
                if (shortcut != null && !shortcut.isEmpty()) {
                    label = (String)label + "\t" + shortcut;
                }
                item.setText((String)label);
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        LOG.info("widgetSelected: \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0432\u044b\u0431\u0440\u0430\u043b \u043f\u0443\u043d\u043a\u0442 \u043c\u0435\u043d\u044e '%s' (\u043a\u043e\u043c\u0430\u043d\u0434\u0430: %s)", new Object[]{action.getLabel(), action.getCommandId()});
                        DynamicMenuContributor.this.executeCommand(action.getCommandId());
                    }
                });
            }
        };
    }

    private String getCommandShortcut(String commandId) {
        try {
            ParameterizedCommand paramCmd;
            TriggerSequence binding;
            Command command;
            IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            if (bindingService != null && commandService != null && (command = commandService.getCommand(commandId)) != null && command.isDefined() && (binding = bindingService.getBestActiveBindingFor(paramCmd = new ParameterizedCommand(command, null))) != null) {
                return binding.format();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private void executeCommand(String commandId) {
        LOG.info("executeCommand: \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u043a\u043e\u043c\u0430\u043d\u0434\u044b '%s'", new Object[]{commandId});
        try {
            IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            if (handlerService == null) {
                LOG.error("executeCommand: IHandlerService = null, \u043a\u043e\u043c\u0430\u043d\u0434\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430");
                return;
            }
            LOG.debug("executeCommand: \u0432\u044b\u0437\u043e\u0432 handlerService.executeCommand('%s')", new Object[]{commandId});
            Object result = handlerService.executeCommand(commandId, null);
            LOG.debug("executeCommand: \u043a\u043e\u043c\u0430\u043d\u0434\u0430 '%s' \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430, \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442=%s", new Object[]{commandId, result});
        }
        catch (Exception e) {
            LOG.error("executeCommand: \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u043a\u043e\u043c\u0430\u043d\u0434\u044b '%s': %s - %s", new Object[]{commandId, e.getClass().getSimpleName(), e.getMessage()});
            VibeUiPlugin.log(e);
        }
    }

    private IContributionItem createSettingsSubmenu() {
        MenuManager settingsMenu = new MenuManager(Messages.Menu_VibeCopilot, "com.example.vibe.ui.settingsMenu");
        settingsMenu.add((IContributionItem)new ContributionItem("openPreferences"){

            public void fill(Menu menu, int index) {
                MenuItem item = new MenuItem(menu, 8, index);
                item.setText(MenuMessages.Menu_Settings);
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        DynamicMenuContributor.this.openPreferences();
                    }
                });
            }
        });
        return settingsMenu;
    }

    private void openPreferences() {
        PreferencesUtil.createPreferenceDialogOn(null, (String)"com.example.vibe.ui.preferences.VibePreferencePage", null, null).open();
    }
}

