/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.internal;

import com.example.vibe.core.tools.ITool;
import com.example.vibe.core.tools.ToolRegistry;
import com.example.vibe.ui.theme.ThemeManager;
import com.example.vibe.ui.tools.GetDiagnosticsTool;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class VibeUiPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.example.vibe.ui";
    private static VibeUiPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        VibeUiPlugin.log("1C Copilot UI plugin started");
        this.initializeAsync();
    }

    private void initializeAsync() {
        Display finalDisplay;
        Display display = null;
        try {
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench != null) {
                display = workbench.getDisplay();
            }
        }
        catch (IllegalStateException illegalStateException) {}
        if (display == null) {
            display = Display.getDefault();
        }
        if ((finalDisplay = display) != null && !finalDisplay.isDisposed()) {
            finalDisplay.asyncExec(() -> {
                try {
                    if (PlatformUI.isWorkbenchRunning()) {
                        ThemeManager.getInstance().initialize(finalDisplay);
                        VibeUiPlugin.log("Theme manager initialized");
                        this.registerUiTools();
                        VibeUiPlugin.log("UI tools registered");
                    }
                }
                catch (Exception e) {
                    VibeUiPlugin.log(e);
                }
            });
        }
    }

    public void stop(BundleContext context) throws Exception {
        VibeUiPlugin.log("1C Copilot UI plugin stopping");
        try {
            ThemeManager.getInstance().dispose();
        }
        catch (Exception e) {
            VibeUiPlugin.log(e);
        }
        plugin = null;
        super.stop(context);
    }

    private void registerUiTools() {
        ToolRegistry registry = ToolRegistry.getInstance();
        registry.registerDynamicTool((ITool)new GetDiagnosticsTool());
    }

    public static VibeUiPlugin getDefault() {
        return plugin;
    }

    public static void log(Throwable e) {
        if (plugin != null) {
            plugin.getLog().log((IStatus)new Status(4, PLUGIN_ID, e.getMessage(), e));
        }
    }

    public static void log(String message) {
        if (plugin != null) {
            plugin.getLog().log((IStatus)new Status(1, PLUGIN_ID, message));
        }
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return VibeUiPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }
}

