/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.handlers;

import com.example.vibe.core.logging.VibeLogger;
import com.example.vibe.core.settings.PromptCatalog;
import com.example.vibe.core.settings.PromptTemplateService;
import com.example.vibe.ui.views.ChatView;
import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;

public class OptimizeQueryHandler
extends AbstractHandler {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(OptimizeQueryHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ChatView chatView;
        String selectedText;
        block8: {
            LOG.info("execute: \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a OptimizeQuery \u0432\u044b\u0437\u0432\u0430\u043d");
            IWorkbenchWindow window = null;
            if (event != null) {
                window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
                LOG.debug("execute: \u043e\u043a\u043d\u043e \u0438\u0437 \u0441\u043e\u0431\u044b\u0442\u0438\u044f=%s", new Object[]{window != null ? "\u043f\u043e\u043b\u0443\u0447\u0435\u043d\u043e" : "null"});
            }
            if (window == null) {
                window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                LOG.debug("execute: \u043e\u043a\u043d\u043e \u0438\u0437 PlatformUI=%s", new Object[]{window != null ? "\u043f\u043e\u043b\u0443\u0447\u0435\u043d\u043e" : "null"});
            }
            if (window == null) {
                LOG.error("execute: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043e\u043a\u043d\u043e workbench, \u0432\u044b\u0445\u043e\u0434");
                return null;
            }
            IWorkbenchPage page = window.getActivePage();
            if (page == null) {
                LOG.error("execute: \u0430\u043a\u0442\u0438\u0432\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430 = null, \u0432\u044b\u0445\u043e\u0434");
                return null;
            }
            selectedText = this.getSelectedText(page);
            LOG.debug("execute: \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0439 \u0442\u0435\u043a\u0441\u0442 \u0434\u043b\u0438\u043d\u043e\u0439 %d \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432", new Object[]{selectedText != null ? selectedText.length() : 0});
            if (selectedText == null || selectedText.trim().isEmpty()) {
                LOG.warn("execute: \u043d\u0435\u0442 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u0442\u0435\u043a\u0441\u0442\u0430, \u0432\u044b\u0445\u043e\u0434");
                return null;
            }
            try {
                LOG.debug("execute: \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u0435 ChatView...");
                chatView = (ChatView)page.showView("com.example.vibe.ui.views.ChatView");
                if (chatView != null) break block8;
                LOG.error("execute: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0442\u043a\u0440\u044b\u0442\u044c ChatView (null)");
                return null;
            }
            catch (PartInitException e) {
                LOG.error("execute: \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u0438 ChatView: %s", new Object[]{e.getMessage()});
                throw new ExecutionException("Failed to open Chat view", (Throwable)e);
            }
        }
        String message = this.buildOptimizeQueryPrompt(selectedText);
        LOG.info("execute: \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u0432 ChatView (\u0434\u043b\u0438\u043d\u0430=%d)", new Object[]{message.length()});
        chatView.sendProgrammaticMessage(message);
        LOG.debug("execute: \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private String getSelectedText(IWorkbenchPage page) {
        ISelection selection;
        ISelection iSelection;
        ISelection selection2;
        ISelection iSelection2;
        ISelectionProvider selectionProvider;
        IEditorPart editor = page.getActiveEditor();
        LOG.debug("getSelectedText: \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440=%s", new Object[]{editor != null ? editor.getClass().getName() : "null"});
        if (editor == null) {
            return null;
        }
        ITextEditor textEditor = null;
        if (editor instanceof ITextEditor) {
            textEditor = (ITextEditor)editor;
        }
        if (textEditor == null && editor instanceof IAdaptable) {
            textEditor = (ITextEditor)editor.getAdapter(ITextEditor.class);
        }
        if (textEditor == null && (selectionProvider = editor.getSite().getSelectionProvider()) != null && (iSelection2 = (selection2 = selectionProvider.getSelection())) instanceof ITextSelection) {
            void textSelection;
            ITextSelection iTextSelection = (ITextSelection)iSelection2;
            ITextSelection cfr_ignored_0 = (ITextSelection)iSelection2;
            return textSelection.getText();
        }
        if (textEditor != null && (iSelection = (selection = textEditor.getSelectionProvider().getSelection())) instanceof ITextSelection) {
            void textSelection;
            selection2 = (ITextSelection)iSelection;
            ITextSelection cfr_ignored_1 = (ITextSelection)iSelection;
            return textSelection.getText();
        }
        LOG.warn("getSelectedText: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0439 \u0442\u0435\u043a\u0441\u0442");
        return null;
    }

    private String buildOptimizeQueryPrompt(String queryText) {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("query", queryText);
        String preferenceKey = "prompt.template.optimizeQuery";
        return PromptTemplateService.getInstance().applyTemplate(preferenceKey, PromptCatalog.getDefaultTemplate((String)preferenceKey), variables, PromptCatalog.getRequiredPlaceholders((String)preferenceKey));
    }
}

