/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.handlers;

import com.example.vibe.bsl.parser.BslMethodParser;
import com.example.vibe.core.logging.VibeLogger;
import com.example.vibe.core.settings.PromptCatalog;
import com.example.vibe.core.settings.PromptTemplateService;
import com.example.vibe.ui.views.ChatView;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;

public class ExplainCodeHandler
extends AbstractHandler {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(ExplainCodeHandler.class);
    private static final int MAX_CONTEXT_LINES = 50;
    private static final int MAX_DOCUMENT_CHARS = 8000;
    private final BslMethodParser bslParser = new BslMethodParser();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ChatView chatView;
        EditorContext context;
        block8: {
            LOG.info("execute: \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a ExplainCode \u0432\u044b\u0437\u0432\u0430\u043d");
            IWorkbenchWindow window = null;
            if (event != null) {
                window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
                LOG.debug("execute: \u043e\u043a\u043d\u043e \u0438\u0437 \u0441\u043e\u0431\u044b\u0442\u0438\u044f=%s", new Object[]{window != null ? "\u043f\u043e\u043b\u0443\u0447\u0435\u043d\u043e" : "null"});
            }
            if (window == null) {
                window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                LOG.debug("execute: \u043e\u043a\u043d\u043e \u0438\u0437 PlatformUI=%s", new Object[]{window != null ? "\u043f\u043e\u043b\u0443\u0447\u0435\u043d\u043e" : "null"});
            }
            if (window == null) {
                LOG.error("execute: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043e\u043a\u043d\u043e workbench, \u0432\u044b\u0445\u043e\u0434");
                return null;
            }
            IWorkbenchPage page = window.getActivePage();
            if (page == null) {
                LOG.error("execute: \u0430\u043a\u0442\u0438\u0432\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430 = null, \u0432\u044b\u0445\u043e\u0434");
                return null;
            }
            LOG.debug("execute: \u0430\u043a\u0442\u0438\u0432\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0430");
            context = this.getEditorContext(page);
            if (context == null || context.selectedText == null || context.selectedText.trim().isEmpty()) {
                LOG.warn("execute: \u043d\u0435\u0442 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u0442\u0435\u043a\u0441\u0442\u0430, \u0432\u044b\u0445\u043e\u0434");
                return null;
            }
            LOG.info("execute: \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442 \u043f\u043e\u043b\u0443\u0447\u0435\u043d - \u0444\u0430\u0439\u043b: %s, \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043e: %d \u0441\u0438\u043c\u0432., \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442: %d \u0441\u0438\u043c\u0432.", new Object[]{context.fileName, context.selectedText.length(), context.fullDocument != null ? context.fullDocument.length() : 0});
            try {
                LOG.debug("execute: \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u0435 ChatView...");
                chatView = (ChatView)page.showView("com.example.vibe.ui.views.ChatView");
                if (chatView != null) break block8;
                LOG.error("execute: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0442\u043a\u0440\u044b\u0442\u044c ChatView (null)");
                return null;
            }
            catch (PartInitException e) {
                LOG.error("execute: \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u0438 ChatView: %s", new Object[]{e.getMessage()});
                throw new ExecutionException("Failed to open Chat view", (Throwable)e);
            }
        }
        LOG.debug("execute: ChatView \u043e\u0442\u043a\u0440\u044b\u0442 \u0443\u0441\u043f\u0435\u0448\u043d\u043e");
        String message = this.buildExplainPromptWithContext(context);
        LOG.info("execute: \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u0432 ChatView (\u0434\u043b\u0438\u043d\u0430=%d)", new Object[]{message.length()});
        chatView.sendProgrammaticMessage(message);
        LOG.debug("execute: \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected EditorContext getEditorContext(IWorkbenchPage page) {
        IEditorPart editor = page.getActiveEditor();
        if (editor == null) {
            return null;
        }
        EditorContext context = new EditorContext();
        IEditorInput input = editor.getEditorInput();
        IEditorInput iEditorInput = input;
        if (iEditorInput instanceof IFileEditorInput) {
            void fileInput;
            IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
            IFileEditorInput cfr_ignored_0 = (IFileEditorInput)iEditorInput;
            context.filePath = fileInput.getFile().getFullPath().toString();
            context.fileName = fileInput.getFile().getName();
            context.moduleType = this.detectModuleType(context.filePath);
        } else if (input != null) {
            context.fileName = input.getName();
        }
        ITextEditor textEditor = null;
        if (editor instanceof ITextEditor) {
            textEditor = (ITextEditor)editor;
        } else if (editor instanceof IAdaptable) {
            textEditor = (ITextEditor)editor.getAdapter(ITextEditor.class);
        }
        if (textEditor != null) {
            LOG.info("getEditorContext: \u043f\u043e\u043b\u0443\u0447\u0435\u043d ITextEditor \u0447\u0435\u0440\u0435\u0437 \u0430\u0434\u0430\u043f\u0442\u0435\u0440");
            IEditorInput textEditorInput = textEditor.getEditorInput();
            document = textEditor.getDocumentProvider().getDocument((Object)textEditorInput);
            LOG.info("getEditorContext: document=%s", new Object[]{document != null ? "\u043f\u043e\u043b\u0443\u0447\u0435\u043d" : "null"});
            if (document != null) {
                context.fullDocument = document.get();
                try {
                    context.totalLines = document.getNumberOfLines();
                }
                catch (Exception exception) {
                    context.totalLines = 0;
                }
                Point point = selection = textEditor.getSelectionProvider().getSelection();
                if (point instanceof ITextSelection) {
                    void textSelection;
                    ITextSelection iTextSelection = (ITextSelection)point;
                    ITextSelection cfr_ignored_1 = (ITextSelection)point;
                    context.selectedText = textSelection.getText();
                    int offset = textSelection.getOffset();
                    int length = textSelection.getLength();
                    if (length > 0) {
                        try {
                            context.selectionStartLine = document.getLineOfOffset(offset);
                            context.selectionEndLine = document.getLineOfOffset(offset + length);
                            context.surroundingCode = this.getSurroundingCode(document, context.selectionStartLine, context.selectionEndLine);
                        }
                        catch (BadLocationException e) {
                            LOG.warn("getEditorContext: \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u043f\u043e\u0437\u0438\u0446\u0438\u0438: %s", new Object[]{e.getMessage()});
                        }
                    }
                }
            }
        } else {
            LOG.info("getEditorContext: ITextEditor \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d, \u043f\u0440\u043e\u0431\u0443\u0435\u043c ISourceViewer");
            ISourceViewer sourceViewer = this.getSourceViewer(editor);
            if (sourceViewer != null) {
                StyledText textWidget;
                document = sourceViewer.getDocument();
                if (document != null) {
                    context.fullDocument = document.get();
                    try {
                        context.totalLines = document.getNumberOfLines();
                    }
                    catch (Exception exception) {
                        context.totalLines = 0;
                    }
                    selection = sourceViewer.getSelectedRange();
                    if (selection.y > 0) {
                        try {
                            context.selectedText = document.get(selection.x, selection.y);
                            context.selectionStartLine = document.getLineOfOffset(selection.x);
                            context.selectionEndLine = document.getLineOfOffset(selection.x + selection.y);
                            context.surroundingCode = this.getSurroundingCode(document, context.selectionStartLine, context.selectionEndLine);
                        }
                        catch (BadLocationException e) {
                            LOG.warn("getEditorContext: \u043e\u0448\u0438\u0431\u043a\u0430: %s", new Object[]{e.getMessage()});
                        }
                    }
                }
                if ((context.selectedText == null || context.selectedText.isEmpty()) && (textWidget = sourceViewer.getTextWidget()) != null && !textWidget.isDisposed()) {
                    context.selectedText = textWidget.getSelectionText();
                }
            }
        }
        if (context.selectedText == null || context.selectedText.isEmpty()) {
            context.selectedText = this.getSelectedText(page);
        }
        if (context.fullDocument != null && this.isBslFile(context.filePath, context.fileName)) {
            LOG.info("getEditorContext: BSL \u0444\u0430\u0439\u043b \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d, \u043f\u0430\u0440\u0441\u0438\u043c \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442 \u043c\u0435\u0442\u043e\u0434\u0430");
            try {
                context.moduleContext = this.bslParser.getModuleContext(context.fullDocument, context.selectionStartLine);
                if (context.moduleContext != null) {
                    context.enclosingMethod = context.moduleContext.enclosingMethod;
                    LOG.info("getEditorContext: BSL \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442 - \u043c\u0435\u0442\u043e\u0434: %s, \u0432\u043d\u0443\u0442\u0440\u0438 \u043c\u0435\u0442\u043e\u0434\u0430: %s", new Object[]{context.enclosingMethod != null ? context.enclosingMethod.name : "\u043d\u0435\u0442", context.moduleContext.isInsideMethod()});
                }
                if (context.selectedText != null && !context.selectedText.isEmpty()) {
                    Set calledMethods = this.bslParser.extractCalledMethods(context.selectedText);
                    LOG.info("getEditorContext: \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0432\u044b\u0437\u043e\u0432\u043e\u0432 \u043c\u0435\u0442\u043e\u0434\u043e\u0432: %d", new Object[]{calledMethods.size()});
                    if (!calledMethods.isEmpty()) {
                        context.calledMethodDefinitions = this.bslParser.findMethodDefinitions(context.fullDocument, calledMethods);
                        LOG.info("getEditorContext: \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0439 \u043c\u0435\u0442\u043e\u0434\u043e\u0432: %d", new Object[]{context.calledMethodDefinitions.size()});
                        for (BslMethodParser.MethodContext def : context.calledMethodDefinitions) {
                            LOG.debug("getEditorContext: \u043d\u0430\u0439\u0434\u0435\u043d \u043c\u0435\u0442\u043e\u0434 %s (\u0441\u0442\u0440\u043e\u043a\u0438 %d-%d)", new Object[]{def.name, def.startLine + 1, def.endLine + 1});
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("getEditorContext: \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u0441\u0438\u043d\u0433\u0430 BSL: %s", new Object[]{e.getMessage()});
            }
        }
        return context;
    }

    private boolean isBslFile(String filePath, String fileName) {
        String lower;
        if (filePath != null && ((lower = filePath.toLowerCase()).endsWith(".bsl") || lower.endsWith(".os"))) {
            return true;
        }
        if (fileName != null) {
            lower = fileName.toLowerCase();
            if (lower.endsWith(".bsl") || lower.endsWith(".os")) {
                return true;
            }
            if (lower.contains("module") || lower.contains("\u043c\u043e\u0434\u0443\u043b\u044c") || lower.contains("\u043a\u043b\u0438\u0435\u043d\u0442") || lower.contains("\u0441\u0435\u0440\u0432\u0435\u0440") || lower.contains("client") || lower.contains("server") || lower.contains("\u0432\u044b\u0437\u043e\u0432") || lower.contains("\u043c\u0435\u043d\u0435\u0434\u0436\u0435\u0440") || lower.contains("\u043e\u0431\u044a\u0435\u043a\u0442") || lower.contains("\u0444\u043e\u0440\u043c")) {
                return true;
            }
        }
        return false;
    }

    private String getSurroundingCode(IDocument document, int startLine, int endLine) throws BadLocationException {
        int endOffset;
        int contextBefore = 25;
        int contextAfter = 25;
        int docLines = document.getNumberOfLines();
        int fromLine = Math.max(0, startLine - contextBefore);
        int toLine = Math.min(docLines - 1, endLine + contextAfter);
        int startOffset = document.getLineOffset(fromLine);
        Object code = document.get(startOffset, (endOffset = document.getLineOffset(toLine) + document.getLineLength(toLine)) - startOffset);
        if (((String)code).length() > 8000) {
            code = ((String)code).substring(0, 8000) + "\n... (\u043e\u0431\u0440\u0435\u0437\u0430\u043d\u043e)";
        }
        return code;
    }

    private String detectModuleType(String path) {
        if (path == null) {
            return "";
        }
        String lowerPath = path.toLowerCase();
        if (lowerPath.contains("/commonmodules/")) {
            return "\u041e\u0431\u0449\u0438\u0439\u041c\u043e\u0434\u0443\u043b\u044c";
        }
        if (lowerPath.contains("/forms/")) {
            return "\u041c\u043e\u0434\u0443\u043b\u044c\u0424\u043e\u0440\u043c\u044b";
        }
        if (lowerPath.contains("/commands/")) {
            return "\u041c\u043e\u0434\u0443\u043b\u044c\u041a\u043e\u043c\u0430\u043d\u0434\u044b";
        }
        if (lowerPath.contains("objectmodule")) {
            return "\u041c\u043e\u0434\u0443\u043b\u044c\u041e\u0431\u044a\u0435\u043a\u0442\u0430";
        }
        if (lowerPath.contains("managermodule")) {
            return "\u041c\u043e\u0434\u0443\u043b\u044c\u041c\u0435\u043d\u0435\u0434\u0436\u0435\u0440\u0430";
        }
        if (lowerPath.contains("recordsetmodule")) {
            return "\u041c\u043e\u0434\u0443\u043b\u044c\u041d\u0430\u0431\u043e\u0440\u0430\u0417\u0430\u043f\u0438\u0441\u0435\u0439";
        }
        return "\u041c\u043e\u0434\u0443\u043b\u044c";
    }

    /*
     * WARNING - void declaration
     */
    private String getSelectedText(IWorkbenchPage page) {
        IEditorPart editor = page.getActiveEditor();
        LOG.info("getSelectedText: \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440=%s", new Object[]{editor != null ? editor.getClass().getName() : "null"});
        if (editor == null) {
            LOG.warn("getSelectedText: \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440 = null");
            return null;
        }
        Class<?> editorClass = editor.getClass();
        LOG.info("getSelectedText: \u043a\u043b\u0430\u0441\u0441 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0430: %s", new Object[]{editorClass.getName()});
        LOG.info("getSelectedText: \u0441\u0443\u043f\u0435\u0440\u043a\u043b\u0430\u0441\u0441: %s", new Object[]{editorClass.getSuperclass() != null ? editorClass.getSuperclass().getName() : "null"});
        ITextSelection iTextSelection = editorClass.getInterfaces();
        int n = ((Class<?>[])iTextSelection).length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> iface = iTextSelection[n2];
            LOG.info("getSelectedText: \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441: %s", new Object[]{iface.getName()});
            ++n2;
        }
        ITextEditor textEditor = null;
        if (editor instanceof ITextEditor) {
            textEditor = (ITextEditor)editor;
            LOG.info("getSelectedText: \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f ITextEditor \u043d\u0430\u043f\u0440\u044f\u043c\u0443\u044e");
        } else {
            LOG.info("getSelectedText: \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u041d\u0415 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f ITextEditor");
        }
        if (textEditor == null && editor instanceof IAdaptable) {
            LOG.info("getSelectedText: \u043f\u0440\u043e\u0431\u0443\u0435\u043c \u0430\u0434\u0430\u043f\u0442\u0435\u0440 ITextEditor...");
            textEditor = (ITextEditor)editor.getAdapter(ITextEditor.class);
            LOG.info("getSelectedText: \u0430\u0434\u0430\u043f\u0442\u0435\u0440 \u0432\u0435\u0440\u043d\u0443\u043b %s", new Object[]{textEditor != null ? "ITextEditor" : "null"});
        }
        if (textEditor == null) {
            LOG.info("getSelectedText: \u043f\u0440\u043e\u0431\u0443\u0435\u043c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c selection \u043d\u0430\u043f\u0440\u044f\u043c\u0443\u044e \u0438\u0437 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0430");
            ISelectionProvider selectionProvider = editor.getSite().getSelectionProvider();
            LOG.info("getSelectedText: selectionProvider=%s", new Object[]{selectionProvider != null ? selectionProvider.getClass().getName() : "null"});
            if (selectionProvider != null) {
                ISelection selection = selectionProvider.getSelection();
                LOG.info("getSelectedText: selection \u0442\u0438\u043f=%s, isEmpty=%s", new Object[]{selection != null ? selection.getClass().getName() : "null", selection != null ? Boolean.valueOf(selection.isEmpty()) : "N/A"});
                ISelection iSelection = selection;
                if (iSelection instanceof ITextSelection) {
                    void textSelection;
                    iTextSelection = (ITextSelection)iSelection;
                    ITextSelection cfr_ignored_0 = (ITextSelection)iSelection;
                    String text = textSelection.getText();
                    LOG.info("getSelectedText: \u043f\u043e\u043b\u0443\u0447\u0435\u043d \u0442\u0435\u043a\u0441\u0442 \u0434\u043b\u0438\u043d\u043e\u0439 %d \u0447\u0435\u0440\u0435\u0437 getSite()", new Object[]{text != null ? text.length() : 0});
                    return text;
                }
                LOG.info("getSelectedText: selection \u041d\u0415 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f ITextSelection");
            }
        }
        if (textEditor == null) {
            LOG.info("getSelectedText: \u043f\u0440\u043e\u0431\u0443\u0435\u043c \u0447\u0435\u0440\u0435\u0437 ISourceViewer");
            ISourceViewer sourceViewer = this.getSourceViewer(editor);
            if (sourceViewer != null) {
                LOG.info("getSelectedText: sourceViewer \u043f\u043e\u043b\u0443\u0447\u0435\u043d: %s", new Object[]{sourceViewer.getClass().getName()});
                Point selection = sourceViewer.getSelectedRange();
                LOG.info("getSelectedText: selectedRange offset=%d, length=%d", new Object[]{selection.x, selection.y});
                if (selection.y > 0) {
                    IDocument document = sourceViewer.getDocument();
                    if (document != null) {
                        try {
                            String text = document.get(selection.x, selection.y);
                            LOG.info("getSelectedText: \u043f\u043e\u043b\u0443\u0447\u0435\u043d \u0442\u0435\u043a\u0441\u0442 \u0434\u043b\u0438\u043d\u043e\u0439 %d \u0447\u0435\u0440\u0435\u0437 ISourceViewer", new Object[]{text.length()});
                            return text;
                        }
                        catch (Exception e) {
                            LOG.error("getSelectedText: \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0442\u0435\u043a\u0441\u0442\u0430: %s", new Object[]{e.getMessage()});
                        }
                    }
                } else {
                    LOG.info("getSelectedText: \u043d\u0435\u0442 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u0438\u044f (length=0)");
                }
            }
        }
        if (textEditor == null) {
            StyledText textWidget;
            LOG.info("getSelectedText: \u043f\u0440\u043e\u0431\u0443\u0435\u043c \u0447\u0435\u0440\u0435\u0437 StyledText");
            ISourceViewer sourceViewer = this.getSourceViewer(editor);
            if (sourceViewer != null && (textWidget = sourceViewer.getTextWidget()) != null && !textWidget.isDisposed()) {
                String selectedText = textWidget.getSelectionText();
                LOG.info("getSelectedText: StyledText selectionText \u0434\u043b\u0438\u043d\u043e\u0439 %d", new Object[]{selectedText != null ? selectedText.length() : 0});
                if (selectedText != null && !selectedText.isEmpty()) {
                    return selectedText;
                }
            }
        }
        if (textEditor != null) {
            ISelection selection = textEditor.getSelectionProvider().getSelection();
            LOG.info("getSelectedText: ITextEditor selection=%s", new Object[]{selection != null ? selection.getClass().getName() : "null"});
            ISelection iSelection = selection;
            if (iSelection instanceof ITextSelection) {
                void textSelection;
                ITextSelection textWidget = (ITextSelection)iSelection;
                ITextSelection cfr_ignored_1 = (ITextSelection)iSelection;
                String text = textSelection.getText();
                LOG.info("getSelectedText: \u0434\u043b\u0438\u043d\u0430 \u0442\u0435\u043a\u0441\u0442\u0430=%d", new Object[]{text != null ? text.length() : 0});
                return text;
            }
        }
        LOG.warn("getSelectedText: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0439 \u0442\u0435\u043a\u0441\u0442");
        return null;
    }

    private ISourceViewer getSourceViewer(IEditorPart editor) {
        Object adapter;
        if (editor instanceof IAdaptable && (adapter = editor.getAdapter(ISourceViewer.class)) instanceof ISourceViewer) {
            LOG.info("getSourceViewer: \u043f\u043e\u043b\u0443\u0447\u0435\u043d \u0447\u0435\u0440\u0435\u0437 \u0430\u0434\u0430\u043f\u0442\u0435\u0440");
            return (ISourceViewer)adapter;
        }
        try {
            Method method = editor.getClass().getMethod("getSourceViewer", new Class[0]);
            method.setAccessible(true);
            Object result = method.invoke((Object)editor, new Object[0]);
            if (result instanceof ISourceViewer) {
                LOG.info("getSourceViewer: \u043f\u043e\u043b\u0443\u0447\u0435\u043d \u0447\u0435\u0440\u0435\u0437 \u0440\u0435\u0444\u043b\u0435\u043a\u0441\u0438\u044e getSourceViewer()");
                return (ISourceViewer)result;
            }
        }
        catch (Exception e) {
            LOG.info("getSourceViewer: \u043c\u0435\u0442\u043e\u0434 getSourceViewer() \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d: %s", new Object[]{e.getMessage()});
        }
        try {
            Class<?> clazz = editor.getClass();
            while (clazz != null) {
                Field[] fieldArray = clazz.getDeclaredFields();
                int n = fieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = fieldArray[n2];
                    if (ISourceViewer.class.isAssignableFrom(field.getType())) {
                        field.setAccessible(true);
                        Object value = field.get(editor);
                        if (value instanceof ISourceViewer) {
                            LOG.info("getSourceViewer: \u043f\u043e\u043b\u0443\u0447\u0435\u043d \u0447\u0435\u0440\u0435\u0437 \u043f\u043e\u043b\u0435 %s", new Object[]{field.getName()});
                            return (ISourceViewer)value;
                        }
                    }
                    ++n2;
                }
                clazz = clazz.getSuperclass();
            }
        }
        catch (Exception e) {
            LOG.info("getSourceViewer: \u043f\u043e\u0438\u0441\u043a \u043f\u043e\u043b\u044f \u043d\u0435 \u0443\u0434\u0430\u043b\u0441\u044f: %s", new Object[]{e.getMessage()});
        }
        LOG.warn("getSourceViewer: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c ISourceViewer");
        return null;
    }

    protected String buildExplainPromptWithContext(EditorContext context) {
        StringBuilder sb = new StringBuilder();
        sb.append("\u041e\u0431\u044a\u044f\u0441\u043d\u0438 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u043a\u043e\u0434 \u043d\u0430 \u044f\u0437\u044b\u043a\u0435 1\u0421.\n\n");
        if (context.fileName != null && !context.fileName.isEmpty()) {
            sb.append("**\u0424\u0430\u0439\u043b:** ").append(context.fileName);
            if (context.moduleType != null && !context.moduleType.isEmpty()) {
                sb.append(" (").append(context.moduleType).append(")");
            }
            sb.append("\n");
        }
        if (context.enclosingMethod != null) {
            BslMethodParser.MethodContext method = context.enclosingMethod;
            sb.append("**\u041c\u0435\u0442\u043e\u0434:** ");
            if (method.directive != null) {
                sb.append("&").append(method.directive).append(" ");
            }
            sb.append(method.type).append(" ").append(method.name);
            if (method.params != null && !method.params.isEmpty()) {
                sb.append("(").append(method.params).append(")");
            } else {
                sb.append("()");
            }
            if (method.isExport) {
                sb.append(" \u042d\u043a\u0441\u043f\u043e\u0440\u0442");
            }
            sb.append("\n");
            if (method.region != null) {
                sb.append("**\u041e\u0431\u043b\u0430\u0441\u0442\u044c:** ").append(method.region).append("\n");
            }
            sb.append("**\u0421\u0442\u0440\u043e\u043a\u0438 \u043c\u0435\u0442\u043e\u0434\u0430:** ").append(method.startLine + 1).append("-").append(method.endLine + 1).append("\n");
        } else if (context.selectionStartLine > 0) {
            sb.append("**\u0421\u0442\u0440\u043e\u043a\u0438:** ").append(context.selectionStartLine + 1);
            if (context.selectionEndLine != context.selectionStartLine) {
                sb.append("-").append(context.selectionEndLine + 1);
            }
            sb.append(" \u0438\u0437 ").append(context.totalLines).append("\n");
        }
        sb.append("\n");
        sb.append("## \u0410\u043d\u0430\u043b\u0438\u0437\u0438\u0440\u0443\u0435\u043c\u044b\u0439 \u043a\u043e\u0434:\n");
        sb.append("```bsl\n").append(context.selectedText).append("\n```\n\n");
        if (context.enclosingMethod != null) {
            String methodCode = context.enclosingMethod.fullText;
            if (methodCode != null && !methodCode.equals(context.selectedText) && methodCode.length() > context.selectedText.length()) {
                sb.append("## \u041f\u043e\u043b\u043d\u044b\u0439 \u043a\u043e\u0434 \u043c\u0435\u0442\u043e\u0434\u0430:\n");
                sb.append("```bsl\n").append(methodCode).append("\n```\n\n");
            }
        } else if (context.surroundingCode != null && !context.surroundingCode.isEmpty() && !context.surroundingCode.equals(context.selectedText)) {
            sb.append("## \u041a\u043e\u043d\u0442\u0435\u043a\u0441\u0442 (\u043e\u043a\u0440\u0443\u0436\u0430\u044e\u0449\u0438\u0439 \u043a\u043e\u0434):\n");
            sb.append("```bsl\n").append(context.surroundingCode).append("\n```\n\n");
        }
        if (context.moduleContext != null && !context.moduleContext.moduleVariables.isEmpty()) {
            sb.append("## \u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0435 \u043c\u043e\u0434\u0443\u043b\u044f:\n");
            sb.append("```\n");
            for (String var : context.moduleContext.moduleVariables) {
                sb.append("\u041f\u0435\u0440\u0435\u043c ").append(var).append(";\n");
            }
            sb.append("```\n\n");
        }
        if (context.calledMethodDefinitions != null && !context.calledMethodDefinitions.isEmpty()) {
            sb.append("## \u0412\u044b\u0437\u044b\u0432\u0430\u0435\u043c\u044b\u0435 \u043c\u0435\u0442\u043e\u0434\u044b (\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f):\n\n");
            for (BslMethodParser.MethodContext calledMethod : context.calledMethodDefinitions) {
                sb.append("### ").append(calledMethod.name);
                if (calledMethod.directive != null) {
                    sb.append(" (&").append(calledMethod.directive).append(")");
                }
                sb.append("\n");
                sb.append("```bsl\n").append(calledMethod.fullText).append("\n```\n\n");
            }
        }
        sb.append("\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u043e\u0431\u044a\u044f\u0441\u043d\u0438:\n");
        sb.append("1. \u0427\u0442\u043e \u0434\u0435\u043b\u0430\u0435\u0442 \u044d\u0442\u043e\u0442 \u043a\u043e\u0434\n");
        sb.append("2. \u041a\u0430\u043a \u043e\u043d \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442\n");
        sb.append("3. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u044b\u0435 \u0443\u043b\u0443\u0447\u0448\u0435\u043d\u0438\u044f (\u0435\u0441\u043b\u0438 \u0435\u0441\u0442\u044c)\n");
        String builtPrompt = sb.toString();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("prompt", builtPrompt);
        variables.put("code", context.selectedText != null ? context.selectedText : "");
        variables.put("file", context.fileName != null ? context.fileName : "");
        variables.put("module", context.moduleType != null ? context.moduleType : "");
        variables.put("surrounding_code", context.surroundingCode != null ? context.surroundingCode : "");
        String preferenceKey = "prompt.template.explainCode";
        return PromptTemplateService.getInstance().applyTemplate(preferenceKey, PromptCatalog.getDefaultTemplate((String)preferenceKey), variables, PromptCatalog.getRequiredPlaceholders((String)preferenceKey));
    }

    private String buildExplainPrompt(String code) {
        return String.format("\u041e\u0431\u044a\u044f\u0441\u043d\u0438 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u043a\u043e\u0434 \u043d\u0430 \u044f\u0437\u044b\u043a\u0435 1\u0421:\n\n```bsl\n%s\n```\n\n\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u043e\u0431\u044a\u044f\u0441\u043d\u0438:\n1. \u0427\u0442\u043e \u0434\u0435\u043b\u0430\u0435\u0442 \u044d\u0442\u043e\u0442 \u043a\u043e\u0434\n2. \u041a\u0430\u043a \u043e\u043d \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442\n3. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u044b\u0435 \u0443\u043b\u0443\u0447\u0448\u0435\u043d\u0438\u044f (\u0435\u0441\u043b\u0438 \u0435\u0441\u0442\u044c)\n", code);
    }

    protected static class EditorContext {
        String selectedText;
        String fullDocument;
        String surroundingCode;
        String filePath;
        String fileName;
        String moduleType;
        int selectionStartLine;
        int selectionEndLine;
        int totalLines;
        BslMethodParser.MethodContext enclosingMethod;
        BslMethodParser.ModuleContext moduleContext;
        List<BslMethodParser.MethodContext> calledMethodDefinitions;

        protected EditorContext() {
        }
    }
}

