/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.editor;

import com.example.vibe.core.diff.CodeChange;
import com.example.vibe.core.diff.ICodeApplicator;
import com.example.vibe.ui.internal.VibeUiPlugin;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.undo.DocumentUndoManagerRegistry;
import org.eclipse.text.undo.IDocumentUndoManager;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorCodeApplicator
implements ICodeApplicator {
    private final ITextEditor editor;
    private final IDocument document;

    public EditorCodeApplicator(ITextEditor editor) {
        this.editor = editor;
        this.document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
    }

    public EditorCodeApplicator(IDocument document) {
        this.editor = null;
        this.document = document;
    }

    public ICodeApplicator.ApplyResult apply(CodeChange change) {
        return this.applyAll(List.of(change));
    }

    public ICodeApplicator.ApplyResult applyAll(List<CodeChange> changes) {
        return this.applyWithUndo(changes, "AI Code Change");
    }

    public ICodeApplicator.ApplyResult applyWithUndo(List<CodeChange> changes, String undoLabel) {
        if (this.document == null) {
            return ICodeApplicator.ApplyResult.failure((String)"No document available", null);
        }
        if (changes == null || changes.isEmpty()) {
            return ICodeApplicator.ApplyResult.success((int)0);
        }
        ArrayList<CodeChange> sortedChanges = new ArrayList<CodeChange>(changes);
        sortedChanges.sort(Comparator.comparingInt(CodeChange::getOffset).reversed());
        ICodeApplicator.ApplyResult[] result = new ICodeApplicator.ApplyResult[1];
        Display display = Display.getDefault();
        Runnable applyRunnable = () -> {
            applyResultArray[0] = this.doApplyChanges(sortedChanges, undoLabel);
        };
        if (Display.getCurrent() != null) {
            applyRunnable.run();
        } else {
            display.syncExec(applyRunnable);
        }
        return result[0];
    }

    /*
     * WARNING - void declaration
     */
    private ICodeApplicator.ApplyResult doApplyChanges(List<CodeChange> changes, String undoLabel) {
        int applied;
        DocumentRewriteSession rewriteSession;
        IDocumentUndoManager undoManager;
        block13: {
            IDocument iDocument;
            IDocument iDocument2;
            undoManager = DocumentUndoManagerRegistry.getDocumentUndoManager((IDocument)this.document);
            rewriteSession = null;
            if (undoManager != null) {
                undoManager.beginCompoundChange();
            }
            if ((iDocument2 = this.document) instanceof IDocumentExtension4) {
                void ext4;
                IDocumentExtension4 iDocumentExtension4 = (IDocumentExtension4)iDocument2;
                IDocumentExtension4 cfr_ignored_0 = (IDocumentExtension4)iDocument2;
                rewriteSession = ext4.startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
            }
            applied = 0;
            int failed = 0;
            StringBuilder errors = new StringBuilder();
            for (CodeChange change : changes) {
                try {
                    this.applyChange(change);
                    ++applied;
                }
                catch (BadLocationException e) {
                    ++failed;
                    errors.append(String.format("Change at offset %d failed: %s\n", change.getOffset(), e.getMessage()));
                    VibeUiPlugin.log(e);
                }
            }
            if (failed <= 0) break block13;
            ICodeApplicator.ApplyResult applyResult = ICodeApplicator.ApplyResult.partial((int)applied, (int)failed, (String)errors.toString().trim());
            if (rewriteSession != null && (iDocument = this.document) instanceof IDocumentExtension4) {
                void ext4;
                IDocumentExtension4 iDocumentExtension4 = (IDocumentExtension4)iDocument;
                IDocumentExtension4 cfr_ignored_1 = (IDocumentExtension4)iDocument;
                ext4.stopRewriteSession(rewriteSession);
            }
            if (undoManager != null) {
                undoManager.endCompoundChange();
            }
            return applyResult;
        }
        try {
            ICodeApplicator.ApplyResult applyResult = ICodeApplicator.ApplyResult.success((int)applied);
            return applyResult;
        }
        finally {
            IDocument iDocument;
            if (rewriteSession != null && (iDocument = this.document) instanceof IDocumentExtension4) {
                IDocumentExtension4 ext4 = (IDocumentExtension4)iDocument;
                IDocumentExtension4 cfr_ignored_2 = (IDocumentExtension4)iDocument;
                ext4.stopRewriteSession(rewriteSession);
            }
            if (undoManager != null) {
                undoManager.endCompoundChange();
            }
        }
    }

    private void applyChange(CodeChange change) throws BadLocationException {
        switch (change.getType()) {
            case INSERT: {
                this.document.replace(change.getOffset(), 0, change.getNewText());
                break;
            }
            case REPLACE: {
                this.document.replace(change.getOffset(), change.getLength(), change.getNewText());
                break;
            }
            case DELETE: {
                this.document.replace(change.getOffset(), change.getLength(), "");
            }
        }
    }

    public boolean canApply(CodeChange change) {
        if (this.document == null || change == null) {
            return false;
        }
        int docLength = this.document.getLength();
        int offset = change.getOffset();
        int endOffset = change.getEndOffset();
        if (offset < 0 || offset > docLength) {
            return false;
        }
        if (endOffset < offset || endOffset > docLength) {
            return false;
        }
        if (change.getType() == CodeChange.ChangeType.REPLACE && change.getOldText() != null) {
            try {
                String actual = this.document.get(offset, change.getLength());
                return actual.equals(change.getOldText());
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
        return true;
    }

    public boolean supportsUndo() {
        return DocumentUndoManagerRegistry.getDocumentUndoManager((IDocument)this.document) != null;
    }

    public String preview(List<CodeChange> changes) {
        if (this.document == null || changes == null || changes.isEmpty()) {
            return this.document != null ? this.document.get() : "";
        }
        StringBuilder content = new StringBuilder(this.document.get());
        ArrayList<CodeChange> sortedChanges = new ArrayList<CodeChange>(changes);
        sortedChanges.sort(Comparator.comparingInt(CodeChange::getOffset).reversed());
        for (CodeChange change : sortedChanges) {
            int offset = change.getOffset();
            int endOffset = change.getEndOffset();
            if (offset < 0 || offset > content.length()) continue;
            switch (change.getType()) {
                case INSERT: {
                    content.insert(offset, change.getNewText());
                    break;
                }
                case REPLACE: {
                    if (endOffset > content.length()) break;
                    content.replace(offset, endOffset, change.getNewText());
                    break;
                }
                case DELETE: {
                    if (endOffset > content.length()) break;
                    content.delete(offset, endOffset);
                }
            }
        }
        return content.toString();
    }

    public ITextEditor getEditor() {
        return this.editor;
    }

    public IDocument getDocument() {
        return this.document;
    }

    public void moveCaret(int offset) {
        if (this.editor != null) {
            Display.getDefault().asyncExec(() -> this.editor.selectAndReveal(offset, 0));
        }
    }
}

