/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.dialogs;

import com.example.vibe.core.model.ToolCall;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ToolConfirmationDialog
extends Dialog {
    private final ToolCall toolCall;
    private final String toolDescription;
    private final boolean isDestructive;
    private Color warningColor;
    private Font codeFont;

    public ToolConfirmationDialog(Shell parentShell, ToolCall toolCall, String toolDescription, boolean isDestructive) {
        super(parentShell);
        this.toolCall = toolCall;
        this.toolDescription = toolDescription;
        this.isDestructive = isDestructive;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.isDestructive ? "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438" : "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442\u0430");
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 15;
        layout.marginHeight = 15;
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        Display display = parent.getDisplay();
        this.warningColor = new Color((Device)display, 180, 80, 0);
        this.codeFont = new Font((Device)display, "Menlo", 11, 0);
        if (this.isDestructive) {
            this.createWarningHeader(container);
        }
        this.createToolInfo(container);
        this.createArgumentsPreview(container);
        return container;
    }

    private void createWarningHeader(Composite parent) {
        Composite warningArea = new Composite(parent, 0);
        warningArea.setLayout((Layout)new GridLayout(2, false));
        warningArea.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label iconLabel = new Label(warningArea, 0);
        iconLabel.setText("\u26a0");
        iconLabel.setForeground(this.warningColor);
        Label warningLabel = new Label(warningArea, 64);
        warningLabel.setText("\u042d\u0442\u0430 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0438\u0442 \u0444\u0430\u0439\u043b\u044b \u0432 \u043f\u0440\u043e\u0435\u043a\u0442\u0435. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u0435\u0440\u0435\u0434 \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0435\u043d\u0438\u0435\u043c.");
        warningLabel.setForeground(this.warningColor);
        GridData warningData = new GridData(4, 0x1000000, true, false);
        warningData.widthHint = 350;
        warningLabel.setLayoutData((Object)warningData);
    }

    private void createToolInfo(Composite parent) {
        Label nameLabel = new Label(parent, 0);
        nameLabel.setText("\u0418\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442: " + this.getToolDisplayName(this.toolCall.getName()));
        nameLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.toolDescription != null && !this.toolDescription.isEmpty()) {
            Label descLabel = new Label(parent, 64);
            descLabel.setText(this.toolDescription);
            GridData descData = new GridData(4, 0x1000000, true, false);
            descData.widthHint = 400;
            descLabel.setLayoutData((Object)descData);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createArgumentsPreview(Composite parent) {
        Map<String, Object> arguments = this.parseArguments(this.toolCall.getArguments());
        if (arguments == null || arguments.isEmpty()) {
            return;
        }
        Label argsLabel = new Label(parent, 0);
        argsLabel.setText("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b:");
        StyledText argsText = new StyledText(parent, 2570);
        argsText.setFont(this.codeFont);
        argsText.setEditable(false);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : arguments.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            sb.append(key).append(": ");
            Object object = value;
            if (object instanceof String) {
                void strValue;
                String cfr_ignored_0 = (String)object;
                String cfr_ignored_1 = (String)object;
                if (strValue.length() > 200) {
                    sb.append(strValue.substring(0, 200)).append("...");
                } else {
                    sb.append((String)strValue);
                }
            } else {
                sb.append(String.valueOf(value));
            }
            sb.append("\n");
        }
        argsText.setText(sb.toString().trim());
        GridData argsData = new GridData(4, 4, true, true);
        argsData.widthHint = 400;
        argsData.heightHint = 150;
        argsText.setLayoutData((Object)argsData);
    }

    private Map<String, Object> parseArguments(String json) {
        if (json == null || json.isEmpty() || "{}".equals(json)) {
            return new HashMap<String, Object>();
        }
        try {
            Gson gson = new Gson();
            Type mapType = new TypeToken<Map<String, Object>>(){}.getType();
            Map result = (Map)gson.fromJson(json, mapType);
            return result != null ? result : new HashMap();
        }
        catch (Exception exception) {
            return new HashMap<String, Object>();
        }
    }

    private String getToolDisplayName(String name) {
        return switch (name) {
            case "read_file" -> "\u0427\u0442\u0435\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430";
            case "edit_file" -> "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430";
            case "list_files" -> "\u0421\u043f\u0438\u0441\u043e\u043a \u0444\u0430\u0439\u043b\u043e\u0432";
            case "grep" -> "\u041f\u043e\u0438\u0441\u043a \u0442\u0435\u043a\u0441\u0442\u0430";
            case "search_codebase" -> "\u041f\u043e\u0438\u0441\u043a \u043f\u043e \u043a\u043e\u0434\u0443";
            default -> name;
        };
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, this.isDestructive ? "\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c" : "OK", true);
        this.createButton(parent, 1, "\u041e\u0442\u043c\u0435\u043d\u0430", false);
        if (this.isDestructive) {
            this.createButton(parent, 3, "\u041f\u0440\u043e\u043f\u0443\u0441\u0442\u0438\u0442\u044c", false);
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 3) {
            this.setReturnCode(3);
            this.close();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    public boolean close() {
        if (this.warningColor != null && !this.warningColor.isDisposed()) {
            this.warningColor.dispose();
        }
        if (this.codeFont != null && !this.codeFont.isDisposed()) {
            this.codeFont.dispose();
        }
        return super.close();
    }

    public boolean openAndConfirm() {
        return this.open() == 0;
    }

    public boolean wasSkipped() {
        return this.getReturnCode() == 3;
    }
}

