/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.dialogs;

import com.example.vibe.core.review.BslReviewResult;
import com.example.vibe.ui.views.ReviewResultWidget;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ReviewResultDialog
extends Dialog {
    private static final int COPY_ID = 1025;
    private final BslReviewResult result;
    private ReviewResultWidget reviewWidget;
    private Clipboard clipboard;

    public ReviewResultDialog(Shell parentShell, BslReviewResult result) {
        super(parentShell);
        this.result = result;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043a\u043e\u0434\u0430");
    }

    protected Point getInitialSize() {
        return new Point(700, 500);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        ScrolledComposite scrolled = new ScrolledComposite(container, 768);
        scrolled.setLayoutData((Object)new GridData(4, 4, true, true));
        scrolled.setExpandHorizontal(true);
        scrolled.setExpandVertical(true);
        this.reviewWidget = new ReviewResultWidget((Composite)scrolled, this.result);
        scrolled.setContent((Control)this.reviewWidget);
        scrolled.setMinSize(this.reviewWidget.computeSize(-1, -1));
        this.clipboard = new Clipboard(parent.getDisplay());
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, "\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043e\u0442\u0447\u0451\u0442", false);
        this.createButton(parent, 0, "\u0417\u0430\u043a\u0440\u044b\u0442\u044c", true);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            this.copyReportToClipboard();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    private void copyReportToClipboard() {
        String report = this.result.toReport();
        TextTransfer textTransfer = TextTransfer.getInstance();
        this.clipboard.setContents(new Object[]{report}, new Transfer[]{textTransfer});
        this.getButton(1025).setText("\u0421\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u043e!");
        this.getShell().getDisplay().timerExec(1500, () -> {
            if (!this.getButton(1025).isDisposed()) {
                this.getButton(1025).setText("\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043e\u0442\u0447\u0451\u0442");
            }
        });
    }

    public boolean close() {
        if (this.clipboard != null && !this.clipboard.isDisposed()) {
            this.clipboard.dispose();
        }
        if (this.reviewWidget != null && !this.reviewWidget.isDisposed()) {
            this.reviewWidget.dispose();
        }
        return super.close();
    }

    public BslReviewResult getResult() {
        return this.result;
    }
}

