/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.diagnostics;

import com.example.vibe.core.logging.VibeLogger;
import com.example.vibe.ui.diagnostics.EdtDiagnostic;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class EdtDiagnosticsCollector {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(EdtDiagnosticsCollector.class);
    private static final int DEFAULT_MAX_ITEMS = 50;
    private static final int MAX_SNIPPET_LENGTH = 120;
    private static EdtDiagnosticsCollector instance;

    private EdtDiagnosticsCollector() {
    }

    public static synchronized EdtDiagnosticsCollector getInstance() {
        if (instance == null) {
            instance = new EdtDiagnosticsCollector();
        }
        return instance;
    }

    public CompletableFuture<DiagnosticsResult> collectFromActiveEditor(DiagnosticsQuery query) {
        return CompletableFuture.supplyAsync(() -> {
            if (query.waitMs() > 0L) {
                try {
                    Thread.sleep(query.waitMs());
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            return query;
        }).thenCompose(q -> {
            CompletableFuture future = new CompletableFuture();
            Display.getDefault().asyncExec(() -> {
                try {
                    IAnnotationModel annotationModel;
                    IDocumentProvider docProvider;
                    ITextEditor editor = this.getActiveTextEditor();
                    if (editor == null) {
                        future.complete(new DiagnosticsResult("\u043d\u0435\u0442 \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0430", false, List.of(), 0, 0, 0));
                        return;
                    }
                    IEditorInput input = editor.getEditorInput();
                    IFile file = this.resolveFile(input);
                    String filePath = file != null ? file.getFullPath().toString() : input.getName();
                    boolean dirty = editor.isDirty();
                    ArrayList<EdtDiagnostic> diagnostics = new ArrayList<EdtDiagnostic>();
                    HashSet<String> seen = new HashSet<String>();
                    if (file != null && !dirty) {
                        this.collectFromMarkers(file, filePath, (DiagnosticsQuery)q, (List<EdtDiagnostic>)diagnostics, (Set<String>)seen);
                    }
                    IDocument document = (docProvider = editor.getDocumentProvider()) != null ? docProvider.getDocument((Object)input) : null;
                    IAnnotationModel iAnnotationModel = annotationModel = docProvider != null ? docProvider.getAnnotationModel((Object)input) : null;
                    if (annotationModel != null && document != null) {
                        this.collectFromAnnotations(annotationModel, document, filePath, (DiagnosticsQuery)q, (List<EdtDiagnostic>)diagnostics, (Set<String>)seen);
                    }
                    diagnostics.sort(Comparator.comparing(d -> d.severity().getLevel()).reversed().thenComparing(EdtDiagnostic::lineNumber));
                    int maxItems = Math.max(1, q.maxItems());
                    if (diagnostics.size() > maxItems) {
                        diagnostics = new ArrayList(diagnostics.subList(0, maxItems));
                    }
                    int errors = (int)diagnostics.stream().filter(d -> d.severity() == EdtDiagnostic.Severity.ERROR).count();
                    int warnings = (int)diagnostics.stream().filter(d -> d.severity() == EdtDiagnostic.Severity.WARNING).count();
                    int infos = diagnostics.size() - errors - warnings;
                    future.complete(new DiagnosticsResult(filePath, dirty, diagnostics, errors, warnings, infos));
                }
                catch (Exception e) {
                    LOG.error("Error collecting diagnostics: %s", new Object[]{e.getMessage()});
                    future.completeExceptionally(e);
                }
            });
            return future;
        });
    }

    public CompletableFuture<DiagnosticsResult> collectFromFile(String filePath, DiagnosticsQuery query) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Path path;
                IWorkspaceRoot root;
                IFile file;
                if (query.waitMs() > 0L) {
                    try {
                        Thread.sleep(query.waitMs());
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (!(file = (root = ResourcesPlugin.getWorkspace().getRoot()).getFile((IPath)(path = new Path(filePath)))).exists()) {
                    return new DiagnosticsResult(filePath, false, List.of(), 0, 0, 0);
                }
                ArrayList<EdtDiagnostic> diagnostics = new ArrayList<EdtDiagnostic>();
                HashSet<String> seen = new HashSet<String>();
                this.collectFromMarkers(file, filePath, query, diagnostics, seen);
                diagnostics.sort(Comparator.comparing(d -> d.severity().getLevel()).reversed().thenComparing(EdtDiagnostic::lineNumber));
                int maxItems = Math.max(1, query.maxItems());
                if (diagnostics.size() > maxItems) {
                    diagnostics = new ArrayList(diagnostics.subList(0, maxItems));
                }
                int errors = (int)diagnostics.stream().filter(d -> d.severity() == EdtDiagnostic.Severity.ERROR).count();
                int warnings = (int)diagnostics.stream().filter(d -> d.severity() == EdtDiagnostic.Severity.WARNING).count();
                int infos = diagnostics.size() - errors - warnings;
                return new DiagnosticsResult(filePath, false, diagnostics, errors, warnings, infos);
            }
            catch (Exception e) {
                LOG.error("Error collecting diagnostics for file %s: %s", new Object[]{filePath, e.getMessage()});
                return new DiagnosticsResult(filePath, false, List.of(), 0, 0, 0);
            }
        });
    }

    private void collectFromMarkers(IFile file, String filePath, DiagnosticsQuery query, List<EdtDiagnostic> diagnostics, Set<String> seen) {
        try {
            IMarker[] markers = file.findMarkers(null, true, 0);
            LOG.debug("Found %d markers for file %s", new Object[]{markers.length, filePath});
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                int severity = marker.getAttribute("severity", -1);
                EdtDiagnostic.Severity sev = EdtDiagnostic.Severity.fromMarkerSeverity(severity);
                if (sev.getLevel() >= query.minSeverity().getLevel()) {
                    String message = String.valueOf(marker.getAttribute("message", ""));
                    int line = marker.getAttribute("lineNumber", -1);
                    int charStart = marker.getAttribute("charStart", -1);
                    int charEnd = marker.getAttribute("charEnd", -1);
                    String markerType = this.safeGetMarkerType(marker);
                    String key = line + ":" + charStart + ":" + message;
                    if (!seen.contains(key)) {
                        seen.add(key);
                        if (!message.isBlank()) {
                            String snippet = query.includeSnippets() ? this.getSnippetFromFile(file, line, charStart, charEnd) : null;
                            diagnostics.add(EdtDiagnostic.fromMarker(filePath, line, charStart, charEnd, message, severity, markerType, snippet));
                        }
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            LOG.error("Error finding markers: %s", new Object[]{e.getMessage()});
        }
    }

    /*
     * WARNING - void declaration
     */
    private void collectFromAnnotations(IAnnotationModel model, IDocument document, String filePath, DiagnosticsQuery query, List<EdtDiagnostic> diagnostics, Set<String> seen) {
        Iterator it = model.getAnnotationIterator();
        int count = 0;
        while (it.hasNext()) {
            String key;
            String text;
            void ann;
            Object obj = it.next();
            Object e = obj;
            if (!(e instanceof Annotation)) continue;
            Annotation cfr_ignored_0 = (Annotation)e;
            Annotation cfr_ignored_1 = (Annotation)e;
            String annType = ann.getType();
            if (annType == null || !this.isProblemAnnotation(annType) || (text = Objects.toString(ann.getText(), "")).isBlank()) continue;
            Position pos = model.getPosition((Annotation)ann);
            int offset = pos != null ? pos.offset : -1;
            int length = pos != null ? pos.length : 0;
            int line = this.safeGetLineOfOffset(document, offset);
            int charEnd = offset + length;
            EdtDiagnostic.Severity sev = this.getSeverityFromAnnotationType(annType);
            if (sev.getLevel() < query.minSeverity().getLevel() || seen.contains(key = line + ":" + offset + ":" + text)) continue;
            seen.add(key);
            String markerType = null;
            void var25_23 = ann;
            if (var25_23 instanceof MarkerAnnotation) {
                void markerAnn;
                MarkerAnnotation cfr_ignored_2 = (MarkerAnnotation)var25_23;
                MarkerAnnotation cfr_ignored_3 = (MarkerAnnotation)var25_23;
                IMarker marker = markerAnn.getMarker();
                if (marker != null) {
                    markerType = this.safeGetMarkerType(marker);
                }
            }
            String snippet = query.includeSnippets() ? this.getSnippetFromDocument(document, offset, length) : null;
            diagnostics.add(EdtDiagnostic.fromAnnotation(filePath, line, offset, charEnd, text, sev, markerType != null ? markerType : annType, snippet));
            if (++count >= query.maxItems() * 2) break;
        }
        LOG.debug("Collected %d annotations from model", new Object[]{count});
    }

    private boolean isProblemAnnotation(String type) {
        return type.contains("problem") || type.contains("error") || type.contains("warning") || type.contains("info") || type.contains("check");
    }

    private EdtDiagnostic.Severity getSeverityFromAnnotationType(String type) {
        if (type.contains("error")) {
            return EdtDiagnostic.Severity.ERROR;
        }
        if (type.contains("warning")) {
            return EdtDiagnostic.Severity.WARNING;
        }
        return EdtDiagnostic.Severity.INFO;
    }

    /*
     * WARNING - void declaration
     */
    private ITextEditor getActiveTextEditor() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        IEditorPart iEditorPart = editor;
        if (iEditorPart instanceof ITextEditor) {
            void textEditor;
            ITextEditor iTextEditor = (ITextEditor)iEditorPart;
            ITextEditor cfr_ignored_0 = (ITextEditor)iEditorPart;
            return textEditor;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private IFile resolveFile(IEditorInput input) {
        IEditorInput iEditorInput = input;
        if (iEditorInput instanceof FileEditorInput) {
            void fileInput;
            FileEditorInput fileEditorInput = (FileEditorInput)iEditorInput;
            FileEditorInput cfr_ignored_0 = (FileEditorInput)iEditorInput;
            return fileInput.getFile();
        }
        Object adapted = input.getAdapter(IFile.class);
        return adapted instanceof IFile ? (IFile)adapted : null;
    }

    private String safeGetMarkerType(IMarker marker) {
        try {
            return marker.getType();
        }
        catch (CoreException coreException) {
            return "unknown";
        }
    }

    private int safeGetLineOfOffset(IDocument doc, int offset) {
        if (doc == null || offset < 0) {
            return -1;
        }
        try {
            return doc.getLineOfOffset(offset) + 1;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    private String getSnippetFromFile(IFile file, int line, int charStart, int charEnd) {
        return null;
    }

    private String getSnippetFromDocument(IDocument document, int offset, int length) {
        if (document == null || offset < 0) {
            return null;
        }
        try {
            int lineNum = document.getLineOfOffset(offset);
            int lineStart = document.getLineOffset(lineNum);
            int lineLength = document.getLineLength(lineNum);
            String line = document.get(lineStart, Math.min(lineLength, 120));
            return line.stripTrailing();
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public record DiagnosticsQuery(EdtDiagnostic.Severity minSeverity, int maxItems, boolean includeSnippets, long waitMs) {
        public static DiagnosticsQuery defaults() {
            return new DiagnosticsQuery(EdtDiagnostic.Severity.ERROR, 50, true, 0L);
        }

        public static DiagnosticsQuery withSeverity(EdtDiagnostic.Severity minSeverity) {
            return new DiagnosticsQuery(minSeverity, 50, true, 0L);
        }
    }

    public record DiagnosticsResult(String filePath, boolean editorDirty, List<EdtDiagnostic> diagnostics, int errorCount, int warningCount, int infoCount) {
        public boolean hasErrors() {
            return this.errorCount > 0;
        }

        public boolean hasDiagnostics() {
            return !this.diagnostics.isEmpty();
        }

        public String formatForLlm() {
            StringBuilder sb = new StringBuilder();
            sb.append("## \u0414\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u043a\u0438: ").append(this.filePath).append("\n\n");
            if (this.editorDirty) {
                sb.append("\u26a0\ufe0f *\u0424\u0430\u0439\u043b \u043d\u0435 \u0441\u043e\u0445\u0440\u0430\u043d\u0451\u043d \u2014 \u0434\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u043a\u0438 \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u043d\u0435\u043f\u043e\u043b\u043d\u044b\u043c\u0438*\n\n");
            }
            sb.append("**\u0418\u0442\u043e\u0433\u043e:** ");
            sb.append(this.errorCount).append(" \u043e\u0448\u0438\u0431\u043e\u043a, ");
            sb.append(this.warningCount).append(" \u043f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0439, ");
            sb.append(this.infoCount).append(" \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0445\n\n");
            if (this.diagnostics.isEmpty()) {
                sb.append("\u2705 \u0414\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u043a \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e.\n");
            } else {
                for (EdtDiagnostic diag : this.diagnostics) {
                    sb.append(diag.formatForLlm()).append("\n");
                }
            }
            return sb.toString();
        }
    }
}

