/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.tools.metadata.services;

import com.example.vibe.core.tools.metadata.MetadataKind;
import com.example.vibe.core.tools.metadata.services.MdoXmlService;
import java.util.HashMap;
import java.util.Map;

public class MdoTemplates {
    private static MdoTemplates instance;
    private final MdoXmlService xmlService = MdoXmlService.getInstance();

    private MdoTemplates() {
    }

    public static synchronized MdoTemplates getInstance() {
        if (instance == null) {
            instance = new MdoTemplates();
        }
        return instance;
    }

    public String getTemplate(MetadataKind kind) {
        return switch (kind) {
            case MetadataKind.CATALOG -> this.getCatalogTemplate();
            case MetadataKind.DOCUMENT -> this.getDocumentTemplate();
            case MetadataKind.ENUM -> this.getEnumTemplate();
            case MetadataKind.COMMON_MODULE -> this.getCommonModuleTemplate();
            case MetadataKind.INFORMATION_REGISTER -> this.getInformationRegisterTemplate();
            case MetadataKind.ACCUMULATION_REGISTER -> this.getAccumulationRegisterTemplate();
            case MetadataKind.ACCOUNTING_REGISTER -> this.getAccountingRegisterTemplate();
            case MetadataKind.CALCULATION_REGISTER -> this.getCalculationRegisterTemplate();
            case MetadataKind.DATA_PROCESSOR -> this.getDataProcessorTemplate();
            case MetadataKind.REPORT -> this.getReportTemplate();
            case MetadataKind.COMMON_FORM -> this.getCommonFormTemplate();
            case MetadataKind.COMMON_COMMAND -> this.getCommonCommandTemplate();
            case MetadataKind.SUBSYSTEM -> this.getSubsystemTemplate();
            case MetadataKind.ROLE -> this.getRoleTemplate();
            case MetadataKind.CONSTANT -> this.getConstantTemplate();
            case MetadataKind.SEQUENCE -> this.getSequenceTemplate();
            case MetadataKind.BUSINESS_PROCESS -> this.getBusinessProcessTemplate();
            case MetadataKind.TASK -> this.getTaskTemplate();
            case MetadataKind.EXCHANGE_PLAN -> this.getExchangePlanTemplate();
            case MetadataKind.WEB_SERVICE -> this.getWebServiceTemplate();
            case MetadataKind.HTTP_SERVICE -> this.getHttpServiceTemplate();
            case MetadataKind.SCHEDULED_JOB -> this.getScheduledJobTemplate();
            case MetadataKind.EVENT_SUBSCRIPTION -> this.getEventSubscriptionTemplate();
            case MetadataKind.CHART_OF_CHARACTERISTIC_TYPES -> this.getChartOfCharacteristicTypesTemplate();
            case MetadataKind.CHART_OF_ACCOUNTS -> this.getChartOfAccountsTemplate();
            case MetadataKind.CHART_OF_CALCULATION_TYPES -> this.getChartOfCalculationTypesTemplate();
            case MetadataKind.COMMON_TEMPLATE -> this.getCommonTemplateTemplate();
            case MetadataKind.COMMON_PICTURE -> this.getCommonPictureTemplate();
            case MetadataKind.COMMON_ATTRIBUTE -> this.getCommonAttributeTemplate();
            case MetadataKind.WS_REFERENCE -> this.getWsReferenceTemplate();
            case MetadataKind.XDTO_PACKAGE -> this.getXdtoPackageTemplate();
            case MetadataKind.EXTERNAL_DATA_SOURCE -> this.getExternalDataSourceTemplate();
            case MetadataKind.SESSION_PARAMETER -> this.getSessionParameterTemplate();
            case MetadataKind.SETTINGS_STORAGE -> this.getSettingsStorageTemplate();
            case MetadataKind.DOCUMENT_JOURNAL -> this.getDocumentJournalTemplate();
            case MetadataKind.DOCUMENT_NUMERATOR -> this.getDocumentNumeratorTemplate();
            case MetadataKind.DEFINED_TYPE -> this.getDefinedTypeTemplate();
            case MetadataKind.FUNCTIONAL_OPTION -> this.getFunctionalOptionTemplate();
            case MetadataKind.FUNCTIONAL_OPTIONS_PARAMETER -> this.getFunctionalOptionsParameterTemplate();
            case MetadataKind.FILTER_CRITERION -> this.getFilterCriterionTemplate();
            case MetadataKind.COMMAND_GROUP -> this.getCommandGroupTemplate();
            case MetadataKind.STYLE -> this.getStyleTemplate();
            case MetadataKind.STYLE_ITEM -> this.getStyleItemTemplate();
            case MetadataKind.LANGUAGE -> this.getLanguageTemplate();
            case MetadataKind.INTEGRATION_SERVICE -> this.getIntegrationServiceTemplate();
            case MetadataKind.WEB_SOCKET_CLIENT -> this.getWebSocketClientTemplate();
            case MetadataKind.BOT -> this.getBotTemplate();
            case MetadataKind.INTERFACE -> this.getInterfaceTemplate();
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public String applyParameters(String template, Map<String, String> params) {
        String result = template;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            result = result.replace("${" + entry.getKey() + "}", entry.getValue());
        }
        return result;
    }

    public Map<String, String> generateProducedTypesUuids(MetadataKind kind) {
        HashMap<String, String> uuids = new HashMap<String, String>();
        uuids.put("UUID", this.xmlService.generateUuid());
        switch (kind) {
            case CATALOG: 
            case DOCUMENT: 
            case CHART_OF_CHARACTERISTIC_TYPES: 
            case CHART_OF_ACCOUNTS: 
            case CHART_OF_CALCULATION_TYPES: 
            case BUSINESS_PROCESS: 
            case TASK: 
            case EXCHANGE_PLAN: {
                uuids.put("TYPE_ID_OBJ_1", this.xmlService.generateUuid());
                uuids.put("TYPE_ID_OBJ_2", this.xmlService.generateUuid());
                uuids.put("TYPE_ID_REF_1", this.xmlService.generateUuid());
                uuids.put("TYPE_ID_REF_2", this.xmlService.generateUuid());
                uuids.put("TYPE_ID_SEL_1", this.xmlService.generateUuid());
                uuids.put("TYPE_ID_SEL_2", this.xmlService.generateUuid());
                uuids.put("TYPE_ID_LIST_1", this.xmlService.generateUuid());
                uuids.put("TYPE_ID_LIST_2", this.xmlService.generateUuid());
                uuids.put("TYPE_ID_MGR_1", this.xmlService.generateUuid());
                uuids.put("TYPE_ID_MGR_2", this.xmlService.generateUuid());
                break;
            }
            case ENUM: {
                uuids.put("TYPE_ID_REF_1", this.xmlService.generateUuid());
                uuids.put("TYPE_ID_REF_2", this.xmlService.generateUuid());
                uuids.put("TYPE_ID_LIST_1", this.xmlService.generateUuid());
                uuids.put("TYPE_ID_LIST_2", this.xmlService.generateUuid());
                uuids.put("TYPE_ID_MGR_1", this.xmlService.generateUuid());
                uuids.put("TYPE_ID_MGR_2", this.xmlService.generateUuid());
                break;
            }
            case INFORMATION_REGISTER: 
            case ACCUMULATION_REGISTER: 
            case ACCOUNTING_REGISTER: 
            case CALCULATION_REGISTER: {
                uuids.put("TYPE_ID_SEL_1", this.xmlService.generateUuid());
                uuids.put("TYPE_ID_SEL_2", this.xmlService.generateUuid());
                uuids.put("TYPE_ID_LIST_1", this.xmlService.generateUuid());
                uuids.put("TYPE_ID_LIST_2", this.xmlService.generateUuid());
                uuids.put("TYPE_ID_MGR_1", this.xmlService.generateUuid());
                uuids.put("TYPE_ID_MGR_2", this.xmlService.generateUuid());
                uuids.put("TYPE_ID_RS_1", this.xmlService.generateUuid());
                uuids.put("TYPE_ID_RS_2", this.xmlService.generateUuid());
                uuids.put("TYPE_ID_RK_1", this.xmlService.generateUuid());
                uuids.put("TYPE_ID_RK_2", this.xmlService.generateUuid());
                uuids.put("TYPE_ID_REC_1", this.xmlService.generateUuid());
                uuids.put("TYPE_ID_REC_2", this.xmlService.generateUuid());
                uuids.put("TYPE_ID_RM_1", this.xmlService.generateUuid());
                uuids.put("TYPE_ID_RM_2", this.xmlService.generateUuid());
                break;
            }
        }
        return uuids;
    }

    private String getCatalogTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:Catalog xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:core=\"http://g5.1c.ru/v8/dt/mcore\" xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <producedTypes>\n    <objectType typeId=\"${TYPE_ID_OBJ_1}\" valueTypeId=\"${TYPE_ID_OBJ_2}\"/>\n    <refType typeId=\"${TYPE_ID_REF_1}\" valueTypeId=\"${TYPE_ID_REF_2}\"/>\n    <selectionType typeId=\"${TYPE_ID_SEL_1}\" valueTypeId=\"${TYPE_ID_SEL_2}\"/>\n    <listType typeId=\"${TYPE_ID_LIST_1}\" valueTypeId=\"${TYPE_ID_LIST_2}\"/>\n    <managerType typeId=\"${TYPE_ID_MGR_1}\" valueTypeId=\"${TYPE_ID_MGR_2}\"/>\n  </producedTypes>\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n  <useStandardCommands>true</useStandardCommands>\n  <inputByString>Catalog.${NAME}.StandardAttribute.Description</inputByString>\n  <inputByString>Catalog.${NAME}.StandardAttribute.Code</inputByString>\n  <fullTextSearchOnInputByString>DontUse</fullTextSearchOnInputByString>\n  <standardAttributes>\n    <dataHistory>Use</dataHistory>\n    <name>PredefinedDataName</name>\n    <fillValue xsi:type=\"core:UndefinedValue\"/>\n    <fullTextSearch>Use</fullTextSearch>\n    <minValue xsi:type=\"core:UndefinedValue\"/>\n    <maxValue xsi:type=\"core:UndefinedValue\"/>\n  </standardAttributes>\n  <standardAttributes>\n    <dataHistory>Use</dataHistory>\n    <name>Predefined</name>\n    <fillValue xsi:type=\"core:UndefinedValue\"/>\n    <fullTextSearch>Use</fullTextSearch>\n    <minValue xsi:type=\"core:UndefinedValue\"/>\n    <maxValue xsi:type=\"core:UndefinedValue\"/>\n  </standardAttributes>\n  <standardAttributes>\n    <dataHistory>Use</dataHistory>\n    <name>Ref</name>\n    <fillValue xsi:type=\"core:UndefinedValue\"/>\n    <fullTextSearch>Use</fullTextSearch>\n    <minValue xsi:type=\"core:UndefinedValue\"/>\n    <maxValue xsi:type=\"core:UndefinedValue\"/>\n  </standardAttributes>\n  <standardAttributes>\n    <dataHistory>Use</dataHistory>\n    <name>DeletionMark</name>\n    <fillValue xsi:type=\"core:UndefinedValue\"/>\n    <fullTextSearch>Use</fullTextSearch>\n    <minValue xsi:type=\"core:UndefinedValue\"/>\n    <maxValue xsi:type=\"core:UndefinedValue\"/>\n  </standardAttributes>\n  <standardAttributes>\n    <dataHistory>Use</dataHistory>\n    <name>IsFolder</name>\n    <fillValue xsi:type=\"core:UndefinedValue\"/>\n    <fullTextSearch>Use</fullTextSearch>\n    <minValue xsi:type=\"core:UndefinedValue\"/>\n    <maxValue xsi:type=\"core:UndefinedValue\"/>\n  </standardAttributes>\n  <standardAttributes>\n    <dataHistory>Use</dataHistory>\n    <name>Owner</name>\n    <fillFromFillingValue>true</fillFromFillingValue>\n    <fillValue xsi:type=\"core:UndefinedValue\"/>\n    <fillChecking>ShowError</fillChecking>\n    <fullTextSearch>Use</fullTextSearch>\n    <minValue xsi:type=\"core:UndefinedValue\"/>\n    <maxValue xsi:type=\"core:UndefinedValue\"/>\n  </standardAttributes>\n  <standardAttributes>\n    <dataHistory>Use</dataHistory>\n    <name>Parent</name>\n    <fillFromFillingValue>true</fillFromFillingValue>\n    <fillValue xsi:type=\"core:UndefinedValue\"/>\n    <fullTextSearch>Use</fullTextSearch>\n    <minValue xsi:type=\"core:UndefinedValue\"/>\n    <maxValue xsi:type=\"core:UndefinedValue\"/>\n  </standardAttributes>\n  <standardAttributes>\n    <dataHistory>Use</dataHistory>\n    <name>Description</name>\n    <fillValue xsi:type=\"core:UndefinedValue\"/>\n    <fillChecking>ShowError</fillChecking>\n    <fullTextSearch>Use</fullTextSearch>\n    <minValue xsi:type=\"core:UndefinedValue\"/>\n    <maxValue xsi:type=\"core:UndefinedValue\"/>\n  </standardAttributes>\n  <standardAttributes>\n    <dataHistory>Use</dataHistory>\n    <name>Code</name>\n    <fillValue xsi:type=\"core:UndefinedValue\"/>\n    <fullTextSearch>Use</fullTextSearch>\n    <minValue xsi:type=\"core:UndefinedValue\"/>\n    <maxValue xsi:type=\"core:UndefinedValue\"/>\n  </standardAttributes>\n  <createOnInput>Use</createOnInput>\n  <dataLockControlMode>Managed</dataLockControlMode>\n  <fullTextSearch>Use</fullTextSearch>\n  <hierarchical>${HIERARCHICAL}</hierarchical>\n  <levelCount>2</levelCount>\n  <foldersOnTop>true</foldersOnTop>\n  <codeLength>${CODE_LENGTH}</codeLength>\n  <descriptionLength>${DESCRIPTION_LENGTH}</descriptionLength>\n  <codeType>String</codeType>\n  <codeAllowedLength>Variable</codeAllowedLength>\n  <checkUnique>true</checkUnique>\n  <autonumbering>true</autonumbering>\n  <defaultPresentation>AsDescription</defaultPresentation>\n  <editType>InDialog</editType>\n  <choiceMode>BothWays</choiceMode>\n</mdclass:Catalog>\n";
    }

    private String getDocumentTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:Document xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:core=\"http://g5.1c.ru/v8/dt/mcore\" xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <producedTypes>\n    <objectType typeId=\"${TYPE_ID_OBJ_1}\" valueTypeId=\"${TYPE_ID_OBJ_2}\"/>\n    <refType typeId=\"${TYPE_ID_REF_1}\" valueTypeId=\"${TYPE_ID_REF_2}\"/>\n    <selectionType typeId=\"${TYPE_ID_SEL_1}\" valueTypeId=\"${TYPE_ID_SEL_2}\"/>\n    <listType typeId=\"${TYPE_ID_LIST_1}\" valueTypeId=\"${TYPE_ID_LIST_2}\"/>\n    <managerType typeId=\"${TYPE_ID_MGR_1}\" valueTypeId=\"${TYPE_ID_MGR_2}\"/>\n  </producedTypes>\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n  <useStandardCommands>true</useStandardCommands>\n  <inputByString>Document.${NAME}.StandardAttribute.Number</inputByString>\n  <fullTextSearchOnInputByString>DontUse</fullTextSearchOnInputByString>\n  <standardAttributes>\n    <dataHistory>Use</dataHistory>\n    <name>Posted</name>\n    <fillValue xsi:type=\"core:UndefinedValue\"/>\n    <fullTextSearch>Use</fullTextSearch>\n    <minValue xsi:type=\"core:UndefinedValue\"/>\n    <maxValue xsi:type=\"core:UndefinedValue\"/>\n  </standardAttributes>\n  <standardAttributes>\n    <dataHistory>Use</dataHistory>\n    <name>Ref</name>\n    <fillValue xsi:type=\"core:UndefinedValue\"/>\n    <fullTextSearch>Use</fullTextSearch>\n    <minValue xsi:type=\"core:UndefinedValue\"/>\n    <maxValue xsi:type=\"core:UndefinedValue\"/>\n  </standardAttributes>\n  <standardAttributes>\n    <dataHistory>Use</dataHistory>\n    <name>DeletionMark</name>\n    <fillValue xsi:type=\"core:BooleanValue\"/>\n    <fullTextSearch>Use</fullTextSearch>\n    <minValue xsi:type=\"core:UndefinedValue\"/>\n    <maxValue xsi:type=\"core:UndefinedValue\"/>\n  </standardAttributes>\n  <standardAttributes>\n    <dataHistory>Use</dataHistory>\n    <name>Date</name>\n    <fillValue xsi:type=\"core:UndefinedValue\"/>\n    <fillChecking>ShowError</fillChecking>\n    <fullTextSearch>Use</fullTextSearch>\n    <minValue xsi:type=\"core:UndefinedValue\"/>\n    <maxValue xsi:type=\"core:UndefinedValue\"/>\n  </standardAttributes>\n  <standardAttributes>\n    <dataHistory>Use</dataHistory>\n    <name>Number</name>\n    <fillValue xsi:type=\"core:UndefinedValue\"/>\n    <fullTextSearch>Use</fullTextSearch>\n    <minValue xsi:type=\"core:UndefinedValue\"/>\n    <maxValue xsi:type=\"core:UndefinedValue\"/>\n  </standardAttributes>\n  <createOnInput>Use</createOnInput>\n  <dataLockControlMode>Managed</dataLockControlMode>\n  <fullTextSearch>Use</fullTextSearch>\n  <numberType>String</numberType>\n  <numberLength>${NUMBER_LENGTH}</numberLength>\n  <numberAllowedLength>Variable</numberAllowedLength>\n  <checkUnique>true</checkUnique>\n  <autonumbering>true</autonumbering>\n  <posting>Deny</posting>\n  <postInPrivilegedMode>true</postInPrivilegedMode>\n  <unpostInPrivilegedMode>true</unpostInPrivilegedMode>\n</mdclass:Document>\n";
    }

    private String getEnumTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:Enum xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:core=\"http://g5.1c.ru/v8/dt/mcore\" xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <producedTypes>\n    <refType typeId=\"${TYPE_ID_REF_1}\" valueTypeId=\"${TYPE_ID_REF_2}\"/>\n    <listType typeId=\"${TYPE_ID_LIST_1}\" valueTypeId=\"${TYPE_ID_LIST_2}\"/>\n    <managerType typeId=\"${TYPE_ID_MGR_1}\" valueTypeId=\"${TYPE_ID_MGR_2}\"/>\n  </producedTypes>\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n  <standardAttributes>\n    <dataHistory>Use</dataHistory>\n    <name>Order</name>\n    <fillValue xsi:type=\"core:UndefinedValue\"/>\n    <fullTextSearch>Use</fullTextSearch>\n    <minValue xsi:type=\"core:UndefinedValue\"/>\n    <maxValue xsi:type=\"core:UndefinedValue\"/>\n  </standardAttributes>\n  <standardAttributes>\n    <dataHistory>Use</dataHistory>\n    <name>Ref</name>\n    <fillValue xsi:type=\"core:UndefinedValue\"/>\n    <fullTextSearch>Use</fullTextSearch>\n    <minValue xsi:type=\"core:UndefinedValue\"/>\n    <maxValue xsi:type=\"core:UndefinedValue\"/>\n  </standardAttributes>\n  <quickChoice>true</quickChoice>\n  <choiceMode>BothWays</choiceMode>\n</mdclass:Enum>\n";
    }

    private String getCommonModuleTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:CommonModule xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n  <server>${SERVER}</server>\n  <global>${GLOBAL}</global>\n  <clientManagedApplication>${CLIENT_MANAGED}</clientManagedApplication>\n  <externalConnection>${EXTERNAL_CONNECTION}</externalConnection>\n  <serverCall>${SERVER_CALL}</serverCall>\n  <clientOrdinaryApplication>${CLIENT_ORDINARY}</clientOrdinaryApplication>\n</mdclass:CommonModule>\n";
    }

    private String getInformationRegisterTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:InformationRegister xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:core=\"http://g5.1c.ru/v8/dt/mcore\" xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <producedTypes>\n    <selectionType typeId=\"${TYPE_ID_SEL_1}\" valueTypeId=\"${TYPE_ID_SEL_2}\"/>\n    <listType typeId=\"${TYPE_ID_LIST_1}\" valueTypeId=\"${TYPE_ID_LIST_2}\"/>\n    <managerType typeId=\"${TYPE_ID_MGR_1}\" valueTypeId=\"${TYPE_ID_MGR_2}\"/>\n    <recordSetType typeId=\"${TYPE_ID_RS_1}\" valueTypeId=\"${TYPE_ID_RS_2}\"/>\n    <recordKeyType typeId=\"${TYPE_ID_RK_1}\" valueTypeId=\"${TYPE_ID_RK_2}\"/>\n    <recordType typeId=\"${TYPE_ID_REC_1}\" valueTypeId=\"${TYPE_ID_REC_2}\"/>\n    <recordManagerType typeId=\"${TYPE_ID_RM_1}\" valueTypeId=\"${TYPE_ID_RM_2}\"/>\n  </producedTypes>\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n  <useStandardCommands>true</useStandardCommands>\n  <editType>InDialog</editType>\n  <standardAttributes>\n    <dataHistory>Use</dataHistory>\n    <name>Active</name>\n    <fillValue xsi:type=\"core:UndefinedValue\"/>\n    <fullTextSearch>Use</fullTextSearch>\n    <minValue xsi:type=\"core:UndefinedValue\"/>\n    <maxValue xsi:type=\"core:UndefinedValue\"/>\n  </standardAttributes>\n  <standardAttributes>\n    <dataHistory>Use</dataHistory>\n    <name>LineNumber</name>\n    <fillValue xsi:type=\"core:UndefinedValue\"/>\n    <fullTextSearch>Use</fullTextSearch>\n    <minValue xsi:type=\"core:UndefinedValue\"/>\n    <maxValue xsi:type=\"core:UndefinedValue\"/>\n  </standardAttributes>\n  <standardAttributes>\n    <dataHistory>Use</dataHistory>\n    <name>Recorder</name>\n    <fillValue xsi:type=\"core:UndefinedValue\"/>\n    <fullTextSearch>Use</fullTextSearch>\n    <minValue xsi:type=\"core:UndefinedValue\"/>\n    <maxValue xsi:type=\"core:UndefinedValue\"/>\n  </standardAttributes>\n  <standardAttributes>\n    <dataHistory>Use</dataHistory>\n    <name>Period</name>\n    <fillValue xsi:type=\"core:UndefinedValue\"/>\n    <fillChecking>ShowError</fillChecking>\n    <fullTextSearch>Use</fullTextSearch>\n    <minValue xsi:type=\"core:UndefinedValue\"/>\n    <maxValue xsi:type=\"core:UndefinedValue\"/>\n  </standardAttributes>\n  <dataLockControlMode>Managed</dataLockControlMode>\n  <fullTextSearch>Use</fullTextSearch>\n</mdclass:InformationRegister>\n";
    }

    private String getAccumulationRegisterTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:AccumulationRegister xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:core=\"http://g5.1c.ru/v8/dt/mcore\" xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <producedTypes>\n    <selectionType typeId=\"${TYPE_ID_SEL_1}\" valueTypeId=\"${TYPE_ID_SEL_2}\"/>\n    <listType typeId=\"${TYPE_ID_LIST_1}\" valueTypeId=\"${TYPE_ID_LIST_2}\"/>\n    <managerType typeId=\"${TYPE_ID_MGR_1}\" valueTypeId=\"${TYPE_ID_MGR_2}\"/>\n    <recordSetType typeId=\"${TYPE_ID_RS_1}\" valueTypeId=\"${TYPE_ID_RS_2}\"/>\n    <recordKeyType typeId=\"${TYPE_ID_RK_1}\" valueTypeId=\"${TYPE_ID_RK_2}\"/>\n    <recordType typeId=\"${TYPE_ID_REC_1}\" valueTypeId=\"${TYPE_ID_REC_2}\"/>\n    <recordManagerType typeId=\"${TYPE_ID_RM_1}\" valueTypeId=\"${TYPE_ID_RM_2}\"/>\n  </producedTypes>\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n  <useStandardCommands>true</useStandardCommands>\n  <standardAttributes>\n    <dataHistory>Use</dataHistory>\n    <name>RecordType</name>\n    <fillValue xsi:type=\"core:UndefinedValue\"/>\n    <fullTextSearch>Use</fullTextSearch>\n    <minValue xsi:type=\"core:UndefinedValue\"/>\n    <maxValue xsi:type=\"core:UndefinedValue\"/>\n  </standardAttributes>\n  <standardAttributes>\n    <dataHistory>Use</dataHistory>\n    <name>Active</name>\n    <fillValue xsi:type=\"core:UndefinedValue\"/>\n    <fullTextSearch>Use</fullTextSearch>\n    <minValue xsi:type=\"core:UndefinedValue\"/>\n    <maxValue xsi:type=\"core:UndefinedValue\"/>\n  </standardAttributes>\n  <standardAttributes>\n    <dataHistory>Use</dataHistory>\n    <name>LineNumber</name>\n    <fillValue xsi:type=\"core:UndefinedValue\"/>\n    <fullTextSearch>Use</fullTextSearch>\n    <minValue xsi:type=\"core:UndefinedValue\"/>\n    <maxValue xsi:type=\"core:UndefinedValue\"/>\n  </standardAttributes>\n  <standardAttributes>\n    <dataHistory>Use</dataHistory>\n    <name>Recorder</name>\n    <fillValue xsi:type=\"core:UndefinedValue\"/>\n    <fullTextSearch>Use</fullTextSearch>\n    <minValue xsi:type=\"core:UndefinedValue\"/>\n    <maxValue xsi:type=\"core:UndefinedValue\"/>\n  </standardAttributes>\n  <standardAttributes>\n    <dataHistory>Use</dataHistory>\n    <name>Period</name>\n    <fillValue xsi:type=\"core:UndefinedValue\"/>\n    <fillChecking>ShowError</fillChecking>\n    <fullTextSearch>Use</fullTextSearch>\n    <minValue xsi:type=\"core:UndefinedValue\"/>\n    <maxValue xsi:type=\"core:UndefinedValue\"/>\n  </standardAttributes>\n  <dataLockControlMode>Managed</dataLockControlMode>\n  <fullTextSearch>Use</fullTextSearch>\n  <registerType>${REGISTER_TYPE}</registerType>\n  <enableTotalsSplitting>true</enableTotalsSplitting>\n</mdclass:AccumulationRegister>\n";
    }

    private String getAccountingRegisterTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:AccountingRegister xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:core=\"http://g5.1c.ru/v8/dt/mcore\" xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <producedTypes>\n    <selectionType typeId=\"${TYPE_ID_SEL_1}\" valueTypeId=\"${TYPE_ID_SEL_2}\"/>\n    <listType typeId=\"${TYPE_ID_LIST_1}\" valueTypeId=\"${TYPE_ID_LIST_2}\"/>\n    <managerType typeId=\"${TYPE_ID_MGR_1}\" valueTypeId=\"${TYPE_ID_MGR_2}\"/>\n    <recordSetType typeId=\"${TYPE_ID_RS_1}\" valueTypeId=\"${TYPE_ID_RS_2}\"/>\n    <recordKeyType typeId=\"${TYPE_ID_RK_1}\" valueTypeId=\"${TYPE_ID_RK_2}\"/>\n    <recordType typeId=\"${TYPE_ID_REC_1}\" valueTypeId=\"${TYPE_ID_REC_2}\"/>\n    <recordManagerType typeId=\"${TYPE_ID_RM_1}\" valueTypeId=\"${TYPE_ID_RM_2}\"/>\n  </producedTypes>\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n  <useStandardCommands>true</useStandardCommands>\n  <dataLockControlMode>Managed</dataLockControlMode>\n  <fullTextSearch>Use</fullTextSearch>\n  <enableTotalsSplitting>true</enableTotalsSplitting>\n</mdclass:AccountingRegister>\n";
    }

    private String getCalculationRegisterTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:CalculationRegister xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:core=\"http://g5.1c.ru/v8/dt/mcore\" xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <producedTypes>\n    <selectionType typeId=\"${TYPE_ID_SEL_1}\" valueTypeId=\"${TYPE_ID_SEL_2}\"/>\n    <listType typeId=\"${TYPE_ID_LIST_1}\" valueTypeId=\"${TYPE_ID_LIST_2}\"/>\n    <managerType typeId=\"${TYPE_ID_MGR_1}\" valueTypeId=\"${TYPE_ID_MGR_2}\"/>\n    <recordSetType typeId=\"${TYPE_ID_RS_1}\" valueTypeId=\"${TYPE_ID_RS_2}\"/>\n    <recordKeyType typeId=\"${TYPE_ID_RK_1}\" valueTypeId=\"${TYPE_ID_RK_2}\"/>\n    <recordType typeId=\"${TYPE_ID_REC_1}\" valueTypeId=\"${TYPE_ID_REC_2}\"/>\n    <recordManagerType typeId=\"${TYPE_ID_RM_1}\" valueTypeId=\"${TYPE_ID_RM_2}\"/>\n  </producedTypes>\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n  <useStandardCommands>true</useStandardCommands>\n  <dataLockControlMode>Managed</dataLockControlMode>\n  <fullTextSearch>Use</fullTextSearch>\n</mdclass:CalculationRegister>\n";
    }

    private String getDataProcessorTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:DataProcessor xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:core=\"http://g5.1c.ru/v8/dt/mcore\" xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n  <useStandardCommands>true</useStandardCommands>\n</mdclass:DataProcessor>\n";
    }

    private String getReportTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:Report xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:core=\"http://g5.1c.ru/v8/dt/mcore\" xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n  <useStandardCommands>true</useStandardCommands>\n</mdclass:Report>\n";
    }

    private String getCommonFormTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:CommonForm xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n  <usePurposes>PersonalComputer</usePurposes>\n  <usePurposes>MobileDevice</usePurposes>\n</mdclass:CommonForm>\n";
    }

    private String getCommonCommandTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:CommonCommand xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n  <group>NavigationPanelOrdinary</group>\n</mdclass:CommonCommand>\n";
    }

    private String getSubsystemTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:Subsystem xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:core=\"http://g5.1c.ru/v8/dt/mcore\" xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n  <includeHelpInContents>true</includeHelpInContents>\n  <includeInCommandInterface>true</includeInCommandInterface>\n</mdclass:Subsystem>\n";
    }

    private String getRoleTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:Role xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n</mdclass:Role>\n";
    }

    private String getConstantTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:Constant xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:core=\"http://g5.1c.ru/v8/dt/mcore\" xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n  <type>\n    <types>${TYPE}</types>\n  </type>\n  <useStandardCommands>true</useStandardCommands>\n  <minValue xsi:type=\"core:UndefinedValue\"/>\n  <maxValue xsi:type=\"core:UndefinedValue\"/>\n  <dataLockControlMode>Managed</dataLockControlMode>\n</mdclass:Constant>\n";
    }

    private String getSequenceTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:Sequence xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:core=\"http://g5.1c.ru/v8/dt/mcore\" xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n  <moveBoundaryOnPosting>true</moveBoundaryOnPosting>\n</mdclass:Sequence>\n";
    }

    private String getBusinessProcessTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:BusinessProcess xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:core=\"http://g5.1c.ru/v8/dt/mcore\" xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <producedTypes>\n    <objectType typeId=\"${TYPE_ID_OBJ_1}\" valueTypeId=\"${TYPE_ID_OBJ_2}\"/>\n    <refType typeId=\"${TYPE_ID_REF_1}\" valueTypeId=\"${TYPE_ID_REF_2}\"/>\n    <selectionType typeId=\"${TYPE_ID_SEL_1}\" valueTypeId=\"${TYPE_ID_SEL_2}\"/>\n    <listType typeId=\"${TYPE_ID_LIST_1}\" valueTypeId=\"${TYPE_ID_LIST_2}\"/>\n    <managerType typeId=\"${TYPE_ID_MGR_1}\" valueTypeId=\"${TYPE_ID_MGR_2}\"/>\n  </producedTypes>\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n  <useStandardCommands>true</useStandardCommands>\n  <inputByString>BusinessProcess.${NAME}.StandardAttribute.Number</inputByString>\n  <fullTextSearchOnInputByString>DontUse</fullTextSearchOnInputByString>\n  <createOnInput>DontUse</createOnInput>\n  <dataLockControlMode>Managed</dataLockControlMode>\n  <fullTextSearch>Use</fullTextSearch>\n  <numberType>String</numberType>\n  <numberLength>11</numberLength>\n  <checkUnique>true</checkUnique>\n  <autonumbering>true</autonumbering>\n  <editType>InDialog</editType>\n</mdclass:BusinessProcess>\n";
    }

    private String getTaskTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:Task xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:core=\"http://g5.1c.ru/v8/dt/mcore\" xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <producedTypes>\n    <objectType typeId=\"${TYPE_ID_OBJ_1}\" valueTypeId=\"${TYPE_ID_OBJ_2}\"/>\n    <refType typeId=\"${TYPE_ID_REF_1}\" valueTypeId=\"${TYPE_ID_REF_2}\"/>\n    <selectionType typeId=\"${TYPE_ID_SEL_1}\" valueTypeId=\"${TYPE_ID_SEL_2}\"/>\n    <listType typeId=\"${TYPE_ID_LIST_1}\" valueTypeId=\"${TYPE_ID_LIST_2}\"/>\n    <managerType typeId=\"${TYPE_ID_MGR_1}\" valueTypeId=\"${TYPE_ID_MGR_2}\"/>\n  </producedTypes>\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n  <useStandardCommands>true</useStandardCommands>\n  <inputByString>Task.${NAME}.StandardAttribute.Number</inputByString>\n  <inputByString>Task.${NAME}.StandardAttribute.Description</inputByString>\n  <fullTextSearchOnInputByString>DontUse</fullTextSearchOnInputByString>\n  <createOnInput>DontUse</createOnInput>\n  <dataLockControlMode>Managed</dataLockControlMode>\n  <fullTextSearch>Use</fullTextSearch>\n  <numberType>String</numberType>\n  <numberLength>11</numberLength>\n  <checkUnique>true</checkUnique>\n  <autonumbering>true</autonumbering>\n  <descriptionLength>150</descriptionLength>\n  <editType>InDialog</editType>\n</mdclass:Task>\n";
    }

    private String getExchangePlanTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:ExchangePlan xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:core=\"http://g5.1c.ru/v8/dt/mcore\" xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <producedTypes>\n    <objectType typeId=\"${TYPE_ID_OBJ_1}\" valueTypeId=\"${TYPE_ID_OBJ_2}\"/>\n    <refType typeId=\"${TYPE_ID_REF_1}\" valueTypeId=\"${TYPE_ID_REF_2}\"/>\n    <selectionType typeId=\"${TYPE_ID_SEL_1}\" valueTypeId=\"${TYPE_ID_SEL_2}\"/>\n    <listType typeId=\"${TYPE_ID_LIST_1}\" valueTypeId=\"${TYPE_ID_LIST_2}\"/>\n    <managerType typeId=\"${TYPE_ID_MGR_1}\" valueTypeId=\"${TYPE_ID_MGR_2}\"/>\n  </producedTypes>\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n  <useStandardCommands>true</useStandardCommands>\n  <inputByString>ExchangePlan.${NAME}.StandardAttribute.Description</inputByString>\n  <inputByString>ExchangePlan.${NAME}.StandardAttribute.Code</inputByString>\n  <fullTextSearchOnInputByString>DontUse</fullTextSearchOnInputByString>\n  <createOnInput>DontUse</createOnInput>\n  <dataLockControlMode>Managed</dataLockControlMode>\n  <fullTextSearch>Use</fullTextSearch>\n  <codeLength>10</codeLength>\n  <codeAllowedLength>Variable</codeAllowedLength>\n  <descriptionLength>150</descriptionLength>\n  <editType>InDialog</editType>\n  <choiceMode>BothWays</choiceMode>\n</mdclass:ExchangePlan>\n";
    }

    private String getWebServiceTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:WebService xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:core=\"http://g5.1c.ru/v8/dt/mcore\" xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n  <namespace>http://www.example.com/${NAME}</namespace>\n</mdclass:WebService>\n";
    }

    private String getHttpServiceTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:HTTPService xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:core=\"http://g5.1c.ru/v8/dt/mcore\" xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n  <rootURL>${NAME}</rootURL>\n</mdclass:HTTPService>\n";
    }

    private String getScheduledJobTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:ScheduledJob xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n  <methodName>${METHOD_NAME}</methodName>\n</mdclass:ScheduledJob>\n";
    }

    private String getEventSubscriptionTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:EventSubscription xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n  <source/>\n  <event>${EVENT}</event>\n  <handler>${HANDLER}</handler>\n</mdclass:EventSubscription>\n";
    }

    private String getChartOfCharacteristicTypesTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:ChartOfCharacteristicTypes xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:core=\"http://g5.1c.ru/v8/dt/mcore\" xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <producedTypes>\n    <objectType typeId=\"${TYPE_ID_OBJ_1}\" valueTypeId=\"${TYPE_ID_OBJ_2}\"/>\n    <refType typeId=\"${TYPE_ID_REF_1}\" valueTypeId=\"${TYPE_ID_REF_2}\"/>\n    <selectionType typeId=\"${TYPE_ID_SEL_1}\" valueTypeId=\"${TYPE_ID_SEL_2}\"/>\n    <listType typeId=\"${TYPE_ID_LIST_1}\" valueTypeId=\"${TYPE_ID_LIST_2}\"/>\n    <managerType typeId=\"${TYPE_ID_MGR_1}\" valueTypeId=\"${TYPE_ID_MGR_2}\"/>\n  </producedTypes>\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n  <useStandardCommands>true</useStandardCommands>\n  <inputByString>ChartOfCharacteristicTypes.${NAME}.StandardAttribute.Description</inputByString>\n  <fullTextSearchOnInputByString>DontUse</fullTextSearchOnInputByString>\n  <createOnInput>DontUse</createOnInput>\n  <dataLockControlMode>Managed</dataLockControlMode>\n  <fullTextSearch>Use</fullTextSearch>\n  <type/>\n  <hierarchical>true</hierarchical>\n  <foldersOnTop>true</foldersOnTop>\n  <descriptionLength>150</descriptionLength>\n  <checkUnique>true</checkUnique>\n  <defaultPresentation>AsDescription</defaultPresentation>\n  <editType>InDialog</editType>\n  <choiceMode>BothWays</choiceMode>\n</mdclass:ChartOfCharacteristicTypes>\n";
    }

    private String getChartOfAccountsTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:ChartOfAccounts xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:core=\"http://g5.1c.ru/v8/dt/mcore\" xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <producedTypes>\n    <objectType typeId=\"${TYPE_ID_OBJ_1}\" valueTypeId=\"${TYPE_ID_OBJ_2}\"/>\n    <refType typeId=\"${TYPE_ID_REF_1}\" valueTypeId=\"${TYPE_ID_REF_2}\"/>\n    <selectionType typeId=\"${TYPE_ID_SEL_1}\" valueTypeId=\"${TYPE_ID_SEL_2}\"/>\n    <listType typeId=\"${TYPE_ID_LIST_1}\" valueTypeId=\"${TYPE_ID_LIST_2}\"/>\n    <managerType typeId=\"${TYPE_ID_MGR_1}\" valueTypeId=\"${TYPE_ID_MGR_2}\"/>\n  </producedTypes>\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n  <useStandardCommands>true</useStandardCommands>\n  <inputByString>ChartOfAccounts.${NAME}.StandardAttribute.Description</inputByString>\n  <inputByString>ChartOfAccounts.${NAME}.StandardAttribute.Code</inputByString>\n  <fullTextSearchOnInputByString>DontUse</fullTextSearchOnInputByString>\n  <createOnInput>DontUse</createOnInput>\n  <dataLockControlMode>Managed</dataLockControlMode>\n  <fullTextSearch>Use</fullTextSearch>\n  <codeLength>20</codeLength>\n  <codeAllowedLength>Variable</codeAllowedLength>\n  <descriptionLength>150</descriptionLength>\n  <checkUnique>true</checkUnique>\n  <autoOrderByCode>true</autoOrderByCode>\n  <orderLength>5</orderLength>\n  <defaultPresentation>AsDescription</defaultPresentation>\n  <editType>InDialog</editType>\n  <choiceMode>BothWays</choiceMode>\n</mdclass:ChartOfAccounts>\n";
    }

    private String getChartOfCalculationTypesTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:ChartOfCalculationTypes xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:core=\"http://g5.1c.ru/v8/dt/mcore\" xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <producedTypes>\n    <objectType typeId=\"${TYPE_ID_OBJ_1}\" valueTypeId=\"${TYPE_ID_OBJ_2}\"/>\n    <refType typeId=\"${TYPE_ID_REF_1}\" valueTypeId=\"${TYPE_ID_REF_2}\"/>\n    <selectionType typeId=\"${TYPE_ID_SEL_1}\" valueTypeId=\"${TYPE_ID_SEL_2}\"/>\n    <listType typeId=\"${TYPE_ID_LIST_1}\" valueTypeId=\"${TYPE_ID_LIST_2}\"/>\n    <managerType typeId=\"${TYPE_ID_MGR_1}\" valueTypeId=\"${TYPE_ID_MGR_2}\"/>\n  </producedTypes>\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n  <useStandardCommands>true</useStandardCommands>\n  <inputByString>ChartOfCalculationTypes.${NAME}.StandardAttribute.Description</inputByString>\n  <fullTextSearchOnInputByString>DontUse</fullTextSearchOnInputByString>\n  <createOnInput>DontUse</createOnInput>\n  <dataLockControlMode>Managed</dataLockControlMode>\n  <fullTextSearch>Use</fullTextSearch>\n  <codeLength>20</codeLength>\n  <descriptionLength>150</descriptionLength>\n  <defaultPresentation>AsDescription</defaultPresentation>\n  <editType>InDialog</editType>\n  <choiceMode>BothWays</choiceMode>\n</mdclass:ChartOfCalculationTypes>\n";
    }

    public String getAttributeTemplate() {
        return "  <attributes uuid=\"${UUID}\">\n    <name>${NAME}</name>\n    <synonym>\n      <key>ru</key>\n      <value>${SYNONYM}</value>\n    </synonym>\n    <type>\n      <types>${TYPE}</types>\n      ${TYPE_QUALIFIERS}\n    </type>\n    <minValue xsi:type=\"core:UndefinedValue\"/>\n    <maxValue xsi:type=\"core:UndefinedValue\"/>\n    <fillChecking>${FILL_CHECKING}</fillChecking>\n    <fullTextSearch>Use</fullTextSearch>\n    <dataHistory>Use</dataHistory>\n    <indexing>${INDEXING}</indexing>\n  </attributes>\n";
    }

    public String getTabularSectionTemplate() {
        return "  <tabularSections uuid=\"${UUID}\">\n    <producedTypes>\n      <objectType typeId=\"${TYPE_ID_OBJ_1}\" valueTypeId=\"${TYPE_ID_OBJ_2}\"/>\n      <rowType typeId=\"${TYPE_ID_ROW_1}\" valueTypeId=\"${TYPE_ID_ROW_2}\"/>\n    </producedTypes>\n    <name>${NAME}</name>\n    <synonym>\n      <key>ru</key>\n      <value>${SYNONYM}</value>\n    </synonym>\n    <standardAttributes>\n      <dataHistory>Use</dataHistory>\n      <name>LineNumber</name>\n      <fillValue xsi:type=\"core:UndefinedValue\"/>\n      <fullTextSearch>Use</fullTextSearch>\n      <minValue xsi:type=\"core:UndefinedValue\"/>\n      <maxValue xsi:type=\"core:UndefinedValue\"/>\n    </standardAttributes>\n${ATTRIBUTES}\n  </tabularSections>\n";
    }

    public String getEnumValueTemplate() {
        return "  <enumValues uuid=\"${UUID}\">\n    <name>${NAME}</name>\n    <synonym>\n      <key>ru</key>\n      <value>${SYNONYM}</value>\n    </synonym>\n  </enumValues>\n";
    }

    public String getDimensionTemplate() {
        return "  <dimensions uuid=\"${UUID}\">\n    <name>${NAME}</name>\n    <synonym>\n      <key>ru</key>\n      <value>${SYNONYM}</value>\n    </synonym>\n    <type>\n      <types>${TYPE}</types>\n      ${TYPE_QUALIFIERS}\n    </type>\n    <minValue xsi:type=\"core:UndefinedValue\"/>\n    <maxValue xsi:type=\"core:UndefinedValue\"/>\n    <fullTextSearch>Use</fullTextSearch>\n    <dataHistory>Use</dataHistory>\n    <fillFromFillingValue>true</fillFromFillingValue>\n    <fillValue xsi:type=\"core:UndefinedValue\"/>\n    <master>${MASTER}</master>\n    <mainFilter>${MAIN_FILTER}</mainFilter>\n  </dimensions>\n";
    }

    public String getResourceTemplate() {
        return "  <resources uuid=\"${UUID}\">\n    <name>${NAME}</name>\n    <synonym>\n      <key>ru</key>\n      <value>${SYNONYM}</value>\n    </synonym>\n    <type>\n      <types>${TYPE}</types>\n      ${TYPE_QUALIFIERS}\n    </type>\n    <minValue xsi:type=\"core:UndefinedValue\"/>\n    <maxValue xsi:type=\"core:UndefinedValue\"/>\n    <fullTextSearch>Use</fullTextSearch>\n    <dataHistory>Use</dataHistory>\n    <fillValue xsi:type=\"core:UndefinedValue\"/>\n  </resources>\n";
    }

    public String getFormReferenceTemplate() {
        return "  <forms uuid=\"${UUID}\">\n    <name>${NAME}</name>\n    <synonym>\n      <key>ru</key>\n      <value>${SYNONYM}</value>\n    </synonym>\n    <usePurposes>PersonalComputer</usePurposes>\n    <usePurposes>MobileDevice</usePurposes>\n  </forms>\n";
    }

    public String getFormFileTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<form:Form xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:core=\"http://g5.1c.ru/v8/dt/mcore\" xmlns:form=\"http://g5.1c.ru/v8/dt/form\">\n  <autoCommandBar>\n    <name>\u0424\u043e\u0440\u043c\u0430\u041a\u043e\u043c\u0430\u043d\u0434\u043d\u0430\u044f\u041f\u0430\u043d\u0435\u043b\u044c</name>\n    <id>-1</id>\n    <visible>true</visible>\n    <enabled>true</enabled>\n    <userVisible>\n      <common>true</common>\n    </userVisible>\n    <horizontalAlign>Left</horizontalAlign>\n  </autoCommandBar>\n  <autoTitle>true</autoTitle>\n  <autoUrl>true</autoUrl>\n  <group>Vertical</group>\n  <autoFillCheck>true</autoFillCheck>\n  <allowFormCustomize>true</allowFormCustomize>\n  <enabled>true</enabled>\n  <verticalScroll>UseIfNecessary</verticalScroll>\n  <horizontalScroll>UseIfNecessary</horizontalScroll>\n  <showTitle>true</showTitle>\n  <showCloseButton>true</showCloseButton>\n  <commandInterface>\n    <navigationPanel/>\n    <commandBar/>\n  </commandInterface>\n</form:Form>\n";
    }

    public String getItemFormFileTemplate(String objectType, String formExtInfo) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<form:Form xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:form=\"http://g5.1c.ru/v8/dt/form\">\n  <autoCommandBar>\n    <name>\u0424\u043e\u0440\u043c\u0430\u041a\u043e\u043c\u0430\u043d\u0434\u043d\u0430\u044f\u041f\u0430\u043d\u0435\u043b\u044c</name>\n    <id>-1</id>\n    <horizontalAlign>Left</horizontalAlign>\n    <autoFill>true</autoFill>\n  </autoCommandBar>\n  <windowOpeningMode>LockOwnerWindow</windowOpeningMode>\n  <saveWindowSettings>true</saveWindowSettings>\n  <autoTitle>true</autoTitle>\n  <autoUrl>true</autoUrl>\n  <group>Vertical</group>\n  <autoFillCheck>true</autoFillCheck>\n  <allowFormCustomize>true</allowFormCustomize>\n  <enabled>true</enabled>\n  <showTitle>true</showTitle>\n  <showCloseButton>true</showCloseButton>\n  <attributes>\n    <name>\u041e\u0431\u044a\u0435\u043a\u0442</name>\n    <id>1</id>\n    <valueType>\n      <types>%s</types>\n    </valueType>\n    <view>\n      <common>true</common>\n    </view>\n    <edit>\n      <common>true</common>\n    </edit>\n    <main>true</main>\n    <savedData>true</savedData>\n  </attributes>\n  <commandInterface>\n    <navigationPanel/>\n    <commandBar/>\n  </commandInterface>\n  <extInfo xsi:type=\"form:%s\"/>\n</form:Form>\n".formatted(objectType, formExtInfo);
    }

    public String getListFormFileTemplate(String mainTable) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<form:Form xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:core=\"http://g5.1c.ru/v8/dt/mcore\" xmlns:form=\"http://g5.1c.ru/v8/dt/form\">\n  <autoCommandBar>\n    <name>\u0424\u043e\u0440\u043c\u0430\u041a\u043e\u043c\u0430\u043d\u0434\u043d\u0430\u044f\u041f\u0430\u043d\u0435\u043b\u044c</name>\n    <id>-1</id>\n    <horizontalAlign>Left</horizontalAlign>\n    <autoFill>true</autoFill>\n  </autoCommandBar>\n  <saveWindowSettings>true</saveWindowSettings>\n  <autoTitle>true</autoTitle>\n  <autoUrl>true</autoUrl>\n  <group>Vertical</group>\n  <autoFillCheck>true</autoFillCheck>\n  <allowFormCustomize>true</allowFormCustomize>\n  <enabled>true</enabled>\n  <showTitle>true</showTitle>\n  <showCloseButton>true</showCloseButton>\n  <attributes>\n    <name>\u0421\u043f\u0438\u0441\u043e\u043a</name>\n    <id>1</id>\n    <valueType>\n      <types>DynamicList</types>\n    </valueType>\n    <view>\n      <common>true</common>\n    </view>\n    <edit>\n      <common>true</common>\n    </edit>\n    <main>true</main>\n    <extInfo xsi:type=\"form:DynamicListExtInfo\">\n      <mainTable>%s</mainTable>\n      <dynamicDataRead>true</dynamicDataRead>\n      <autoFillAvailableFields>true</autoFillAvailableFields>\n      <autoSaveUserSettings>true</autoSaveUserSettings>\n      <getInvisibleFieldPresentations>true</getInvisibleFieldPresentations>\n    </extInfo>\n  </attributes>\n  <commandInterface>\n    <navigationPanel/>\n    <commandBar/>\n  </commandInterface>\n  <extInfo xsi:type=\"form:DynamicListFormExtInfo\"/>\n</form:Form>\n".formatted(mainTable);
    }

    public String getChoiceFormFileTemplate(String mainTable) {
        return this.getListFormFileTemplate(mainTable);
    }

    public String getFormModuleTemplate() {
        return "\n";
    }

    private String getCommonTemplateTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:CommonTemplate xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n  <templateType>TextDocument</templateType>\n</mdclass:CommonTemplate>\n";
    }

    private String getCommonPictureTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:CommonPicture xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n</mdclass:CommonPicture>\n";
    }

    private String getCommonAttributeTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:CommonAttribute xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:core=\"http://g5.1c.ru/v8/dt/mcore\" xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n  <type>\n    <types>String</types>\n    <stringQualifiers>\n      <length>100</length>\n    </stringQualifiers>\n  </type>\n  <minValue xsi:type=\"core:UndefinedValue\"/>\n  <maxValue xsi:type=\"core:UndefinedValue\"/>\n  <autoUse>DontUse</autoUse>\n  <dataHistory>Use</dataHistory>\n</mdclass:CommonAttribute>\n";
    }

    private String getWsReferenceTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:WSReference xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n</mdclass:WSReference>\n";
    }

    private String getXdtoPackageTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:XDTOPackage xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n  <namespace>http://example.com/${NAME}</namespace>\n</mdclass:XDTOPackage>\n";
    }

    private String getExternalDataSourceTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:ExternalDataSource xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n</mdclass:ExternalDataSource>\n";
    }

    private String getSessionParameterTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:SessionParameter xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:core=\"http://g5.1c.ru/v8/dt/mcore\" xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n  <type>\n    <types>String</types>\n    <stringQualifiers>\n      <length>100</length>\n    </stringQualifiers>\n  </type>\n</mdclass:SessionParameter>\n";
    }

    private String getSettingsStorageTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:SettingsStorage xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n</mdclass:SettingsStorage>\n";
    }

    private String getDocumentJournalTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:DocumentJournal xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <producedTypes>\n    <selectionType typeId=\"${TYPE_ID_SEL_1}\" valueTypeId=\"${TYPE_ID_SEL_2}\"/>\n    <listType typeId=\"${TYPE_ID_LIST_1}\" valueTypeId=\"${TYPE_ID_LIST_2}\"/>\n    <managerType typeId=\"${TYPE_ID_MGR_1}\" valueTypeId=\"${TYPE_ID_MGR_2}\"/>\n  </producedTypes>\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n  <useStandardCommands>true</useStandardCommands>\n</mdclass:DocumentJournal>\n";
    }

    private String getDocumentNumeratorTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:DocumentNumerator xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n  <numberType>String</numberType>\n  <numberLength>11</numberLength>\n  <numberAllowedLength>Variable</numberAllowedLength>\n  <checkUnique>true</checkUnique>\n  <numberPeriodicity>Year</numberPeriodicity>\n</mdclass:DocumentNumerator>\n";
    }

    private String getDefinedTypeTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:DefinedType xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:core=\"http://g5.1c.ru/v8/dt/mcore\" xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n  <type>\n    <types>String</types>\n    <stringQualifiers>\n      <length>100</length>\n    </stringQualifiers>\n  </type>\n</mdclass:DefinedType>\n";
    }

    private String getFunctionalOptionTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:FunctionalOption xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n  <privilegedGetMode>true</privilegedGetMode>\n</mdclass:FunctionalOption>\n";
    }

    private String getFunctionalOptionsParameterTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:FunctionalOptionsParameter xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n</mdclass:FunctionalOptionsParameter>\n";
    }

    private String getFilterCriterionTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:FilterCriterion xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <producedTypes>\n    <listType typeId=\"${TYPE_ID_LIST_1}\" valueTypeId=\"${TYPE_ID_LIST_2}\"/>\n    <managerType typeId=\"${TYPE_ID_MGR_1}\" valueTypeId=\"${TYPE_ID_MGR_2}\"/>\n  </producedTypes>\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n</mdclass:FilterCriterion>\n";
    }

    private String getCommandGroupTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:CommandGroup xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n  <representation>Auto</representation>\n</mdclass:CommandGroup>\n";
    }

    private String getStyleTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:Style xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n</mdclass:Style>\n";
    }

    private String getStyleItemTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:StyleItem xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n  <type>Color</type>\n</mdclass:StyleItem>\n";
    }

    private String getLanguageTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:Language xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n  <languageCode>ru</languageCode>\n</mdclass:Language>\n";
    }

    private String getIntegrationServiceTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:IntegrationService xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n</mdclass:IntegrationService>\n";
    }

    private String getWebSocketClientTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:WebSocketClient xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n</mdclass:WebSocketClient>\n";
    }

    private String getBotTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:Bot xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n</mdclass:Bot>\n";
    }

    private String getInterfaceTemplate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mdclass:Interface xmlns:mdclass=\"http://g5.1c.ru/v8/dt/metadata/mdclass\" uuid=\"${UUID}\">\n  <name>${NAME}</name>\n  <synonym>\n    <key>ru</key>\n    <value>${SYNONYM}</value>\n  </synonym>\n</mdclass:Interface>\n";
    }
}

