/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.tools.metadata;

import com.example.vibe.core.tools.ITool;
import com.example.vibe.core.tools.ToolResult;
import com.example.vibe.core.tools.metadata.MetadataKind;
import com.example.vibe.core.tools.metadata.MetadataResolver;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IFile;

public class OpenModuleTool
implements ITool {
    private static final String SCHEMA = "{\n    \"type\": \"object\",\n    \"properties\": {\n        \"kind\": {\n            \"type\": \"string\",\n            \"description\": \"\u0422\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430: Catalog/\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a, Document/\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0438 \u0434\u0440.\"\n        },\n        \"name\": {\n            \"type\": \"string\",\n            \"description\": \"\u0418\u043c\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445\"\n        },\n        \"module\": {\n            \"type\": \"string\",\n            \"description\": \"\u0422\u0438\u043f \u043c\u043e\u0434\u0443\u043b\u044f: Module, ObjectModule/\u041c\u043e\u0434\u0443\u043b\u044c\u041e\u0431\u044a\u0435\u043a\u0442\u0430, ManagerModule/\u041c\u043e\u0434\u0443\u043b\u044c\u041c\u0435\u043d\u0435\u0434\u0436\u0435\u0440\u0430, RecordSetModule/\u041c\u043e\u0434\u0443\u043b\u044c\u041d\u0430\u0431\u043e\u0440\u0430\u0417\u0430\u043f\u0438\u0441\u0435\u0439, FormModule/\u041c\u043e\u0434\u0443\u043b\u044c\u0424\u043e\u0440\u043c\u044b\"\n        },\n        \"form_name\": {\n            \"type\": \"string\",\n            \"description\": \"\u0418\u043c\u044f \u0444\u043e\u0440\u043c\u044b (\u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f module=FormModule)\"\n        },\n        \"start_line\": {\n            \"type\": \"integer\",\n            \"description\": \"\u041d\u0430\u0447\u0430\u043b\u044c\u043d\u0430\u044f \u0441\u0442\u0440\u043e\u043a\u0430 (\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e 1)\"\n        },\n        \"end_line\": {\n            \"type\": \"integer\",\n            \"description\": \"\u041a\u043e\u043d\u0435\u0447\u043d\u0430\u044f \u0441\u0442\u0440\u043e\u043a\u0430 (\u0435\u0441\u043b\u0438 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u2014 \u0447\u0438\u0442\u0430\u0442\u044c \u0434\u043e \u043a\u043e\u043d\u0446\u0430)\"\n        }\n    },\n    \"required\": [\"kind\", \"name\", \"module\"]\n}\n";

    @Override
    public String getName() {
        return "open_module";
    }

    @Override
    public String getDescription() {
        return "\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u043c\u043e\u0434\u0443\u043b\u044c \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445 1\u0421. \u0427\u0438\u0442\u0430\u0435\u0442 \u043a\u043e\u0434 \u0438\u0437 ObjectModule, ManagerModule, RecordSetModule \u0438\u043b\u0438 \u043c\u043e\u0434\u0443\u043b\u044f \u0444\u043e\u0440\u043c\u044b.";
    }

    @Override
    public String getParameterSchema() {
        return SCHEMA;
    }

    @Override
    public CompletableFuture<ToolResult> execute(Map<String, Object> parameters) {
        return CompletableFuture.supplyAsync(() -> {
            Object v;
            String kindStr = (String)parameters.get("kind");
            String name = (String)parameters.get("name");
            String moduleType = (String)parameters.get("module");
            String formName = (String)parameters.get("form_name");
            int startLine = 1;
            int endLine = Integer.MAX_VALUE;
            boolean endLineProvided = parameters.containsKey("end_line");
            Object v2 = parameters.get("start_line");
            if (v2 instanceof Number) {
                void num;
                Number number = (Number)v2;
                Number cfr_ignored_0 = (Number)v2;
                startLine = num.intValue();
            }
            if ((v = parameters.get("end_line")) instanceof Number) {
                void num;
                Number number = (Number)v;
                Number cfr_ignored_1 = (Number)v;
                endLine = num.intValue();
            }
            if (kindStr == null || kindStr.isEmpty()) {
                return ToolResult.failure("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0442\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 (kind)");
            }
            if (name == null || name.isEmpty()) {
                return ToolResult.failure("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0438\u043c\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 (name)");
            }
            if (moduleType == null || moduleType.isEmpty()) {
                return ToolResult.failure("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0442\u0438\u043f \u043c\u043e\u0434\u0443\u043b\u044f (module): ObjectModule, ManagerModule, RecordSetModule, FormModule");
            }
            MetadataKind kind = MetadataKind.fromString(kindStr);
            if (kind == null) {
                return ToolResult.failure("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430: " + kindStr);
            }
            try {
                MetadataResolver resolver = MetadataResolver.getInstance();
                MetadataResolver.MetadataObject obj = resolver.getMetadata(kind, name);
                if (obj == null) {
                    return ToolResult.failure(kind.getRussianSingular() + " '" + name + "' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                }
                String normalizedModule = this.normalizeModuleType(moduleType);
                IFile moduleFile = this.getModuleFile(obj, normalizedModule, formName);
                if (moduleFile == null || !moduleFile.exists()) {
                    List<String> availableModules = obj.getAvailableModules();
                    StringBuilder sb = new StringBuilder();
                    sb.append("\u041c\u043e\u0434\u0443\u043b\u044c '").append(moduleType).append("' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 ").append(kind.getRussianSingular()).append(".").append(name).append("\n\n");
                    if (!availableModules.isEmpty()) {
                        sb.append("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u043c\u043e\u0434\u0443\u043b\u0438:\n");
                        for (String m : availableModules) {
                            sb.append("- ").append(m).append("\n");
                        }
                    }
                    return ToolResult.failure(sb.toString());
                }
                String content = this.readFileContent(moduleFile, startLine, endLine);
                int totalLines = endLineProvided ? this.countLines(moduleFile) : -1;
                StringBuilder sb = new StringBuilder();
                sb.append("**").append(kind.getRussianSingular()).append(".").append(obj.getName()).append(" / ").append(this.getModuleDisplayName(normalizedModule, formName)).append("**\n");
                sb.append("\u041f\u0443\u0442\u044c: `").append(moduleFile.getFullPath().toString()).append("`\n");
                if (endLineProvided && totalLines >= 0) {
                    sb.append("\u0421\u0442\u0440\u043e\u043a\u0438: ").append(startLine).append("-").append(Math.min(endLine, totalLines)).append(" \u0438\u0437 ").append(totalLines).append("\n\n");
                } else {
                    sb.append("\u0421\u0442\u0440\u043e\u043a\u0438: ").append(startLine).append("-\u043a\u043e\u043d\u0435\u0446\n\n");
                }
                sb.append("```bsl\n");
                sb.append(content);
                sb.append("```\n");
                if (endLineProvided && totalLines > 0 && endLine < totalLines) {
                    sb.append("\n*\u0414\u043b\u044f \u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0430 \u043e\u0441\u0442\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0430 \u0443\u043a\u0430\u0436\u0438\u0442\u0435 start_line=").append(endLine + 1).append("*\n");
                }
                return ToolResult.success(sb.toString(), ToolResult.ToolResultType.CODE);
            }
            catch (Exception e) {
                return ToolResult.failure("\u041e\u0448\u0438\u0431\u043a\u0430: " + e.getMessage());
            }
        });
    }

    private String normalizeModuleType(String moduleType) {
        String lower = moduleType.toLowerCase();
        if (lower.contains("\u043e\u0431\u044a\u0435\u043a\u0442") || lower.equals("objectmodule")) {
            return "ObjectModule";
        }
        if (lower.contains("\u043c\u0435\u043d\u0435\u0434\u0436\u0435\u0440") || lower.equals("managermodule")) {
            return "ManagerModule";
        }
        if (lower.contains("\u043d\u0430\u0431\u043e\u0440") || lower.contains("recordset") || lower.equals("recordsetmodule")) {
            return "RecordSetModule";
        }
        if (lower.contains("\u0444\u043e\u0440\u043c") || lower.equals("formmodule")) {
            return "FormModule";
        }
        if (lower.equals("module") || lower.equals("\u043c\u043e\u0434\u0443\u043b\u044c")) {
            return "Module";
        }
        return moduleType;
    }

    private IFile getModuleFile(MetadataResolver.MetadataObject obj, String moduleType, String formName) {
        return switch (moduleType) {
            case "ObjectModule" -> {
                IFile  secretYieldValue;
                yield  secretYieldValue = obj.getObjectModule();
            }
            case "ManagerModule" -> {
                IFile  secretYieldValue;
                yield  secretYieldValue = obj.getManagerModule();
            }
            case "RecordSetModule" -> {
                IFile  secretYieldValue;
                yield  secretYieldValue = obj.getRecordSetModule();
            }
            case "Module" -> {
                IFile  secretYieldValue;
                yield  secretYieldValue = obj.getModule();
            }
            case "FormModule" -> {
                IFile  secretYieldValue;
                if (formName == null || formName.isEmpty()) {
                    try {
                        List<String> forms = obj.getFormNames();
                        if (!forms.isEmpty()) {
                            IFile  secretYieldValue;
                            yield  secretYieldValue = obj.getFormModule(forms.get(0));
                        }
                    }
                    catch (Exception v1) {}
                    Object  secretYieldValue = null;
                    yield  secretYieldValue;
                }
                yield  secretYieldValue = obj.getFormModule(formName);
            }
            default -> {
                IFile  secretYieldValue;
                yield  secretYieldValue = null;
            }
        };
    }

    private String getModuleDisplayName(String moduleType, String formName) {
        return switch (moduleType) {
            case "ObjectModule" -> "\u041c\u043e\u0434\u0443\u043b\u044c \u043e\u0431\u044a\u0435\u043a\u0442\u0430";
            case "ManagerModule" -> "\u041c\u043e\u0434\u0443\u043b\u044c \u043c\u0435\u043d\u0435\u0434\u0436\u0435\u0440\u0430";
            case "RecordSetModule" -> "\u041c\u043e\u0434\u0443\u043b\u044c \u043d\u0430\u0431\u043e\u0440\u0430 \u0437\u0430\u043f\u0438\u0441\u0435\u0439";
            case "Module" -> "\u041c\u043e\u0434\u0443\u043b\u044c";
            case "FormModule" -> "\u0424\u043e\u0440\u043c\u0430 " + (formName != null ? formName : "");
            default -> moduleType;
        };
    }

    private String readFileContent(IFile file, int startLine, int endLine) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(file.getContents(), StandardCharsets.UTF_8));){
                String line;
                StringBuilder sb = new StringBuilder();
                int lineNum = 0;
                while ((line = reader.readLine()) != null) {
                    if (++lineNum >= startLine && lineNum <= endLine) {
                        sb.append(String.format("%4d\u2502 %s%n", lineNum, line));
                    }
                    if (lineNum > endLine) break;
                }
                return sb.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            return "\u041e\u0448\u0438\u0431\u043a\u0430 \u0447\u0442\u0435\u043d\u0438\u044f: " + e.getMessage();
        }
    }

    private int countLines(IFile file) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(file.getContents(), StandardCharsets.UTF_8));){
                int count = 0;
                while (reader.readLine() != null) {
                    ++count;
                }
                return count;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            return 0;
        }
    }
}

