/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.tools.metadata;

import com.example.vibe.core.logging.VibeLogger;
import com.example.vibe.core.tools.ITool;
import com.example.vibe.core.tools.ToolResult;
import com.example.vibe.core.tools.metadata.BmMetadataService;
import com.example.vibe.core.tools.metadata.MetadataKind;
import com.example.vibe.core.tools.metadata.MetadataResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IProject;

public class ListMetadataTool
implements ITool {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(ListMetadataTool.class);
    private static final String SCHEMA = "{\n    \"type\": \"object\",\n    \"properties\": {\n        \"kind\": {\n            \"type\": \"string\",\n            \"description\": \"\u0422\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445: Catalog/\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a, Document/\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442, AccumulationRegister/\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u041d\u0430\u043a\u043e\u043f\u043b\u0435\u043d\u0438\u044f, InformationRegister/\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0421\u0432\u0435\u0434\u0435\u043d\u0438\u0439, CommonModule/\u041e\u0431\u0449\u0438\u0439\u041c\u043e\u0434\u0443\u043b\u044c, DataProcessor/\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430, Report/\u041e\u0442\u0447\u0435\u0442 \u0438 \u0434\u0440.\"\n        },\n        \"name_query\": {\n            \"type\": \"string\",\n            \"description\": \"\u041f\u043e\u0434\u0441\u0442\u0440\u043e\u043a\u0430 \u0434\u043b\u044f \u043f\u043e\u0438\u0441\u043a\u0430 \u043f\u043e \u0438\u043c\u0435\u043d\u0438 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 (\u043d\u0435\u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e)\"\n        },\n        \"synonym_query\": {\n            \"type\": \"string\",\n            \"description\": \"\u041f\u043e\u0434\u0441\u0442\u0440\u043e\u043a\u0430 \u0434\u043b\u044f \u043f\u043e\u0438\u0441\u043a\u0430 \u043f\u043e \u0441\u0438\u043d\u043e\u043d\u0438\u043c\u0443 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 (\u043d\u0435\u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e, \u0442\u0440\u0435\u0431\u0443\u0435\u0442 BM API)\"\n        },\n        \"limit\": {\n            \"type\": \"integer\",\n            \"description\": \"\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 (\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e 50)\"\n        }\n    }\n}\n";
    private static final int DEFAULT_LIMIT = 50;

    @Override
    public String getName() {
        return "list_metadata";
    }

    @Override
    public String getDescription() {
        return "\u0421\u043f\u0438\u0441\u043e\u043a \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445 1\u0421 \u043f\u043e \u0442\u0438\u043f\u0443. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0434\u043b\u044f \u043f\u043e\u0438\u0441\u043a\u0430 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u043e\u0432, \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432, \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0438 \u0434\u0440\u0443\u0433\u0438\u0445 \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432.";
    }

    @Override
    public String getParameterSchema() {
        return SCHEMA;
    }

    @Override
    public CompletableFuture<ToolResult> execute(Map<String, Object> parameters) {
        return CompletableFuture.supplyAsync(() -> {
            LOG.info("[TOOL] list_metadata called with parameters: %s", parameters);
            String kindStr = (String)parameters.get("kind");
            String nameQuery = (String)parameters.get("name_query");
            String synonymQuery = (String)parameters.get("synonym_query");
            int limit = 50;
            Object v = parameters.get("limit");
            if (v instanceof Number) {
                void num;
                Number number = (Number)v;
                Number cfr_ignored_0 = (Number)v;
                limit = num.intValue();
            }
            LOG.info("[TOOL] list_metadata: kind=%s, nameQuery=%s, synonymQuery=%s, limit=%d", kindStr, nameQuery, synonymQuery, limit);
            try {
                if (synonymQuery != null && !synonymQuery.isEmpty()) {
                    LOG.info("[TOOL] list_metadata: using BM service for synonym search");
                    return this.executeWithBmService(kindStr, nameQuery, synonymQuery, limit);
                }
                return this.executeFileBased(kindStr, nameQuery, limit);
            }
            catch (Exception e) {
                LOG.warn("Error listing metadata: %s", e.getMessage());
                return ToolResult.failure("\u041e\u0448\u0438\u0431\u043a\u0430: " + e.getMessage());
            }
        });
    }

    private ToolResult executeWithBmService(String kindStr, String nameQuery, String synonymQuery, int limit) {
        BmMetadataService bmService = BmMetadataService.getInstance();
        if (!bmService.isAvailable()) {
            return ToolResult.failure("BM \u0441\u0435\u0440\u0432\u0438\u0441 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d. \u041f\u043e\u0438\u0441\u043a \u043f\u043e \u0441\u0438\u043d\u043e\u043d\u0438\u043c\u0443 \u0442\u0440\u0435\u0431\u0443\u0435\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d\u043d\u044b\u0439 EDT.");
        }
        Optional<IProject> projectOpt = bmService.findProject();
        if (projectOpt.isEmpty()) {
            return ToolResult.failure("\u041f\u0440\u043e\u0435\u043a\u0442 1\u0421 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0440\u0430\u0431\u043e\u0447\u0435\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438");
        }
        MetadataKind kind = null;
        if (kindStr != null && !kindStr.isEmpty() && (kind = MetadataKind.fromString(kindStr)) == null) {
            return ToolResult.failure("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430: " + kindStr + ". \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435: Catalog, Document, AccumulationRegister \u0438 \u0434\u0440.");
        }
        List<BmMetadataService.ObjectDetails> results = bmService.search(projectOpt.get(), kind, nameQuery, synonymQuery, limit);
        if (results.isEmpty()) {
            MetadataKind k;
            StringBuilder msg = new StringBuilder("\u041e\u0431\u044a\u0435\u043a\u0442\u044b \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b");
            if (kindStr != null && (k = MetadataKind.fromString(kindStr)) != null) {
                msg.append(" (\u0442\u0438\u043f: ").append(k.getRussianPlural()).append(")");
            }
            if (nameQuery != null) {
                msg.append(" \u0441 \u0438\u043c\u0435\u043d\u0435\u043c '").append(nameQuery).append("'");
            }
            if (synonymQuery != null) {
                msg.append(" \u0441 \u0441\u0438\u043d\u043e\u043d\u0438\u043c\u043e\u043c '").append(synonymQuery).append("'");
            }
            return ToolResult.success(msg.toString());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("**\u041d\u0430\u0439\u0434\u0435\u043d\u043e \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432: ").append(results.size()).append("**\n\n");
        sb.append("| \u0422\u0438\u043f | \u0418\u043c\u044f | \u0421\u0438\u043d\u043e\u043d\u0438\u043c |\n");
        sb.append("|-----|-----|--------|\n");
        for (BmMetadataService.ObjectDetails obj : results) {
            String kindName = obj.kind != null ? obj.kind.getRussianSingular() : "\u2014";
            String synonym = obj.synonym != null ? obj.synonym : "\u2014";
            sb.append("| ").append(kindName);
            sb.append(" | ").append(obj.name);
            sb.append(" | ").append(synonym).append(" |\n");
        }
        if (results.size() == limit) {
            sb.append("\n*\u041f\u043e\u043a\u0430\u0437\u0430\u043d\u044b \u043f\u0435\u0440\u0432\u044b\u0435 ").append(limit).append(" \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432*\n");
        }
        return ToolResult.success(sb.toString());
    }

    private ToolResult executeFileBased(String kindStr, String nameQuery, int limit) throws Exception {
        List<MetadataResolver.MetadataObject> objects;
        MetadataResolver resolver = MetadataResolver.getInstance();
        if (resolver.find1CProject() == null) {
            return ToolResult.failure("\u041f\u0440\u043e\u0435\u043a\u0442 1\u0421 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0440\u0430\u0431\u043e\u0447\u0435\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438");
        }
        if (kindStr != null && !kindStr.isEmpty()) {
            MetadataKind kind = MetadataKind.fromString(kindStr);
            if (kind == null) {
                return ToolResult.failure("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430: " + kindStr + ". \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435: Catalog, Document, AccumulationRegister, InformationRegister, CommonModule, DataProcessor, Report \u0438 \u0434\u0440.");
            }
            objects = resolver.listMetadata(kind);
            if (nameQuery != null && !nameQuery.isEmpty()) {
                String lowerQuery = nameQuery.toLowerCase();
                objects = objects.stream().filter(o -> o.getName().toLowerCase().contains(lowerQuery)).toList();
            }
        } else if (nameQuery != null && !nameQuery.isEmpty()) {
            objects = resolver.searchMetadata(nameQuery);
        } else {
            return ToolResult.failure("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 kind (\u0442\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430), name_query (\u043f\u043e\u0438\u0441\u043a \u043f\u043e \u0438\u043c\u0435\u043d\u0438) \u0438\u043b\u0438 synonym_query (\u043f\u043e\u0438\u0441\u043a \u043f\u043e \u0441\u0438\u043d\u043e\u043d\u0438\u043c\u0443)");
        }
        if (objects.isEmpty()) {
            MetadataKind kind;
            StringBuilder msg = new StringBuilder("\u041e\u0431\u044a\u0435\u043a\u0442\u044b \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b");
            if (kindStr != null && (kind = MetadataKind.fromString(kindStr)) != null) {
                msg.append(" (\u0442\u0438\u043f: ").append(kind.getRussianPlural()).append(")");
            }
            if (nameQuery != null) {
                msg.append(" \u0441 \u0438\u043c\u0435\u043d\u0435\u043c '").append(nameQuery).append("'");
            }
            return ToolResult.success(msg.toString());
        }
        if (objects.size() > limit) {
            objects = new ArrayList<MetadataResolver.MetadataObject>(objects.subList(0, limit));
        }
        Map<String, String> synonyms = this.getSynonymsFromBm(objects);
        StringBuilder sb = new StringBuilder();
        sb.append("**\u041d\u0430\u0439\u0434\u0435\u043d\u043e \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432: ").append(objects.size()).append("**\n\n");
        if (!synonyms.isEmpty()) {
            sb.append("| \u0422\u0438\u043f | \u0418\u043c\u044f | \u0421\u0438\u043d\u043e\u043d\u0438\u043c | \u041f\u0443\u0442\u044c |\n");
            sb.append("|-----|-----|--------|------|\n");
            for (MetadataResolver.MetadataObject obj : objects) {
                String fqn = obj.getKind().buildFqn(obj.getName());
                String synonym = synonyms.getOrDefault(fqn, "\u2014");
                sb.append("| ").append(obj.getKind().getRussianSingular());
                sb.append(" | ").append(obj.getName());
                sb.append(" | ").append(synonym);
                sb.append(" | `").append(obj.getPath()).append("` |\n");
            }
        } else {
            sb.append("| \u0422\u0438\u043f | \u0418\u043c\u044f | \u041f\u0443\u0442\u044c |\n");
            sb.append("|-----|-----|------|\n");
            for (MetadataResolver.MetadataObject obj : objects) {
                sb.append("| ").append(obj.getKind().getRussianSingular());
                sb.append(" | ").append(obj.getName());
                sb.append(" | `").append(obj.getPath()).append("` |\n");
            }
        }
        if (objects.size() == limit) {
            sb.append("\n*\u041f\u043e\u043a\u0430\u0437\u0430\u043d\u044b \u043f\u0435\u0440\u0432\u044b\u0435 ").append(limit).append(" \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432*\n");
        }
        return ToolResult.success(sb.toString());
    }

    private Map<String, String> getSynonymsFromBm(List<MetadataResolver.MetadataObject> objects) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            BmMetadataService bmService = BmMetadataService.getInstance();
            if (!bmService.isAvailable()) {
                return result;
            }
            Optional<IProject> projectOpt = bmService.findProject();
            if (projectOpt.isEmpty()) {
                return result;
            }
            IProject project = projectOpt.get();
            for (MetadataResolver.MetadataObject obj : objects) {
                Optional<BmMetadataService.ObjectDetails> details = bmService.findByKindAndName(project, obj.getKind(), obj.getName());
                details.ifPresent(d -> {
                    if (d.synonym != null) {
                        result.put(d.fqn, d.synonym);
                    }
                });
            }
        }
        catch (Exception e) {
            LOG.debug("Error getting synonyms from BM: %s", e.getMessage());
        }
        return result;
    }
}

