/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.tools.metadata;

import com.example.vibe.core.logging.VibeLogger;
import com.example.vibe.core.tools.metadata.MetadataKind;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class BmMetadataService {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(BmMetadataService.class);
    private static BmMetadataService instance;
    private static final String[] BM_MODEL_MANAGER_CLASSES;
    private static final String V8_PROJECT_MANAGER_CLASS = "com._1c.g5.v8.dt.core.platform.IV8ProjectManager";
    private static final String MD_CLASS_PACKAGE_CLASS = "com._1c.g5.v8.dt.metadata.mdclass.MdClassPackage";
    private volatile Object modelManager;
    private volatile Object projectManager;
    private volatile ServiceReference<?> modelManagerRef;
    private volatile ServiceReference<?> projectManagerRef;
    private volatile Class<?> mdClassPackageClass;
    private volatile Object mdClassPackageLiterals;
    private volatile ExecuteMethodInfo cachedExecuteMethodInfo;
    private volatile boolean initialized = false;
    private volatile boolean available = false;

    static {
        BM_MODEL_MANAGER_CLASSES = new String[]{"com._1c.g5.v8.dt.core.platform.IBmModelManager", "com._1c.g5.v8.bm.integration.IBmModelManager", "com._1c.g5.v8.bm.core.IBmModelManager"};
    }

    private BmMetadataService() {
    }

    public static synchronized BmMetadataService getInstance() {
        if (instance == null) {
            instance = new BmMetadataService();
        }
        return instance;
    }

    public boolean isAvailable() {
        this.ensureInitialized();
        return this.available;
    }

    public void reinitialize() {
        this.initialized = false;
        this.ensureInitialized();
    }

    private synchronized void ensureInitialized() {
        block17: {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            this.available = false;
            try {
                Bundle bundle = FrameworkUtil.getBundle(this.getClass());
                if (bundle == null) {
                    LOG.debug("Bundle not available");
                    return;
                }
                BundleContext context = bundle.getBundleContext();
                if (context == null) {
                    LOG.debug("BundleContext not available");
                    return;
                }
                this.logAvailableBmServices(context);
                this.modelManager = this.getServiceViaServiceAccess(BM_MODEL_MANAGER_CLASSES[0]);
                if (this.modelManager != null) {
                    LOG.info("[BM] Got modelManager via ServiceAccess");
                }
                this.projectManager = this.getServiceViaServiceAccess(V8_PROJECT_MANAGER_CLASS);
                if (this.projectManager != null) {
                    LOG.info("[BM] Got projectManager via ServiceAccess");
                }
                if (this.modelManager == null) {
                    String[] stringArray = BM_MODEL_MANAGER_CLASSES;
                    int n = BM_MODEL_MANAGER_CLASSES.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String className = stringArray[n2];
                        this.modelManagerRef = this.getServiceReference(context, className);
                        if (this.modelManagerRef != null) {
                            this.modelManager = context.getService(this.modelManagerRef);
                            if (this.modelManager != null) {
                                LOG.info("[BM] Found modelManager via OSGi: %s", className);
                                break;
                            }
                        }
                        ++n2;
                    }
                }
                if (this.projectManager == null) {
                    this.projectManagerRef = this.getServiceReference(context, V8_PROJECT_MANAGER_CLASS);
                    if (this.projectManagerRef != null) {
                        this.projectManager = context.getService(this.projectManagerRef);
                        if (this.projectManager != null) {
                            LOG.info("[BM] Found projectManager via OSGi");
                        }
                    }
                }
                if (this.modelManager == null || this.projectManager == null) {
                    LOG.debug("EDT services not available: modelManager=%s, projectManager=%s", this.modelManager != null, this.projectManager != null);
                    return;
                }
                try {
                    this.mdClassPackageClass = Class.forName(MD_CLASS_PACKAGE_CLASS);
                    this.mdClassPackageLiterals = this.mdClassPackageClass.getField("Literals").get(null);
                    LOG.info("[BM] MdClassPackage loaded successfully");
                }
                catch (Exception e) {
                    LOG.info("[BM] MdClassPackage not available (listByKind won't work): %s", e.getMessage());
                }
                this.available = true;
                LOG.info("[BM] BmMetadataService initialized successfully");
                LOG.info("[BM]   modelManager: %s", this.modelManager.getClass().getName());
                LOG.info("[BM]   projectManager: %s", this.projectManager.getClass().getName());
                LOG.info("[BM]   mdClassPackageLiterals: %s", this.mdClassPackageLiterals != null);
            }
            catch (Exception e) {
                LOG.warn("Failed to initialize BmMetadataService: %s", e.getMessage());
                LOG.warn("  Exception type: %s", e.getClass().getName());
                if (e.getCause() == null) break block17;
                LOG.warn("  Cause: %s", e.getCause().getMessage());
            }
        }
    }

    private Object getServiceViaServiceAccess(String className) {
        try {
            Class<?> serviceAccessClass = Class.forName("com._1c.g5.wiring.ServiceAccess");
            Class<?> serviceClass = Class.forName(className);
            Method getMethod = serviceAccessClass.getMethod("get", Class.class);
            Object service = getMethod.invoke(null, serviceClass);
            if (service != null) {
                LOG.debug("[BM] ServiceAccess.get(%s) returned: %s", className, service.getClass().getName());
            }
            return service;
        }
        catch (ClassNotFoundException e) {
            LOG.debug("[BM] ServiceAccess or service class not found: %s", e.getMessage());
        }
        catch (Exception e) {
            LOG.debug("[BM] ServiceAccess.get failed for %s: %s", className, e.getMessage());
        }
        return null;
    }

    private void logAvailableBmServices(BundleContext context) {
        try {
            ServiceReference[] allRefs = context.getAllServiceReferences(null, null);
            if (allRefs == null) {
                LOG.debug("[BM] No services registered in OSGi");
                return;
            }
            LOG.debug("[BM] Searching for BM/Model services among %d registered services...", allRefs.length);
            int bmCount = 0;
            ServiceReference[] serviceReferenceArray = allRefs;
            int n = allRefs.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference ref = serviceReferenceArray[n2];
                String[] objectClasses = (String[])ref.getProperty("objectClass");
                if (objectClasses != null) {
                    String[] stringArray = objectClasses;
                    int n3 = objectClasses.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String cls = stringArray[n4];
                        if (cls.contains("BmModel") || cls.contains("IBmModel") || cls.contains("ModelManager") || cls.contains("bm.integration")) {
                            LOG.info("[BM] Found potential service: %s", cls);
                            ++bmCount;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            if (bmCount == 0) {
                LOG.debug("[BM] No BM-related services found in registry");
            }
        }
        catch (Exception e) {
            LOG.debug("[BM] Error listing services: %s", e.getMessage());
        }
    }

    private ServiceReference<?> getServiceReference(BundleContext context, String className) {
        try {
            ServiceReference ref = context.getServiceReference(className);
            if (ref != null) {
                LOG.debug("[BM] Found service reference for: %s", className);
            } else {
                LOG.debug("[BM] No service reference found for: %s", className);
            }
            return ref;
        }
        catch (Exception e) {
            LOG.debug("[BM] Error getting service reference for %s: %s", className, e.getMessage());
            return null;
        }
    }

    public void dispose() {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        if (bundle == null) {
            return;
        }
        BundleContext context = bundle.getBundleContext();
        if (context == null) {
            return;
        }
        if (this.modelManagerRef != null) {
            try {
                context.ungetService(this.modelManagerRef);
            }
            catch (Exception e) {
                LOG.debug("Error releasing modelManager service: %s", e.getMessage());
            }
            this.modelManagerRef = null;
        }
        if (this.projectManagerRef != null) {
            try {
                context.ungetService(this.projectManagerRef);
            }
            catch (Exception e) {
                LOG.debug("Error releasing projectManager service: %s", e.getMessage());
            }
            this.projectManagerRef = null;
        }
        this.modelManager = null;
        this.projectManager = null;
        this.cachedExecuteMethodInfo = null;
        this.initialized = false;
        this.available = false;
        LOG.debug("BmMetadataService disposed");
    }

    public Optional<IProject> findProject() {
        if (!this.isAvailable()) {
            return Optional.empty();
        }
        try {
            Method getProjects = this.projectManager.getClass().getMethod("getProjects", new Class[0]);
            Collection projects = (Collection)getProjects.invoke(this.projectManager, new Object[0]);
            if (projects.isEmpty()) {
                return Optional.empty();
            }
            Object v8Project = projects.iterator().next();
            Method getProject = v8Project.getClass().getMethod("getProject", new Class[0]);
            IProject project = (IProject)getProject.invoke(v8Project, new Object[0]);
            return Optional.ofNullable(project);
        }
        catch (Exception e) {
            LOG.warn("Failed to find project: %s", e.getMessage());
            return Optional.empty();
        }
    }

    public Optional<ObjectDetails> findByFqn(IProject project, String fqn) {
        block6: {
            LOG.info("[BM] findByFqn called: project=%s, fqn=%s", project != null ? project.getName() : "null", fqn);
            if (!this.isAvailable()) {
                LOG.info("[BM] findByFqn: service not available");
                return Optional.empty();
            }
            if (project == null || fqn == null) {
                LOG.info("[BM] findByFqn: null parameters");
                return Optional.empty();
            }
            try {
                Method getBmNamespace = this.modelManager.getClass().getMethod("getBmNamespace", IProject.class);
                Object namespace = getBmNamespace.invoke(this.modelManager, project);
                if (namespace == null) {
                    LOG.info("[BM] findByFqn: no BM namespace for project: %s", project.getName());
                    return Optional.empty();
                }
                LOG.info("[BM] findByFqn: got namespace %s", namespace.getClass().getName());
                Object result = this.executeReadOnlyTask(namespace, fqn);
                if (result != null) {
                    LOG.info("[BM] findByFqn: found object %s", result.getClass().getName());
                    ObjectDetails details = this.extractDetails(result);
                    LOG.info("[BM] findByFqn: extracted details - name=%s, attrs=%d, ts=%d", details.name, details.attributes.size(), details.tabularSections.size());
                    return Optional.of(details);
                }
                LOG.info("[BM] findByFqn: object not found for fqn=%s", fqn);
            }
            catch (Exception e) {
                LOG.warn("[BM] findByFqn failed for '%s': %s", fqn, e.getMessage());
                LOG.warn("[BM]   Exception: %s", e.getClass().getName());
                if (e.getCause() == null) break block6;
                LOG.warn("[BM]   Cause: %s - %s", e.getCause().getClass().getName(), e.getCause().getMessage());
            }
        }
        return Optional.empty();
    }

    public Optional<ObjectDetails> findByKindAndName(IProject project, MetadataKind kind, String name) {
        if (kind == null || name == null) {
            return Optional.empty();
        }
        String fqn = kind.buildFqn(name);
        return this.findByFqn(project, fqn);
    }

    public List<ObjectDetails> listByKind(IProject project, MetadataKind kind) {
        LOG.debug("[BM] listByKind called: project=%s, kind=%s", project != null ? project.getName() : "null", kind != null ? kind.getEnglishName() : "null");
        if (!this.isAvailable() || project == null || kind == null) {
            LOG.debug("[BM] listByKind: service not available or null parameters");
            return Collections.emptyList();
        }
        try {
            Method getBmNamespace = this.modelManager.getClass().getMethod("getBmNamespace", IProject.class);
            Object namespace = getBmNamespace.invoke(this.modelManager, project);
            if (namespace == null) {
                LOG.debug("[BM] listByKind: no BM namespace for project");
                return Collections.emptyList();
            }
            Object eClass = this.getEClass(kind);
            if (eClass == null) {
                LOG.debug("[BM] listByKind: no EClass for kind: %s", kind.getEnglishName());
                return Collections.emptyList();
            }
            List<ObjectDetails> result = this.executeListTask(namespace, eClass);
            LOG.debug("[BM] listByKind: found %d objects for kind %s", result.size(), kind.getEnglishName());
            return result;
        }
        catch (Exception e) {
            LOG.warn("[BM] listByKind failed for '%s': %s", kind.getEnglishName(), e.getMessage());
            LOG.debug("[BM] listByKind exception details", e);
            return Collections.emptyList();
        }
    }

    public List<ObjectDetails> search(IProject project, MetadataKind kind, String namePattern, String synonymPattern, int limit) {
        LOG.info("[BM] search called: project=%s, kind=%s, namePattern=%s, synonymPattern=%s, limit=%d", project != null ? project.getName() : "null", kind != null ? kind.getEnglishName() : "all", namePattern, synonymPattern, limit);
        if (!this.isAvailable() || project == null) {
            LOG.info("[BM] search: service not available or null project");
            return Collections.emptyList();
        }
        ArrayList<ObjectDetails> result = new ArrayList<ObjectDetails>();
        String lowerNamePattern = namePattern != null ? namePattern.toLowerCase() : null;
        String lowerSynonymPattern = synonymPattern != null ? synonymPattern.toLowerCase() : null;
        List<MetadataKind> kinds = kind != null ? List.of(kind) : List.of(MetadataKind.values());
        LOG.info("[BM] search: searching across %d kinds", kinds.size());
        block0: for (MetadataKind k : kinds) {
            if (result.size() >= limit) break;
            List<ObjectDetails> objects = this.listByKind(project, k);
            LOG.debug("[BM] search: kind=%s returned %d objects", k.getEnglishName(), objects.size());
            for (ObjectDetails obj : objects) {
                if (result.size() >= limit) continue block0;
                boolean matches = true;
                if (!(lowerNamePattern == null || obj.name != null && obj.name.toLowerCase().contains(lowerNamePattern))) {
                    matches = false;
                }
                if (matches && lowerSynonymPattern != null && (obj.synonym == null || !obj.synonym.toLowerCase().contains(lowerSynonymPattern))) {
                    matches = false;
                }
                if (!matches) continue;
                result.add(obj);
            }
        }
        LOG.info("[BM] search: found %d matching objects", result.size());
        return result;
    }

    public List<ReferenceInfo> findReferences(IProject project, String fqn, int limit) {
        LOG.info("[BM] findReferences called: project=%s, fqn=%s, limit=%d", project != null ? project.getName() : "null", fqn, limit);
        if (!this.isAvailable() || project == null || fqn == null) {
            LOG.info("[BM] findReferences: service not available or null parameters");
            return Collections.emptyList();
        }
        try {
            Method getBmNamespace = this.modelManager.getClass().getMethod("getBmNamespace", IProject.class);
            Object namespace = getBmNamespace.invoke(this.modelManager, project);
            if (namespace == null) {
                LOG.info("[BM] findReferences: no BM namespace for project: %s", project.getName());
                return Collections.emptyList();
            }
            LOG.info("[BM] findReferences: got namespace %s", namespace.getClass().getName());
            List<ReferenceInfo> result = this.executeReferencesTask(namespace, fqn, limit);
            LOG.info("[BM] findReferences: found %d references for %s", result.size(), fqn);
            return result;
        }
        catch (Exception e) {
            LOG.warn("[BM] findReferences failed for '%s': %s", fqn, e.getMessage());
            LOG.debug("[BM] findReferences exception details", e);
            return Collections.emptyList();
        }
    }

    private List<ReferenceInfo> executeReferencesTask(Object namespace, String targetFqn, int limit) throws Exception {
        ExecuteMethodInfo info = this.findExecuteMethod();
        if (info == null) {
            LOG.warn("[BM] executeReadOnlyTask method not found");
            return Collections.emptyList();
        }
        Object ns = namespace;
        String fqn = targetFqn;
        int maxResults = limit;
        Object task = Proxy.newProxyInstance(info.taskClass.getClassLoader(), new Class[]{info.taskClass}, (proxy, method, args) -> {
            if ("execute".equals(method.getName())) {
                Object transaction = args[0];
                Method getTopObjectByFqn = null;
                Method[] methodArray = transaction.getClass().getMethods();
                int n2 = methodArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    Method m = methodArray[n3];
                    if ("getTopObjectByFqn".equals(m.getName()) && m.getParameterCount() == 2) {
                        getTopObjectByFqn = m;
                        break;
                    }
                    ++n3;
                }
                if (getTopObjectByFqn == null) {
                    LOG.warn("[BM] getTopObjectByFqn method not found");
                    return Collections.emptyList();
                }
                Object targetObj = getTopObjectByFqn.invoke(transaction, ns, fqn);
                if (targetObj == null) {
                    LOG.debug("Target object not found: %s", fqn);
                    return Collections.emptyList();
                }
                Method getReferences = null;
                Method[] methodArray2 = transaction.getClass().getMethods();
                int n4 = methodArray2.length;
                int n5 = 0;
                while (n5 < n4) {
                    Method m = methodArray2[n5];
                    if ("getReferences".equals(m.getName()) && m.getParameterCount() == 2) {
                        getReferences = m;
                        break;
                    }
                    ++n5;
                }
                if (getReferences == null) {
                    LOG.warn("[BM] getReferences method not found");
                    return Collections.emptyList();
                }
                Collection refs = (Collection)getReferences.invoke(transaction, targetObj, ns);
                ArrayList<ReferenceInfo> result = new ArrayList<ReferenceInfo>();
                for (Object ref : refs) {
                    if (result.size() >= maxResults) break;
                    ReferenceInfo info2 = this.extractReferenceInfo(ref);
                    if (info2 == null) continue;
                    result.add(info2);
                }
                return result;
            }
            return Collections.emptyList();
        });
        List<ReferenceInfo> result = (List<ReferenceInfo>)this.invokeExecuteReadOnlyTask(info, namespace, task);
        return result != null ? result : Collections.emptyList();
    }

    private ReferenceInfo extractReferenceInfo(Object crossRef) {
        try {
            Object feature;
            ReferenceInfo info = new ReferenceInfo();
            Object sourceObj = this.invokeMethod(crossRef, "getObject");
            if (sourceObj != null) {
                info.sourceName = (String)this.invokeMethod(sourceObj, "getName");
                Object sourceEClass = this.invokeMethod(sourceObj, "eClass");
                if (sourceEClass != null) {
                    String eClassName = (String)this.invokeMethod(sourceEClass, "getName");
                    info.sourceFqn = eClassName + "." + info.sourceName;
                    info.sourceKind = MetadataKind.fromFqn(info.sourceFqn);
                }
            }
            if ((feature = this.invokeMethod(crossRef, "getFeature")) != null) {
                info.featureName = (String)this.invokeMethod(feature, "getName");
            }
            return info;
        }
        catch (Exception e) {
            LOG.debug("Error extracting reference info: %s", e.getMessage());
            return null;
        }
    }

    private Object executeReadOnlyTask(Object namespace, String fqn) throws Exception {
        ExecuteMethodInfo info = this.findExecuteMethod();
        if (info == null) {
            LOG.warn("[BM] executeReadOnlyTask method with task parameter not found");
            return null;
        }
        LOG.debug("[BM] Found executeReadOnlyTask, taskClass=%s, needsNamespace=%s", info.taskClass.getName(), info.needsNamespaceParam);
        Object task = Proxy.newProxyInstance(info.taskClass.getClassLoader(), new Class[]{info.taskClass}, (proxy, method, args) -> {
            if ("execute".equals(method.getName())) {
                Object transaction = args[0];
                Method getTopObjectByFqn = null;
                Method[] methodArray = transaction.getClass().getMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Method m = methodArray[n2];
                    if ("getTopObjectByFqn".equals(m.getName()) && m.getParameterCount() == 2) {
                        getTopObjectByFqn = m;
                        break;
                    }
                    ++n2;
                }
                if (getTopObjectByFqn == null) {
                    LOG.warn("[BM] getTopObjectByFqn method not found on transaction");
                    return null;
                }
                return getTopObjectByFqn.invoke(transaction, namespace, fqn);
            }
            return null;
        });
        return this.invokeExecuteReadOnlyTask(info, namespace, task);
    }

    private ExecuteMethodInfo findExecuteMethod() {
        ExecuteMethodInfo result;
        if (this.cachedExecuteMethodInfo != null) {
            return this.cachedExecuteMethodInfo;
        }
        Method[] methods = this.modelManager.getClass().getMethods();
        ExecuteMethodInfo platformTaskInfo = null;
        ExecuteMethodInfo fallbackInfo = null;
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if ("executeReadOnlyTask".equals(m.getName())) {
                Class<?>[] paramTypes = m.getParameterTypes();
                int i = 0;
                while (i < paramTypes.length) {
                    Class<?> paramType = paramTypes[i];
                    String paramName = paramType.getName();
                    if (paramName.contains("Task") || paramName.contains("task")) {
                        ExecuteMethodInfo info = new ExecuteMethodInfo();
                        info.method = m;
                        info.taskClass = paramType;
                        boolean bl = info.needsNamespaceParam = paramTypes.length >= 2 && i > 0 && paramTypes[0].getName().contains("Namespace");
                        if (paramName.contains("IBmPlatformTask") && paramTypes.length == 1) {
                            platformTaskInfo = info;
                            LOG.debug("[BM] Found preferred IBmPlatformTask method");
                            break;
                        }
                        if (fallbackInfo != null) break;
                        fallbackInfo = info;
                        LOG.debug("[BM] Found fallback task method: %s", paramName);
                        break;
                    }
                    ++i;
                }
            }
            ++n2;
        }
        ExecuteMethodInfo executeMethodInfo = result = platformTaskInfo != null ? platformTaskInfo : fallbackInfo;
        if (result != null) {
            this.cachedExecuteMethodInfo = result;
            LOG.debug("[BM] Cached executeReadOnlyTask method: taskClass=%s, needsNamespace=%s", result.taskClass.getName(), result.needsNamespaceParam);
        }
        return result;
    }

    private Object invokeExecuteReadOnlyTask(ExecuteMethodInfo info, Object namespace, Object task) throws Exception {
        LOG.debug("[BM] Invoking executeReadOnlyTask with %d args, needsNamespace=%s", info.method.getParameterCount(), info.needsNamespaceParam);
        if (info.needsNamespaceParam) {
            return info.method.invoke(this.modelManager, namespace, task);
        }
        return info.method.invoke(this.modelManager, task);
    }

    private Class<?> getNamespaceInterface(Object namespace) {
        Class<?>[] classArray = namespace.getClass().getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> iface = classArray[n2];
            if (iface.getName().contains("IBmNamespace")) {
                return iface;
            }
            ++n2;
        }
        return namespace.getClass();
    }

    private List<ObjectDetails> executeListTask(Object namespace, Object eClass) throws Exception {
        ExecuteMethodInfo info = this.findExecuteMethod();
        if (info == null) {
            LOG.warn("[BM] executeReadOnlyTask method not found");
            return Collections.emptyList();
        }
        Object ns = namespace;
        Object ec = eClass;
        Object task = Proxy.newProxyInstance(info.taskClass.getClassLoader(), new Class[]{info.taskClass}, (proxy, method, args) -> {
            if ("execute".equals(method.getName())) {
                Object transaction = args[0];
                Method getTopObjectIterator = null;
                Method[] methodArray = transaction.getClass().getMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Method m = methodArray[n2];
                    if ("getTopObjectIterator".equals(m.getName()) && m.getParameterCount() == 2) {
                        getTopObjectIterator = m;
                        break;
                    }
                    ++n2;
                }
                if (getTopObjectIterator == null) {
                    LOG.warn("[BM] getTopObjectIterator method not found");
                    return Collections.emptyList();
                }
                Iterator it = (Iterator)getTopObjectIterator.invoke(transaction, ns, ec);
                ArrayList<ObjectDetails> result = new ArrayList<ObjectDetails>();
                while (it.hasNext()) {
                    Object obj = it.next();
                    result.add(this.extractDetails(obj));
                }
                return result;
            }
            return Collections.emptyList();
        });
        List<ObjectDetails> result = (List<ObjectDetails>)this.invokeExecuteReadOnlyTask(info, namespace, task);
        return result != null ? result : Collections.emptyList();
    }

    private Object getEClass(MetadataKind kind) {
        if (this.mdClassPackageLiterals == null) {
            return null;
        }
        String fieldName = this.getEClassFieldName(kind);
        if (fieldName == null) {
            return null;
        }
        try {
            return this.mdClassPackageLiterals.getClass().getField(fieldName).get(this.mdClassPackageLiterals);
        }
        catch (Exception exception) {
            LOG.debug("EClass field not found: %s", fieldName);
            return null;
        }
    }

    private String getEClassFieldName(MetadataKind kind) {
        return kind.name();
    }

    private ObjectDetails extractDetails(Object mdObject) {
        ObjectDetails details = new ObjectDetails();
        try {
            details.name = (String)this.invokeMethod(mdObject, "getName");
            Object eClass = this.invokeMethod(mdObject, "eClass");
            if (eClass != null) {
                String eClassName = (String)this.invokeMethod(eClass, "getName");
                details.fqn = eClassName + "." + details.name;
                details.kind = MetadataKind.fromFqn(details.fqn);
            }
            details.synonym = this.extractSynonym(mdObject);
            if (this.isInstanceOf(mdObject, "com._1c.g5.v8.dt.metadata.mdclass.BasicDbObject")) {
                Object numberLength;
                details.attributes = this.extractFeatureList(mdObject, "getAttributes");
                details.tabularSections = this.extractTabularSections(mdObject);
                if (this.isInstanceOf(mdObject, "com._1c.g5.v8.dt.metadata.mdclass.Catalog")) {
                    Object codeLength = this.invokeMethod(mdObject, "getCodeLength");
                    Object descLength = this.invokeMethod(mdObject, "getDescriptionLength");
                    Object hierarchical = this.invokeMethod(mdObject, "isHierarchical");
                    if (codeLength != null) {
                        details.properties.put("codeLength", codeLength.toString());
                    }
                    if (descLength != null) {
                        details.properties.put("descriptionLength", descLength.toString());
                    }
                    if (hierarchical != null) {
                        details.properties.put("hierarchical", hierarchical.toString());
                    }
                }
                if (this.isInstanceOf(mdObject, "com._1c.g5.v8.dt.metadata.mdclass.Document") && (numberLength = this.invokeMethod(mdObject, "getNumberLength")) != null) {
                    details.properties.put("numberLength", numberLength.toString());
                }
            }
            if (this.isInstanceOf(mdObject, "com._1c.g5.v8.dt.metadata.mdclass.BasicRegister")) {
                Object periodicityName;
                Object periodicity;
                details.dimensions = this.extractFeatureList(mdObject, "getDimensions");
                details.resources = this.extractFeatureList(mdObject, "getResources");
                if (this.isInstanceOf(mdObject, "com._1c.g5.v8.dt.metadata.mdclass.InformationRegister") && (periodicity = this.invokeMethod(mdObject, "getInformationRegisterPeriodicity")) != null && (periodicityName = this.invokeMethod(periodicity, "getName")) != null) {
                    details.properties.put("periodicity", periodicityName.toString());
                }
            }
        }
        catch (Exception e) {
            LOG.debug("Error extracting details: %s", e.getMessage());
        }
        return details;
    }

    /*
     * WARNING - void declaration
     */
    private String extractSynonym(Object mdObject) {
        Object synonym;
        block11: {
            synonym = this.invokeMethod(mdObject, "getSynonym");
            if (synonym != null) break block11;
            return null;
        }
        try {
            Object content;
            Object t;
            Object t2;
            Iterable<Object> first;
            Object values;
            Object t3 = values = this.invokeMethodSilent(synonym, "values");
            if (t3 instanceof Collection) {
                void coll;
                Collection collection = (Collection)t3;
                Collection cfr_ignored_0 = (Collection)t3;
                if (!coll.isEmpty() && (first = coll.iterator().next()) != null) {
                    return first.toString();
                }
            }
            if ((t2 = synonym) instanceof Iterable) {
                void iterable;
                first = (Iterable)t2;
                Iterable cfr_ignored_1 = (Iterable)t2;
                for (Object entry : iterable) {
                    Object content2 = this.invokeMethodSilent(entry, "getContent");
                    if (content2 != null) {
                        return content2.toString();
                    }
                    Object value = this.invokeMethodSilent(entry, "getValue");
                    if (value != null) {
                        return value.toString();
                    }
                    String str = entry.toString();
                    if (str == null || str.isEmpty() || str.contains("@")) continue;
                    return str;
                }
            }
            if ((t = (content = this.invokeMethodSilent(synonym, "getContent"))) instanceof List) {
                Object first2;
                Object langContent;
                void list;
                List list2 = (List)t;
                List cfr_ignored_2 = (List)t;
                if (!list.isEmpty() && (langContent = this.invokeMethodSilent(first2 = list.get(0), "getContent")) != null) {
                    return langContent.toString();
                }
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private <T> T invokeMethodSilent(Object obj, String methodName) {
        if (obj == null) {
            return null;
        }
        try {
            Method method = obj.getClass().getMethod(methodName, new Class[0]);
            return (T)method.invoke(obj, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<FeatureInfo> extractFeatureList(Object mdObject, String methodName) {
        ArrayList<FeatureInfo> result = new ArrayList<FeatureInfo>();
        try {
            Object list;
            Object t = list = this.invokeMethod(mdObject, methodName);
            if (t instanceof List) {
                void features;
                List list2 = (List)t;
                List cfr_ignored_0 = (List)t;
                for (Object feature : features) {
                    FeatureInfo info = new FeatureInfo();
                    info.name = (String)this.invokeMethod(feature, "getName");
                    info.synonym = this.extractSynonym(feature);
                    result.add(info);
                }
            }
        }
        catch (Exception e) {
            LOG.debug("Error extracting features via %s: %s", methodName, e.getMessage());
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private List<TabularSectionInfo> extractTabularSections(Object mdObject) {
        ArrayList<TabularSectionInfo> result = new ArrayList<TabularSectionInfo>();
        try {
            Object list;
            Object t = list = this.invokeMethod(mdObject, "getTabularSections");
            if (t instanceof List) {
                void sections;
                List list2 = (List)t;
                List cfr_ignored_0 = (List)t;
                for (Object section : sections) {
                    TabularSectionInfo info = new TabularSectionInfo();
                    info.name = (String)this.invokeMethod(section, "getName");
                    info.synonym = this.extractSynonym(section);
                    info.attributes = this.extractFeatureList(section, "getAttributes");
                    result.add(info);
                }
            }
        }
        catch (Exception e) {
            LOG.debug("Error extracting tabular sections: %s", e.getMessage());
        }
        return result;
    }

    private <T> T invokeMethod(Object obj, String methodName) {
        if (obj == null) {
            return null;
        }
        try {
            Method method = obj.getClass().getMethod(methodName, new Class[0]);
            return (T)method.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            LOG.debug("Method invocation failed: %s.%s - %s", obj.getClass().getName(), methodName, e.getMessage());
            return null;
        }
    }

    private boolean isInstanceOf(Object obj, String className) {
        if (obj == null) {
            return false;
        }
        return this.isAssignableFrom(obj.getClass(), className);
    }

    private boolean isAssignableFrom(Class<?> clazz, String targetClassName) {
        if (clazz == null) {
            return false;
        }
        if (clazz.getName().equals(targetClassName)) {
            return true;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> iface = classArray[n2];
            if (iface.getName().equals(targetClassName) || this.isAssignableFrom(iface, targetClassName)) {
                return true;
            }
            ++n2;
        }
        return this.isAssignableFrom(clazz.getSuperclass(), targetClassName);
    }

    private static class ExecuteMethodInfo {
        Method method;
        Class<?> taskClass;
        boolean needsNamespaceParam;

        private ExecuteMethodInfo() {
        }
    }

    public static class FeatureInfo {
        public String name;
        public String synonym;
    }

    public static class ObjectDetails {
        public String name;
        public String fqn;
        public String synonym;
        public MetadataKind kind;
        public List<FeatureInfo> attributes = new ArrayList<FeatureInfo>();
        public List<TabularSectionInfo> tabularSections = new ArrayList<TabularSectionInfo>();
        public List<FeatureInfo> dimensions = new ArrayList<FeatureInfo>();
        public List<FeatureInfo> resources = new ArrayList<FeatureInfo>();
        public Map<String, String> properties = new HashMap<String, String>();

        public String toMarkdown() {
            StringBuilder sb = new StringBuilder();
            sb.append("## ").append(this.fqn).append("\n\n");
            if (this.synonym != null && !this.synonym.isEmpty()) {
                sb.append("**\u0421\u0438\u043d\u043e\u043d\u0438\u043c:** ").append(this.synonym).append("\n\n");
            }
            if (!this.properties.isEmpty()) {
                sb.append("### \u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430\n\n");
                for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                    sb.append("- **").append(entry.getKey()).append(":** ").append(entry.getValue()).append("\n");
                }
                sb.append("\n");
            }
            if (!this.attributes.isEmpty()) {
                sb.append("### \u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u044b (").append(this.attributes.size()).append(")\n\n");
                for (FeatureInfo attr : this.attributes) {
                    sb.append("- **").append(attr.name).append("**");
                    if (attr.synonym != null) {
                        sb.append(" \u2014 ").append(attr.synonym);
                    }
                    sb.append("\n");
                }
                sb.append("\n");
            }
            if (!this.tabularSections.isEmpty()) {
                sb.append("### \u0422\u0430\u0431\u043b\u0438\u0447\u043d\u044b\u0435 \u0447\u0430\u0441\u0442\u0438 (").append(this.tabularSections.size()).append(")\n\n");
                for (TabularSectionInfo ts : this.tabularSections) {
                    sb.append("#### ").append(ts.name);
                    if (ts.synonym != null) {
                        sb.append(" \u2014 ").append(ts.synonym);
                    }
                    sb.append("\n");
                    for (FeatureInfo attr : ts.attributes) {
                        sb.append("  - ").append(attr.name);
                        if (attr.synonym != null) {
                            sb.append(" \u2014 ").append(attr.synonym);
                        }
                        sb.append("\n");
                    }
                }
                sb.append("\n");
            }
            if (!this.dimensions.isEmpty()) {
                sb.append("### \u0418\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f (").append(this.dimensions.size()).append(")\n\n");
                for (FeatureInfo dim : this.dimensions) {
                    sb.append("- **").append(dim.name).append("**");
                    if (dim.synonym != null) {
                        sb.append(" \u2014 ").append(dim.synonym);
                    }
                    sb.append("\n");
                }
                sb.append("\n");
            }
            if (!this.resources.isEmpty()) {
                sb.append("### \u0420\u0435\u0441\u0443\u0440\u0441\u044b (").append(this.resources.size()).append(")\n\n");
                for (FeatureInfo res : this.resources) {
                    sb.append("- **").append(res.name).append("**");
                    if (res.synonym != null) {
                        sb.append(" \u2014 ").append(res.synonym);
                    }
                    sb.append("\n");
                }
            }
            return sb.toString();
        }
    }

    public static class ReferenceInfo {
        public String sourceFqn;
        public String sourceName;
        public MetadataKind sourceKind;
        public String featureName;
    }

    public static class TabularSectionInfo {
        public String name;
        public String synonym;
        public List<FeatureInfo> attributes = new ArrayList<FeatureInfo>();
    }
}

