/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.tools.metadata;

import com.example.vibe.core.logging.VibeLogger;
import com.example.vibe.core.tools.ITool;
import com.example.vibe.core.tools.ToolResult;
import com.example.vibe.core.tools.metadata.MetadataKind;
import com.example.vibe.core.tools.metadata.MetadataResolver;
import com.example.vibe.core.tools.metadata.services.MdoTemplates;
import com.example.vibe.core.tools.metadata.services.MdoXmlService;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class AddResourceTool
implements ITool {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(AddResourceTool.class);
    private static final String SCHEMA = "{\n    \"type\": \"object\",\n    \"properties\": {\n        \"target\": {\n            \"type\": \"string\",\n            \"description\": \"FQN \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430 (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440: AccumulationRegister.\u041e\u0441\u0442\u0430\u0442\u043a\u0438\u0422\u043e\u0432\u0430\u0440\u043e\u0432, InformationRegister.\u041a\u0443\u0440\u0441\u044b)\"\n        },\n        \"name\": {\n            \"type\": \"string\",\n            \"description\": \"\u0422\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u0438\u043c\u044f \u0440\u0435\u0441\u0443\u0440\u0441\u0430 (CamelCase)\"\n        },\n        \"synonym\": {\n            \"type\": \"string\",\n            \"description\": \"\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u043c\u043e\u0435 \u0438\u043c\u044f (\u0441\u0438\u043d\u043e\u043d\u0438\u043c)\"\n        },\n        \"type\": {\n            \"type\": \"string\",\n            \"description\": \"\u0422\u0438\u043f \u0434\u0430\u043d\u043d\u044b\u0445: String, Number, Boolean, Date, CatalogRef.X, DocumentRef.X, EnumRef.X\"\n        },\n        \"length\": {\n            \"type\": \"integer\",\n            \"description\": \"\u0414\u043b\u0438\u043d\u0430 \u0441\u0442\u0440\u043e\u043a\u0438 (\u0434\u043b\u044f \u0442\u0438\u043f\u0430 String, \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e 100)\"\n        },\n        \"precision\": {\n            \"type\": \"integer\",\n            \"description\": \"\u0422\u043e\u0447\u043d\u043e\u0441\u0442\u044c \u0447\u0438\u0441\u043b\u0430 (\u0434\u043b\u044f \u0442\u0438\u043f\u0430 Number, \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e 15)\"\n        },\n        \"scale\": {\n            \"type\": \"integer\",\n            \"description\": \"\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0437\u043d\u0430\u043a\u043e\u0432 \u043f\u043e\u0441\u043b\u0435 \u0437\u0430\u043f\u044f\u0442\u043e\u0439 (\u0434\u043b\u044f \u0442\u0438\u043f\u0430 Number, \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e 2)\"\n        }\n    },\n    \"required\": [\"target\", \"name\", \"synonym\", \"type\"]\n}\n";
    private final MdoXmlService xmlService = MdoXmlService.getInstance();
    private final MdoTemplates templates = MdoTemplates.getInstance();

    @Override
    public String getName() {
        return "add_resource";
    }

    @Override
    public String getDescription() {
        return "\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0440\u0435\u0441\u0443\u0440\u0441\u0430 \u043a \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0443 1\u0421 (\u043d\u0430\u043a\u043e\u043f\u043b\u0435\u043d\u0438\u044f, \u0441\u0432\u0435\u0434\u0435\u043d\u0438\u0439, \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0438\u0438, \u0440\u0430\u0441\u0447\u0435\u0442\u0430)";
    }

    @Override
    public String getParameterSchema() {
        return SCHEMA;
    }

    @Override
    public CompletableFuture<ToolResult> execute(Map<String, Object> parameters) {
        return CompletableFuture.supplyAsync(() -> {
            LOG.info("[TOOL] add_resource called with parameters: %s", parameters);
            try {
                String target = (String)parameters.get("target");
                String name = (String)parameters.get("name");
                String synonym = (String)parameters.get("synonym");
                String type = (String)parameters.get("type");
                int length = this.getIntParam(parameters, "length", 100);
                int precision = this.getIntParam(parameters, "precision", 15);
                int scale = this.getIntParam(parameters, "scale", 2);
                if (target == null || !target.contains(".")) {
                    return ToolResult.failure("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 target. \u0424\u043e\u0440\u043c\u0430\u0442: \u0422\u0438\u043f.\u0418\u043c\u044f (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440: AccumulationRegister.\u041e\u0441\u0442\u0430\u0442\u043a\u0438\u0422\u043e\u0432\u0430\u0440\u043e\u0432)");
                }
                if (name == null || name.isEmpty()) {
                    return ToolResult.failure("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u0438\u043c\u044f \u0440\u0435\u0441\u0443\u0440\u0441\u0430 (name)");
                }
                if (synonym == null || synonym.isEmpty()) {
                    synonym = name;
                }
                if (type == null || type.isEmpty()) {
                    return ToolResult.failure("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0442\u0438\u043f \u0440\u0435\u0441\u0443\u0440\u0441\u0430 (type)");
                }
                MetadataKind kind = MetadataKind.fromFqn(target);
                String objectName = MetadataKind.extractNameFromFqn(target);
                if (kind == null || objectName == null) {
                    return ToolResult.failure("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0440\u0430\u0441\u043f\u043e\u0437\u043d\u0430\u0442\u044c \u043e\u0431\u044a\u0435\u043a\u0442: " + target);
                }
                if (!this.supportsResources(kind)) {
                    return ToolResult.failure("\u0422\u0438\u043f " + kind.getRussianSingular() + " \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0440\u0435\u0441\u0443\u0440\u0441\u044b. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435: InformationRegister, AccumulationRegister, AccountingRegister, CalculationRegister");
                }
                MetadataResolver resolver = MetadataResolver.getInstance();
                IProject project = resolver.find1CProject();
                if (project == null) {
                    return ToolResult.failure("\u041f\u0440\u043e\u0435\u043a\u0442 1\u0421 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0440\u0430\u0431\u043e\u0447\u0435\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438");
                }
                String mdoPath = "src/" + kind.getFolderName() + "/" + objectName + "/" + objectName + ".mdo";
                IFile mdoFile = project.getFile(mdoPath);
                if (!mdoFile.exists()) {
                    return ToolResult.failure("\u0420\u0435\u0433\u0438\u0441\u0442\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d: " + mdoPath);
                }
                this.addResource(mdoFile, name, synonym, type, length, precision, scale);
                LOG.info("[TOOL] add_resource: \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u0440\u0435\u0441\u0443\u0440\u0441 %s \u0432 %s", name, target);
                StringBuilder result = new StringBuilder();
                result.append("\u2705 \u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u0440\u0435\u0441\u0443\u0440\u0441 **").append(name).append("** \u0432 ").append(target).append("\n\n");
                result.append("- \u0421\u0438\u043d\u043e\u043d\u0438\u043c: ").append(synonym).append("\n");
                result.append("- \u0422\u0438\u043f: ").append(type).append("\n");
                if (type.equalsIgnoreCase("Number") || type.equalsIgnoreCase("\u0427\u0438\u0441\u043b\u043e")) {
                    result.append("- \u0422\u043e\u0447\u043d\u043e\u0441\u0442\u044c: ").append(precision).append(", \u0437\u043d\u0430\u043a\u043e\u0432 \u043f\u043e\u0441\u043b\u0435 \u0437\u0430\u043f\u044f\u0442\u043e\u0439: ").append(scale).append("\n");
                }
                return ToolResult.success(result.toString());
            }
            catch (Exception e) {
                LOG.error("[TOOL] add_resource error: %s", e.getMessage());
                return ToolResult.failure("\u041e\u0448\u0438\u0431\u043a\u0430 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0440\u0435\u0441\u0443\u0440\u0441\u0430: " + e.getMessage());
            }
        });
    }

    private void addResource(IFile mdoFile, String name, String synonym, String type, int length, int precision, int scale) throws CoreException {
        String content = this.xmlService.getMdoContent(mdoFile);
        Pattern checkPattern = Pattern.compile("<resources[^>]*>\\s*<name>" + name + "</name>", 32);
        if (checkPattern.matcher(content).find()) {
            throw new RuntimeException("\u0420\u0435\u0441\u0443\u0440\u0441 " + name + " \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("UUID", this.xmlService.generateUuid());
        params.put("NAME", name);
        params.put("SYNONYM", synonym);
        params.put("TYPE", this.mapType(type));
        params.put("TYPE_QUALIFIERS", this.getTypeQualifiers(type, length, precision, scale));
        String resourceXml = this.templates.applyParameters(this.templates.getResourceTemplate(), params);
        String newContent = this.insertResource(content, resourceXml);
        this.xmlService.writeMdo(mdoFile, newContent);
    }

    private String insertResource(String content, String resourceXml) {
        String[] insertBefore;
        String[] insertAfter;
        Pattern pattern = Pattern.compile("(</resources>)", 32);
        Matcher matcher = pattern.matcher(content);
        int lastEnd = -1;
        while (matcher.find()) {
            lastEnd = matcher.end();
        }
        if (lastEnd > 0) {
            return content.substring(0, lastEnd) + "\n" + resourceXml + content.substring(lastEnd);
        }
        String[] stringArray = insertAfter = new String[]{"</dimensions>"};
        int n = insertAfter.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            Pattern p = Pattern.compile("(" + Pattern.quote(tag) + ")", 32);
            Matcher m = p.matcher(content);
            int pos = -1;
            while (m.find()) {
                pos = m.end();
            }
            if (pos > 0) {
                return content.substring(0, pos) + "\n" + resourceXml + content.substring(pos);
            }
            ++n2;
        }
        String[] stringArray2 = insertBefore = new String[]{"<attributes", "</mdclass:"};
        int n3 = insertBefore.length;
        n = 0;
        while (n < n3) {
            String tag = stringArray2[n];
            int idx = content.indexOf(tag);
            if (idx > 0) {
                int lineStart = content.lastIndexOf(10, idx - 1);
                if (lineStart < 0) {
                    lineStart = 0;
                }
                return content.substring(0, lineStart) + "\n" + resourceXml + content.substring(lineStart);
            }
            ++n;
        }
        throw new RuntimeException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043c\u0435\u0441\u0442\u043e \u0434\u043b\u044f \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u0440\u0435\u0441\u0443\u0440\u0441\u0430");
    }

    private String mapType(String type) {
        if (type.contains("Ref.")) {
            return type;
        }
        return switch (type.toLowerCase()) {
            case "\u0441\u0442\u0440\u043e\u043a\u0430", "string" -> "String";
            case "number", "\u0447\u0438\u0441\u043b\u043e" -> "Number";
            case "boolean", "\u0431\u0443\u043b\u0435\u0432\u043e" -> "Boolean";
            case "date", "\u0434\u0430\u0442\u0430" -> "Date";
            default -> type;
        };
    }

    private String getTypeQualifiers(String type, int length, int precision, int scale) {
        String mappedType = this.mapType(type);
        if (mappedType.equals("String")) {
            return "<stringQualifiers>\n  <length>%d</length>\n</stringQualifiers>".formatted(length);
        }
        if (mappedType.equals("Number")) {
            return "<numberQualifiers>\n  <precision>%d</precision>\n  <scale>%d</scale>\n</numberQualifiers>".formatted(precision, scale);
        }
        if (mappedType.equals("Date")) {
            return "<dateQualifiers>\n  <dateFractions>DateTime</dateFractions>\n</dateQualifiers>";
        }
        return "";
    }

    private boolean supportsResources(MetadataKind kind) {
        return switch (kind) {
            case MetadataKind.INFORMATION_REGISTER, MetadataKind.ACCUMULATION_REGISTER, MetadataKind.ACCOUNTING_REGISTER, MetadataKind.CALCULATION_REGISTER -> true;
            default -> false;
        };
    }

    private int getIntParam(Map<String, Object> params, String key, int defaultValue) {
        Object value = params.get(key);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return defaultValue;
    }

    private boolean getBoolParam(Map<String, Object> params, String key, boolean defaultValue) {
        Object value = params.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return defaultValue;
    }
}

