/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.tools.metadata;

import com.example.vibe.core.logging.VibeLogger;
import com.example.vibe.core.tools.ITool;
import com.example.vibe.core.tools.ToolResult;
import com.example.vibe.core.tools.metadata.MetadataKind;
import com.example.vibe.core.tools.metadata.MetadataResolver;
import com.example.vibe.core.tools.metadata.services.MdoTemplates;
import com.example.vibe.core.tools.metadata.services.MdoXmlService;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class AddFormTool
implements ITool {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(AddFormTool.class);
    private static final String SCHEMA = "{\n    \"type\": \"object\",\n    \"properties\": {\n        \"target\": {\n            \"type\": \"string\",\n            \"description\": \"FQN \u0446\u0435\u043b\u0435\u0432\u043e\u0433\u043e \u043e\u0431\u044a\u0435\u043a\u0442\u0430 (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440: Catalog.\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u044b)\"\n        },\n        \"name\": {\n            \"type\": \"string\",\n            \"description\": \"\u0418\u043c\u044f \u0444\u043e\u0440\u043c\u044b (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440: \u0424\u043e\u0440\u043c\u0430\u042d\u043b\u0435\u043c\u0435\u043d\u0442\u0430, \u0424\u043e\u0440\u043c\u0430\u0421\u043f\u0438\u0441\u043a\u0430)\"\n        },\n        \"form_type\": {\n            \"type\": \"string\",\n            \"enum\": [\"ItemForm\", \"ListForm\", \"ChoiceForm\", \"RecordForm\", \"Custom\"],\n            \"description\": \"\u0422\u0438\u043f \u0444\u043e\u0440\u043c\u044b: ItemForm (\u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430), ListForm (\u0441\u043f\u0438\u0441\u043a\u0430), ChoiceForm (\u0432\u044b\u0431\u043e\u0440\u0430), RecordForm (\u0437\u0430\u043f\u0438\u0441\u0438 \u0434\u043b\u044f \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432), Custom (\u043f\u0440\u043e\u0438\u0437\u0432\u043e\u043b\u044c\u043d\u0430\u044f)\"\n        },\n        \"set_as_main\": {\n            \"type\": \"boolean\",\n            \"description\": \"\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043a\u0430\u043a \u043e\u0441\u043d\u043e\u0432\u043d\u0443\u044e \u0444\u043e\u0440\u043c\u0443 \u044d\u0442\u043e\u0433\u043e \u0442\u0438\u043f\u0430 (\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e false)\"\n        }\n    },\n    \"required\": [\"target\", \"name\", \"form_type\"]\n}\n";
    private final MdoXmlService xmlService = MdoXmlService.getInstance();
    private final MdoTemplates templates = MdoTemplates.getInstance();

    @Override
    public String getName() {
        return "add_form";
    }

    @Override
    public String getDescription() {
        return "\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0444\u043e\u0440\u043c\u044b \u0434\u043b\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445 1\u0421 (\u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430, \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430, \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0438 \u0434\u0440.)";
    }

    @Override
    public String getParameterSchema() {
        return SCHEMA;
    }

    @Override
    public CompletableFuture<ToolResult> execute(Map<String, Object> parameters) {
        return CompletableFuture.supplyAsync(() -> {
            LOG.info("[TOOL] add_form called with parameters: %s", parameters);
            try {
                String target = (String)parameters.get("target");
                String formName = (String)parameters.get("name");
                String formType = (String)parameters.get("form_type");
                boolean setAsMain = Boolean.TRUE.equals(parameters.get("set_as_main"));
                if (target == null || !target.contains(".")) {
                    return ToolResult.failure("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 target. \u0424\u043e\u0440\u043c\u0430\u0442: \u0422\u0438\u043f.\u0418\u043c\u044f (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440: Catalog.\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u044b)");
                }
                if (formName == null || formName.isEmpty()) {
                    return ToolResult.failure("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u0438\u043c\u044f \u0444\u043e\u0440\u043c\u044b (name)");
                }
                if (formType == null || formType.isEmpty()) {
                    formType = "Custom";
                }
                MetadataKind kind = MetadataKind.fromFqn(target);
                String objectName = MetadataKind.extractNameFromFqn(target);
                if (kind == null || objectName == null) {
                    return ToolResult.failure("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0440\u0430\u0441\u043f\u043e\u0437\u043d\u0430\u0442\u044c \u043e\u0431\u044a\u0435\u043a\u0442: " + target);
                }
                if (!this.supportsForms(kind)) {
                    return ToolResult.failure("\u0422\u0438\u043f " + kind.getRussianSingular() + " \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0444\u043e\u0440\u043c\u044b");
                }
                MetadataResolver resolver = MetadataResolver.getInstance();
                IProject project = resolver.find1CProject();
                if (project == null) {
                    return ToolResult.failure("\u041f\u0440\u043e\u0435\u043a\u0442 1\u0421 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0440\u0430\u0431\u043e\u0447\u0435\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438");
                }
                String mdoPath = "src/" + kind.getFolderName() + "/" + objectName + "/" + objectName + ".mdo";
                IFile mdoFile = project.getFile(mdoPath);
                if (!mdoFile.exists()) {
                    return ToolResult.failure("\u041e\u0431\u044a\u0435\u043a\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d: " + mdoPath);
                }
                String formFolderPath = "src/" + kind.getFolderName() + "/" + objectName + "/Forms/" + formName;
                this.createFormFiles(project, formFolderPath, formType, kind, objectName);
                String synonym = this.formNameToSynonym(formName);
                this.updateObjectMdo(mdoFile, formName, synonym, formType, setAsMain, kind, objectName);
                LOG.info("[TOOL] add_form: \u0441\u043e\u0437\u0434\u0430\u043d\u0430 \u0444\u043e\u0440\u043c\u0430 %s \u0434\u043b\u044f %s", formName, target);
                StringBuilder result = new StringBuilder();
                result.append("\u2705 \u0421\u043e\u0437\u0434\u0430\u043d\u0430 \u0444\u043e\u0440\u043c\u0430 **").append(formName).append("** \u0434\u043b\u044f ").append(target).append("\n\n");
                result.append("- \u041f\u0443\u0442\u044c: `").append(formFolderPath).append("`\n");
                result.append("- \u0422\u0438\u043f: ").append(formType).append("\n");
                result.append("- \u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430 \u0432 .mdo \u043e\u0431\u044a\u0435\u043a\u0442\u0430\n");
                if (setAsMain) {
                    result.append("- \u2713 \u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u043a\u0430\u043a \u043e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430\n");
                }
                return ToolResult.success(result.toString());
            }
            catch (Exception e) {
                LOG.error("[TOOL] add_form error: %s", e.getMessage());
                return ToolResult.failure("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0444\u043e\u0440\u043c\u044b: " + e.getMessage());
            }
        });
    }

    private void createFormFiles(IProject project, String formFolderPath, String formType, MetadataKind kind, String objectName) throws CoreException {
        this.xmlService.createObjectFolder(project, formFolderPath);
        String formContent = this.getFormContentByType(formType, kind, objectName);
        IFile formFile = project.getFile(formFolderPath + "/Form.form");
        this.xmlService.writeMdo(formFile, formContent);
        String moduleContent = this.templates.getFormModuleTemplate();
        IFile moduleFile = project.getFile(formFolderPath + "/Module.bsl");
        this.xmlService.writeMdo(moduleFile, moduleContent);
        LOG.debug("\u0421\u043e\u0437\u0434\u0430\u043d\u044b \u0444\u0430\u0439\u043b\u044b \u0444\u043e\u0440\u043c\u044b: %s (\u0442\u0438\u043f: %s)", formFolderPath, formType);
    }

    private String getFormContentByType(String formType, MetadataKind kind, String objectName) {
        String formExtInfo = this.getFormExtInfo(kind);
        String mainTable = kind.getEnglishName() + "." + objectName;
        return switch (formType) {
            case "ItemForm" -> {
                String objectType = this.getObjectType(kind, objectName);
                yield this.templates.getItemFormFileTemplate(objectType, formExtInfo);
            }
            case "ListForm" -> this.templates.getListFormFileTemplate(mainTable);
            case "ChoiceForm" -> this.templates.getChoiceFormFileTemplate(mainTable);
            case "RecordForm" -> {
                String recordType = this.getRecordType(kind, objectName);
                yield this.templates.getItemFormFileTemplate(recordType, formExtInfo);
            }
            default -> this.templates.getFormFileTemplate();
        };
    }

    private String getFormExtInfo(MetadataKind kind) {
        return switch (kind) {
            case MetadataKind.CATALOG -> "CatalogFormExtInfo";
            case MetadataKind.DOCUMENT -> "DocumentFormExtInfo";
            case MetadataKind.DATA_PROCESSOR -> "DataProcessorFormExtInfo";
            case MetadataKind.REPORT -> "ReportFormExtInfo";
            case MetadataKind.BUSINESS_PROCESS -> "BusinessProcessFormExtInfo";
            case MetadataKind.TASK -> "TaskFormExtInfo";
            case MetadataKind.EXCHANGE_PLAN -> "ExchangePlanFormExtInfo";
            case MetadataKind.CHART_OF_CHARACTERISTIC_TYPES -> "ChartOfCharacteristicTypesFormExtInfo";
            case MetadataKind.CHART_OF_ACCOUNTS -> "ChartOfAccountsFormExtInfo";
            case MetadataKind.CHART_OF_CALCULATION_TYPES -> "ChartOfCalculationTypesFormExtInfo";
            case MetadataKind.INFORMATION_REGISTER -> "InformationRegisterFormExtInfo";
            case MetadataKind.ACCUMULATION_REGISTER -> "AccumulationRegisterFormExtInfo";
            case MetadataKind.ACCOUNTING_REGISTER -> "AccountingRegisterFormExtInfo";
            case MetadataKind.CALCULATION_REGISTER -> "CalculationRegisterFormExtInfo";
            default -> "ObjectFormExtInfo";
        };
    }

    private String getObjectType(MetadataKind kind, String objectName) {
        String prefix = switch (kind) {
            case MetadataKind.CATALOG -> "CatalogObject";
            case MetadataKind.DOCUMENT -> "DocumentObject";
            case MetadataKind.DATA_PROCESSOR -> "DataProcessorObject";
            case MetadataKind.REPORT -> "ReportObject";
            case MetadataKind.BUSINESS_PROCESS -> "BusinessProcessObject";
            case MetadataKind.TASK -> "TaskObject";
            case MetadataKind.EXCHANGE_PLAN -> "ExchangePlanObject";
            case MetadataKind.CHART_OF_CHARACTERISTIC_TYPES -> "ChartOfCharacteristicTypesObject";
            case MetadataKind.CHART_OF_ACCOUNTS -> "ChartOfAccountsObject";
            case MetadataKind.CHART_OF_CALCULATION_TYPES -> "ChartOfCalculationTypesObject";
            default -> kind.getEnglishName() + "Object";
        };
        return prefix + "." + objectName;
    }

    private String getRecordType(MetadataKind kind, String objectName) {
        String prefix = switch (kind) {
            case MetadataKind.INFORMATION_REGISTER -> "InformationRegisterRecord";
            case MetadataKind.ACCUMULATION_REGISTER -> "AccumulationRegisterRecord";
            case MetadataKind.ACCOUNTING_REGISTER -> "AccountingRegisterRecord";
            case MetadataKind.CALCULATION_REGISTER -> "CalculationRegisterRecord";
            default -> kind.getEnglishName() + "Record";
        };
        return prefix + "." + objectName;
    }

    private void updateObjectMdo(IFile mdoFile, String formName, String synonym, String formType, boolean setAsMain, MetadataKind kind, String objectName) throws CoreException {
        String defaultFormTag;
        String content = this.xmlService.getMdoContent(mdoFile);
        if (content.contains("<name>" + formName + "</name>")) {
            throw new RuntimeException("\u0424\u043e\u0440\u043c\u0430 " + formName + " \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("UUID", this.xmlService.generateUuid());
        params.put("NAME", formName);
        params.put("SYNONYM", synonym);
        String formRefXml = this.templates.applyParameters(this.templates.getFormReferenceTemplate(), params);
        content = this.insertFormReference(content, formRefXml);
        if (setAsMain && (defaultFormTag = this.getDefaultFormTag(kind, formType)) != null) {
            String fqn = kind.getEnglishName() + "." + objectName + ".Form." + formName;
            content = this.setDefaultForm(content, defaultFormTag, fqn);
        }
        this.xmlService.writeMdo(mdoFile, content);
        LOG.debug("\u041e\u0431\u043d\u043e\u0432\u043b\u0451\u043d MDO \u043e\u0431\u044a\u0435\u043a\u0442\u0430: \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430 \u0444\u043e\u0440\u043c\u0430 %s", formName);
    }

    private String insertFormReference(String content, String formRefXml) {
        Pattern pattern = Pattern.compile("(</forms>)", 32);
        Matcher matcher = pattern.matcher(content);
        int lastEnd = -1;
        while (matcher.find()) {
            lastEnd = matcher.end();
        }
        if (lastEnd > 0) {
            return content.substring(0, lastEnd) + "\n" + formRefXml + content.substring(lastEnd);
        }
        int closeTag = content.lastIndexOf("</mdclass:");
        if (closeTag > 0) {
            int lineStart = content.lastIndexOf(10, closeTag - 1);
            if (lineStart < 0) {
                lineStart = 0;
            }
            return content.substring(0, lineStart) + "\n" + formRefXml + content.substring(lineStart);
        }
        throw new RuntimeException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043c\u0435\u0441\u0442\u043e \u0434\u043b\u044f \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u0444\u043e\u0440\u043c\u044b");
    }

    private String setDefaultForm(String content, String tagName, String formFqn) {
        String element = "<" + tagName + ">" + formFqn + "</" + tagName + ">";
        Pattern pattern = Pattern.compile("<" + tagName + ">.*?</" + tagName + ">", 32);
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return content.substring(0, matcher.start()) + element + content.substring(matcher.end());
        }
        int insertPos = content.indexOf("<forms");
        if (insertPos < 0) {
            insertPos = content.lastIndexOf("</mdclass:");
        }
        if (insertPos > 0) {
            int lineStart = content.lastIndexOf(10, insertPos - 1);
            if (lineStart < 0) {
                lineStart = 0;
            }
            return content.substring(0, lineStart) + "\n  " + element + content.substring(lineStart);
        }
        return content;
    }

    private String getDefaultFormTag(MetadataKind kind, String formType) {
        return switch (formType) {
            case "ItemForm" -> {
                switch (kind) {
                    case CATALOG: 
                    case CHART_OF_CHARACTERISTIC_TYPES: 
                    case CHART_OF_ACCOUNTS: 
                    case CHART_OF_CALCULATION_TYPES: 
                    case EXCHANGE_PLAN: {
                        yield "defaultObjectForm";
                    }
                    case DOCUMENT: 
                    case BUSINESS_PROCESS: 
                    case TASK: {
                        yield "defaultObjectForm";
                    }
                }
                yield null;
            }
            case "ListForm" -> "defaultListForm";
            case "ChoiceForm" -> "defaultChoiceForm";
            case "RecordForm" -> "defaultRecordForm";
            default -> null;
        };
    }

    private String formNameToSynonym(String formName) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < formName.length()) {
            char c = formName.charAt(i);
            if (i > 0 && Character.isUpperCase(c)) {
                result.append(' ').append(Character.toLowerCase(c));
            } else {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    private boolean supportsForms(MetadataKind kind) {
        return switch (kind) {
            case MetadataKind.CATALOG, MetadataKind.DOCUMENT, MetadataKind.CHART_OF_CHARACTERISTIC_TYPES, MetadataKind.CHART_OF_ACCOUNTS, MetadataKind.CHART_OF_CALCULATION_TYPES, MetadataKind.INFORMATION_REGISTER, MetadataKind.ACCUMULATION_REGISTER, MetadataKind.ACCOUNTING_REGISTER, MetadataKind.CALCULATION_REGISTER, MetadataKind.DATA_PROCESSOR, MetadataKind.REPORT, MetadataKind.BUSINESS_PROCESS, MetadataKind.TASK, MetadataKind.EXCHANGE_PLAN -> true;
            default -> false;
        };
    }
}

