/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.tools.metadata;

import com.example.vibe.core.logging.VibeLogger;
import com.example.vibe.core.tools.ITool;
import com.example.vibe.core.tools.ToolResult;
import com.example.vibe.core.tools.metadata.MetadataKind;
import com.example.vibe.core.tools.metadata.MetadataResolver;
import com.example.vibe.core.tools.metadata.services.MdoTemplates;
import com.example.vibe.core.tools.metadata.services.MdoXmlService;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class AddEnumValueTool
implements ITool {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(AddEnumValueTool.class);
    private static final String SCHEMA = "{\n    \"type\": \"object\",\n    \"properties\": {\n        \"target\": {\n            \"type\": \"string\",\n            \"description\": \"FQN \u043f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440: Enum.\u0421\u0442\u0430\u0442\u0443\u0441\u044b\u0417\u0430\u043a\u0430\u0437\u0430)\"\n        },\n        \"name\": {\n            \"type\": \"string\",\n            \"description\": \"\u0422\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u0438\u043c\u044f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f (CamelCase \u0431\u0435\u0437 \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432)\"\n        },\n        \"synonym\": {\n            \"type\": \"string\",\n            \"description\": \"\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u043c\u043e\u0435 \u0438\u043c\u044f (\u0441\u0438\u043d\u043e\u043d\u0438\u043c)\"\n        },\n        \"insert_after\": {\n            \"type\": \"string\",\n            \"description\": \"\u0418\u043c\u044f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f, \u043f\u043e\u0441\u043b\u0435 \u043a\u043e\u0442\u043e\u0440\u043e\u0433\u043e \u0432\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u043d\u043e\u0432\u043e\u0435 (\u043d\u0435\u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e, \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e \u0432 \u043a\u043e\u043d\u0435\u0446)\"\n        }\n    },\n    \"required\": [\"target\", \"name\", \"synonym\"]\n}\n";
    private final MdoXmlService xmlService = MdoXmlService.getInstance();
    private final MdoTemplates templates = MdoTemplates.getInstance();

    @Override
    public String getName() {
        return "add_enum_value";
    }

    @Override
    public String getDescription() {
        return "\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0432 \u043f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435 1\u0421";
    }

    @Override
    public String getParameterSchema() {
        return SCHEMA;
    }

    @Override
    public CompletableFuture<ToolResult> execute(Map<String, Object> parameters) {
        return CompletableFuture.supplyAsync(() -> {
            LOG.info("[TOOL] add_enum_value called with parameters: %s", parameters);
            try {
                String target = (String)parameters.get("target");
                String name = (String)parameters.get("name");
                String synonym = (String)parameters.get("synonym");
                String insertAfter = (String)parameters.get("insert_after");
                if (target == null || !target.contains(".")) {
                    return ToolResult.failure("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 target. \u0424\u043e\u0440\u043c\u0430\u0442: Enum.\u0418\u043c\u044f\u041f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f");
                }
                if (name == null || name.isEmpty()) {
                    return ToolResult.failure("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u0438\u043c\u044f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f (name)");
                }
                if (synonym == null || synonym.isEmpty()) {
                    synonym = name;
                }
                MetadataKind kind = MetadataKind.fromFqn(target);
                String enumName = MetadataKind.extractNameFromFqn(target);
                if (kind != MetadataKind.ENUM) {
                    return ToolResult.failure("\u041e\u0431\u044a\u0435\u043a\u0442 " + target + " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435\u043c");
                }
                MetadataResolver resolver = MetadataResolver.getInstance();
                IProject project = resolver.find1CProject();
                if (project == null) {
                    return ToolResult.failure("\u041f\u0440\u043e\u0435\u043a\u0442 1\u0421 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0440\u0430\u0431\u043e\u0447\u0435\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438");
                }
                String mdoPath = "src/Enums/" + enumName + "/" + enumName + ".mdo";
                IFile mdoFile = project.getFile(mdoPath);
                if (!mdoFile.exists()) {
                    return ToolResult.failure("\u041f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e: " + mdoPath);
                }
                this.addEnumValue(mdoFile, name, synonym, insertAfter);
                LOG.info("[TOOL] add_enum_value: \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 %s \u0432 %s", name, target);
                StringBuilder result = new StringBuilder();
                result.append("\u2705 \u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 **").append(name).append("** \u0432 ").append(target).append("\n\n");
                result.append("- \u0421\u0438\u043d\u043e\u043d\u0438\u043c: ").append(synonym).append("\n");
                if (insertAfter != null && !insertAfter.isEmpty()) {
                    result.append("- \u0412\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u043e\u0441\u043b\u0435: ").append(insertAfter).append("\n");
                }
                return ToolResult.success(result.toString());
            }
            catch (Exception e) {
                LOG.error("[TOOL] add_enum_value error: %s", e.getMessage());
                return ToolResult.failure("\u041e\u0448\u0438\u0431\u043a\u0430 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f: " + e.getMessage());
            }
        });
    }

    private void addEnumValue(IFile mdoFile, String name, String synonym, String insertAfter) throws CoreException {
        String content = this.xmlService.getMdoContent(mdoFile);
        if (content.contains("<name>" + name + "</name>")) {
            throw new RuntimeException("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 " + name + " \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("UUID", this.xmlService.generateUuid());
        params.put("NAME", name);
        params.put("SYNONYM", synonym);
        String enumValueXml = this.templates.applyParameters(this.templates.getEnumValueTemplate(), params);
        String newContent = insertAfter != null && !insertAfter.isEmpty() ? this.insertAfterValue(content, enumValueXml, insertAfter) : this.insertAtEnd(content, enumValueXml);
        this.xmlService.writeMdo(mdoFile, newContent);
    }

    private String insertAfterValue(String content, String enumValueXml, String afterName) {
        String searchPattern = "<name>" + afterName + "</name>.*?</enumValues>";
        Pattern pattern = Pattern.compile(searchPattern, 32);
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            int insertPos = matcher.end();
            return content.substring(0, insertPos) + "\n" + enumValueXml + content.substring(insertPos);
        }
        LOG.warn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e, \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0435\u043c \u0432 \u043a\u043e\u043d\u0435\u0446", afterName);
        return this.insertAtEnd(content, enumValueXml);
    }

    private String insertAtEnd(String content, String enumValueXml) {
        Pattern pattern = Pattern.compile("(</enumValues>)", 32);
        Matcher matcher = pattern.matcher(content);
        int lastEnd = -1;
        while (matcher.find()) {
            lastEnd = matcher.end();
        }
        if (lastEnd > 0) {
            return content.substring(0, lastEnd) + "\n" + enumValueXml + content.substring(lastEnd);
        }
        int closeTag = content.lastIndexOf("</mdclass:Enum>");
        if (closeTag > 0) {
            return content.substring(0, closeTag) + enumValueXml + "\n" + content.substring(closeTag);
        }
        throw new RuntimeException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043c\u0435\u0441\u0442\u043e \u0434\u043b\u044f \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f");
    }
}

