/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.tools;

import com.example.vibe.core.tools.ITool;
import com.example.vibe.core.tools.ToolResult;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class WriteTool
implements ITool {
    private static final String PLUGIN_ID = "com.example.vibe.core";
    private static final ILog LOG = Platform.getLog(WriteTool.class);
    private static final String SCHEMA = "{\n    \"type\": \"object\",\n    \"properties\": {\n        \"path\": {\n            \"type\": \"string\",\n            \"description\": \"Path for the new file (workspace-relative)\"\n        },\n        \"content\": {\n            \"type\": \"string\",\n            \"description\": \"Content to write to the file\"\n        },\n        \"overwrite\": {\n            \"type\": \"boolean\",\n            \"description\": \"Overwrite if file exists (default: false)\"\n        }\n    },\n    \"required\": [\"path\", \"content\"]\n}\n";

    @Override
    public String getName() {
        return "write_file";
    }

    @Override
    public String getDescription() {
        return "\u0421\u043e\u0437\u0434\u0430\u0435\u0442 \u043d\u043e\u0432\u044b\u0439 \u0444\u0430\u0439\u043b \u0441 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u043c \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u044b\u043c. \u041f\u0443\u0442\u044c \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043e\u0442\u043d\u043e\u0441\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c \u043a workspace (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, 'project/src/Module.bsl'). \u26a0\ufe0f \u0417\u0410\u041f\u0420\u0415\u0429\u0415\u041d\u041e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0434\u043b\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445 1\u0421 (.mdo \u0444\u0430\u0439\u043b\u043e\u0432)! \u0414\u043b\u044f \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u043e\u0432, \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432, \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0438 \u0434\u0440. \u041e\u0411\u042f\u0417\u0410\u0422\u0415\u041b\u042c\u041d\u041e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442 create_metadata, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u043e\u0431\u043d\u043e\u0432\u0438\u0442 Configuration.mdo.";
    }

    @Override
    public String getParameterSchema() {
        return SCHEMA;
    }

    @Override
    public boolean requiresConfirmation() {
        return false;
    }

    @Override
    public boolean isDestructive() {
        return false;
    }

    @Override
    public CompletableFuture<ToolResult> execute(Map<String, Object> parameters) {
        return CompletableFuture.supplyAsync(() -> {
            String pathStr = (String)parameters.get("path");
            if (pathStr == null || pathStr.isEmpty()) {
                return ToolResult.failure("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 path \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u0435\u043d");
            }
            String content = (String)parameters.get("content");
            if (content == null) {
                content = "";
            }
            boolean overwrite = Boolean.TRUE.equals(parameters.get("overwrite"));
            try {
                return this.writeFile(pathStr, content, overwrite);
            }
            catch (CoreException e) {
                this.logError("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430", e);
                return ToolResult.failure("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430: " + e.getMessage());
            }
        });
    }

    private ToolResult writeFile(String pathStr, String content, boolean overwrite) throws CoreException {
        String normalizedPath = this.normalizePath(pathStr);
        if (normalizedPath != null && normalizedPath.endsWith(".mdo") && !normalizedPath.contains("Configuration.mdo")) {
            this.logWarning("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
            this.logWarning("[WRITE_FILE] \u2717 \u0417\u0410\u0411\u041b\u041e\u041a\u0418\u0420\u041e\u0412\u0410\u041d\u041e: \u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u0442\u044c .mdo \u0444\u0430\u0439\u043b \u043d\u0430\u043f\u0440\u044f\u043c\u0443\u044e!");
            this.logWarning("[WRITE_FILE] \u041f\u0443\u0442\u044c: " + normalizedPath);
            this.logWarning("[WRITE_FILE] \u0420\u0430\u0437\u043c\u0435\u0440 \u043a\u043e\u043d\u0442\u0435\u043d\u0442\u0430: " + (content != null ? content.length() : 0) + " \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432");
            this.logWarning("[WRITE_FILE] \u0420\u0415\u0428\u0415\u041d\u0418\u0415: \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 create_metadata \u0434\u043b\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445");
            this.logWarning("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
            return ToolResult.failure("\u274c \u041e\u0428\u0418\u0411\u041a\u0410: \u041d\u0435\u043b\u044c\u0437\u044f \u0441\u043e\u0437\u0434\u0430\u0432\u0430\u0442\u044c .mdo \u0444\u0430\u0439\u043b\u044b \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0430\u043f\u0440\u044f\u043c\u0443\u044e \u0447\u0435\u0440\u0435\u0437 write_file!\n\n\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442 **create_metadata** \u0434\u043b\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445.\n\u042d\u0442\u043e \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e, \u0447\u0442\u043e\u0431\u044b \u043e\u0431\u044a\u0435\u043a\u0442 \u0431\u044b\u043b \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u0432 Configuration.mdo.\n\n\u041f\u0440\u0438\u043c\u0435\u0440: create_metadata(kind=\"Catalog\", name=\"\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u044b\", synonym=\"\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u044b\")");
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = this.findOrCreateFile(root, normalizedPath);
        if (file == null) {
            return ToolResult.failure("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0444\u0430\u0439\u043b: " + pathStr);
        }
        if (file.exists() && !overwrite) {
            return ToolResult.failure("\u0424\u0430\u0439\u043b \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442: " + String.valueOf(file.getFullPath()) + ". \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 overwrite=true \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0438\u0441\u0438 \u0438\u043b\u0438 edit_file \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f.");
        }
        this.ensureParentExists(file);
        byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream source = new ByteArrayInputStream(bytes);
        if (file.exists()) {
            file.setContents((InputStream)source, 1, (IProgressMonitor)new NullProgressMonitor());
        } else {
            file.create((InputStream)source, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        StringBuilder result = new StringBuilder();
        result.append("**\u0424\u0430\u0439\u043b \u0441\u043e\u0437\u0434\u0430\u043d:** `").append(file.getFullPath()).append("`\n");
        result.append("**\u0420\u0430\u0437\u043c\u0435\u0440:** ").append(bytes.length).append(" \u0431\u0430\u0439\u0442\n");
        result.append("**\u0421\u0442\u0440\u043e\u043a:** ").append(this.countLines(content)).append("\n");
        if (file.exists()) {
            result.append("**\u0421\u0442\u0430\u0442\u0443\u0441:** ").append(overwrite ? "\u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0438\u0441\u0430\u043d" : "\u0441\u043e\u0437\u0434\u0430\u043d");
        }
        this.logInfo("\u0424\u0430\u0439\u043b \u0441\u043e\u0437\u0434\u0430\u043d: " + String.valueOf(file.getFullPath()));
        return ToolResult.success(result.toString(), ToolResult.ToolResultType.TEXT);
    }

    private String normalizePath(String path) {
        if (path == null) {
            return null;
        }
        String normalized = path;
        if (normalized.startsWith("/") && !normalized.startsWith("//")) {
            normalized = normalized.substring(1);
        }
        normalized = normalized.replace('\\', '/');
        return normalized;
    }

    private IFile findOrCreateFile(IWorkspaceRoot root, String path) {
        try {
            IPath ipath = Path.fromPortableString((String)path);
            return root.getFile(ipath);
        }
        catch (Exception e) {
            this.logError("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430: " + path, e);
            return null;
        }
    }

    private void ensureParentExists(IFile file) throws CoreException {
        IProject project;
        IContainer parent = file.getParent();
        if (parent instanceof IFolder) {
            this.ensureFolderExists((IFolder)parent);
        } else if (parent instanceof IProject && !(project = (IProject)parent).exists()) {
            project.create((IProgressMonitor)new NullProgressMonitor());
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
    }

    private void ensureFolderExists(IFolder folder) throws CoreException {
        IProject project;
        if (folder.exists()) {
            return;
        }
        IContainer parent = folder.getParent();
        if (parent instanceof IFolder) {
            this.ensureFolderExists((IFolder)parent);
        } else if (parent instanceof IProject && !(project = (IProject)parent).exists()) {
            project.create((IProgressMonitor)new NullProgressMonitor());
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        folder.create(1, true, (IProgressMonitor)new NullProgressMonitor());
    }

    private int countLines(String content) {
        if (content == null || content.isEmpty()) {
            return 0;
        }
        return content.split("\r\n|\r|\n", -1).length;
    }

    private void logInfo(String message) {
        LOG.log((IStatus)new Status(1, PLUGIN_ID, message));
    }

    private void logWarning(String message) {
        LOG.log((IStatus)new Status(2, PLUGIN_ID, message));
    }

    private void logError(String message, Throwable error) {
        LOG.log((IStatus)new Status(4, PLUGIN_ID, message, error));
    }
}

