/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.tools;

public class ToolResult {
    private final boolean success;
    private final String content;
    private final String errorMessage;
    private final ToolResultType type;

    private ToolResult(boolean success, String content, String errorMessage, ToolResultType type) {
        this.success = success;
        this.content = content;
        this.errorMessage = errorMessage;
        this.type = type;
    }

    public static ToolResult success(String content) {
        return new ToolResult(true, content, null, ToolResultType.TEXT);
    }

    public static ToolResult success(String content, ToolResultType type) {
        return new ToolResult(true, content, null, type);
    }

    public static ToolResult failure(String errorMessage) {
        return new ToolResult(false, null, errorMessage, ToolResultType.ERROR);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getContent() {
        return this.content;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public ToolResultType getType() {
        return this.type;
    }

    public String getContentForLlm() {
        if (this.success) {
            return this.content;
        }
        return "Error: " + this.errorMessage;
    }

    public static enum ToolResultType {
        TEXT,
        CODE,
        SEARCH_RESULTS,
        FILE_LIST,
        CONFIRMATION,
        ERROR;

    }
}

