/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.tools;

import com.example.vibe.core.logging.VibeLogger;
import com.example.vibe.core.tools.ToolResult;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ToolLogger {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(ToolLogger.class);
    private static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static ToolLogger instance;
    private final File logFile;
    private final AtomicInteger callCounter = new AtomicInteger(0);
    private final AtomicLong totalExecutionTime = new AtomicLong(0L);
    private final AtomicInteger successCount = new AtomicInteger(0);
    private final AtomicInteger failureCount = new AtomicInteger(0);
    private boolean enabled = true;
    private boolean verboseMode = true;
    private String currentSessionId;
    private int currentAgentStep;

    private ToolLogger() {
        String userHome = System.getProperty("user.home");
        File logDir = new File(userHome, ".vibe");
        if (!logDir.exists()) {
            logDir.mkdirs();
        }
        this.logFile = new File(logDir, "tool_calls.log");
        LOG.info("ToolLogger initialized, log file: %s", this.logFile.getAbsolutePath());
    }

    public static synchronized ToolLogger getInstance() {
        if (instance == null) {
            instance = new ToolLogger();
        }
        return instance;
    }

    public void setAgentContext(String sessionId, int step) {
        this.currentSessionId = sessionId;
        this.currentAgentStep = step;
    }

    public int logToolCallStart(String toolName, Map<String, Object> arguments) {
        if (!this.enabled) {
            return -1;
        }
        int callId = this.callCounter.incrementAndGet();
        LocalDateTime now = LocalDateTime.now();
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n");
        sb.append(String.format("\u2551 TOOL CALL #%d - %s\n", callId, toolName));
        sb.append(String.format("\u2551 Time: %s\n", now.format(TIME_FORMAT)));
        if (this.currentSessionId != null) {
            sb.append(String.format("\u2551 Session: %s | Step: %d\n", this.currentSessionId, this.currentAgentStep));
        }
        sb.append("\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n");
        sb.append("\u2551 ARGUMENTS:\n");
        if (arguments != null && !arguments.isEmpty()) {
            if (this.verboseMode) {
                for (Map.Entry<String, Object> entry : arguments.entrySet()) {
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    String valueStr = this.formatArgumentValue(value);
                    sb.append(String.format("\u2551   %s: %s\n", key, valueStr));
                }
            } else {
                sb.append(String.format("\u2551   %s\n", this.summarizeArguments(arguments)));
            }
        } else {
            sb.append("\u2551   (no arguments)\n");
        }
        sb.append("\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n");
        sb.append("\u2551 EXECUTING...\n");
        String logEntry = sb.toString();
        this.writeToLog(logEntry);
        LOG.debug("[TOOL #%d] START %s with %d args", callId, toolName, arguments != null ? arguments.size() : 0);
        return callId;
    }

    public void logToolCallResult(int callId, String toolName, ToolResult result, long executionTimeMs) {
        if (!this.enabled) {
            return;
        }
        this.totalExecutionTime.addAndGet(executionTimeMs);
        StringBuilder sb = new StringBuilder();
        if (result.isSuccess()) {
            this.successCount.incrementAndGet();
            sb.append("\u2551 RESULT: SUCCESS\n");
            sb.append(String.format("\u2551 Execution time: %d ms\n", executionTimeMs));
            String content = result.getContent();
            if (content != null) {
                sb.append(String.format("\u2551 Content length: %d chars\n", content.length()));
                if (this.verboseMode && content.length() <= 2000) {
                    sb.append("\u2551 Content:\n");
                    sb.append("\u2551 \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n");
                    String[] stringArray = content.split("\n");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        sb.append("\u2551   ").append(this.truncate(line, 100)).append("\n");
                        ++n2;
                    }
                } else if (content.length() > 2000) {
                    sb.append("\u2551 Content (truncated):\n");
                    sb.append("\u2551 \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n");
                    sb.append("\u2551   ").append(this.truncate(content, 500)).append("...\n");
                }
            }
        } else {
            this.failureCount.incrementAndGet();
            sb.append("\u2551 RESULT: FAILURE\n");
            sb.append(String.format("\u2551 Execution time: %d ms\n", executionTimeMs));
            sb.append(String.format("\u2551 Error: %s\n", result.getErrorMessage()));
        }
        sb.append("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n");
        String logEntry = sb.toString();
        this.writeToLog(logEntry);
        if (result.isSuccess()) {
            LOG.debug("[TOOL #%d] END %s: SUCCESS in %d ms, %d chars", callId, toolName, executionTimeMs, result.getContent() != null ? result.getContent().length() : 0);
        } else {
            LOG.warn("[TOOL #%d] END %s: FAILED in %d ms: %s", callId, toolName, executionTimeMs, result.getErrorMessage());
        }
    }

    public void logToolCallError(int callId, String toolName, Throwable error, long executionTimeMs) {
        if (!this.enabled) {
            return;
        }
        this.failureCount.incrementAndGet();
        this.totalExecutionTime.addAndGet(executionTimeMs);
        StringBuilder sb = new StringBuilder();
        sb.append("\u2551 RESULT: EXCEPTION\n");
        sb.append(String.format("\u2551 Execution time: %d ms\n", executionTimeMs));
        sb.append(String.format("\u2551 Exception: %s\n", error.getClass().getSimpleName()));
        sb.append(String.format("\u2551 Message: %s\n", error.getMessage()));
        if (this.verboseMode) {
            sb.append("\u2551 Stack trace:\n");
            StackTraceElement[] stackTraceElementArray = error.getStackTrace();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement element = stackTraceElementArray[n2];
                if (element.getClassName().startsWith("com.example.vibe")) {
                    sb.append(String.format("\u2551   at %s.%s(%s:%d)\n", element.getClassName(), element.getMethodName(), element.getFileName(), element.getLineNumber()));
                }
                ++n2;
            }
        }
        sb.append("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n");
        String logEntry = sb.toString();
        this.writeToLog(logEntry);
        LOG.error("[TOOL #%d] END %s: EXCEPTION in %d ms: %s", callId, toolName, executionTimeMs, error.getMessage());
    }

    public String getStatistics() {
        int total = this.callCounter.get();
        int success = this.successCount.get();
        int failure = this.failureCount.get();
        long avgTime = total > 0 ? this.totalExecutionTime.get() / (long)total : 0L;
        return String.format("Tool Call Statistics:\n  Total calls: %d\n  Successful: %d (%.1f%%)\n  Failed: %d (%.1f%%)\n  Total execution time: %d ms\n  Average execution time: %d ms", total, success, total > 0 ? 100.0 * (double)success / (double)total : 0.0, failure, total > 0 ? 100.0 * (double)failure / (double)total : 0.0, this.totalExecutionTime.get(), avgTime);
    }

    public void resetStatistics() {
        this.callCounter.set(0);
        this.successCount.set(0);
        this.failureCount.set(0);
        this.totalExecutionTime.set(0L);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setVerboseMode(boolean verbose) {
        this.verboseMode = verbose;
    }

    public String getLogFilePath() {
        return this.logFile.getAbsolutePath();
    }

    public void clearLog() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (PrintWriter writer = new PrintWriter(this.logFile);){
                writer.print("");
                LOG.info("Tool log cleared");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOG.error("Failed to clear tool log: %s", e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeToLog(String entry) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                FileWriter fw = new FileWriter(this.logFile, true);
                try {
                    try (PrintWriter pw = new PrintWriter(fw);){
                        pw.print(entry);
                    }
                    if (fw == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fw == null) throw throwable;
                    fw.close();
                    throw throwable;
                }
                fw.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOG.error("Failed to write to tool log: %s", e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    private String formatArgumentValue(Object value) {
        if (value == null) {
            return "null";
        }
        Object object = value;
        if (object instanceof String) {
            void strValue;
            String string = (String)object;
            String cfr_ignored_0 = (String)object;
            if (strValue.length() > 200) {
                return "\"" + this.truncate((String)strValue, 200) + "...\" (" + strValue.length() + " chars)";
            }
            String display = strValue.replace("\n", "\\n").replace("\r", "\\r");
            return "\"" + display + "\"";
        }
        if (value instanceof Map || value instanceof List) {
            String json = GSON.toJson(value);
            if (json.length() > 200) {
                return this.truncate(json, 200) + "...";
            }
            return json;
        }
        return String.valueOf(value);
    }

    /*
     * WARNING - void declaration
     */
    private String summarizeArguments(Map<String, Object> arguments) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        int i = 0;
        for (Map.Entry<String, Object> entry : arguments.entrySet()) {
            Object value;
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(entry.getKey()).append("=");
            Object object = value = entry.getValue();
            if (object instanceof String) {
                void strValue;
                String cfr_ignored_0 = (String)object;
                String cfr_ignored_1 = (String)object;
                sb.append("\"...").append(strValue.length()).append(" chars\"");
            } else {
                sb.append(value);
            }
            if (++i < 3 || arguments.size() <= 3) continue;
            sb.append(", ...(").append(arguments.size() - 3).append(" more)");
            break;
        }
        sb.append("}");
        return sb.toString();
    }

    private String truncate(String str, int maxLength) {
        if (str == null) {
            return "";
        }
        if (str.length() <= maxLength) {
            return str;
        }
        return str.substring(0, maxLength);
    }
}

