/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.tools;

import com.example.vibe.core.logging.LogSanitizer;
import com.example.vibe.core.logging.VibeLogger;
import com.example.vibe.core.tools.ITool;
import com.example.vibe.core.tools.ToolResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;

public class ReadFileTool
implements ITool {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(ReadFileTool.class);
    private static final String SCHEMA = "{\n    \"type\": \"object\",\n    \"properties\": {\n        \"path\": {\n            \"type\": \"string\",\n            \"description\": \"Path to the file (workspace-relative or absolute)\"\n        },\n        \"start_line\": {\n            \"type\": \"integer\",\n            \"description\": \"Start line number (1-based, optional)\"\n        },\n        \"end_line\": {\n            \"type\": \"integer\",\n            \"description\": \"End line number (1-based, optional)\"\n        }\n    },\n    \"required\": [\"path\"]\n}\n";
    private static final int MAX_LINES = 500;

    @Override
    public String getName() {
        return "read_file";
    }

    @Override
    public String getDescription() {
        return "Read the contents of a file. Can read the entire file or a specific line range.";
    }

    @Override
    public String getParameterSchema() {
        return SCHEMA;
    }

    @Override
    public CompletableFuture<ToolResult> execute(Map<String, Object> parameters) {
        return CompletableFuture.supplyAsync(() -> {
            Object endParam;
            long startTime = System.currentTimeMillis();
            String pathStr = (String)parameters.get("path");
            if (pathStr == null || pathStr.isEmpty()) {
                LOG.warn("read_file: \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 path");
                return ToolResult.failure("Path parameter is required");
            }
            Integer startLine = null;
            Integer endLine = null;
            Object startParam = parameters.get("start_line");
            if (startParam instanceof Number) {
                startLine = ((Number)startParam).intValue();
            }
            if ((endParam = parameters.get("end_line")) instanceof Number) {
                endLine = ((Number)endParam).intValue();
            }
            LOG.debug("read_file: path=%s, startLine=%s, endLine=%s", LogSanitizer.truncatePath(pathStr), startLine, endLine);
            try {
                String content = this.readFile(pathStr, startLine, endLine);
                long duration = System.currentTimeMillis() - startTime;
                LOG.debug("read_file: \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u043d %s \u0437\u0430 %s (%d \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432)", LogSanitizer.truncatePath(pathStr), LogSanitizer.formatDuration(duration), content.length());
                return ToolResult.success(content, ToolResult.ToolResultType.CODE);
            }
            catch (IOException e) {
                LOG.error("read_file: \u043e\u0448\u0438\u0431\u043a\u0430 \u0447\u0442\u0435\u043d\u0438\u044f %s: %s", pathStr, e.getMessage());
                return ToolResult.failure("Error reading file: " + e.getMessage());
            }
        });
    }

    private String readFile(String pathStr, Integer startLine, Integer endLine) throws IOException {
        int end;
        String normalizedPath = this.normalizePath(pathStr);
        IFile file = this.findWorkspaceFile(normalizedPath);
        if (file == null || !file.exists()) {
            throw new IOException("File not found in workspace: " + pathStr);
        }
        List<String> lines = this.readFileLines(file);
        int start = startLine != null ? Math.max(1, startLine) : 1;
        int n = end = endLine != null ? Math.min(lines.size(), endLine) : lines.size();
        if (end - start + 1 > 500) {
            end = start + 500 - 1;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("**File:** `").append(file.getFullPath().toString()).append("`\n");
        if (startLine != null || endLine != null) {
            sb.append("**Lines:** ").append(start).append("-").append(end).append("\n");
        }
        sb.append("**Total lines:** ").append(lines.size()).append("\n\n");
        sb.append("```\n");
        int i = start - 1;
        while (i < end && i < lines.size()) {
            sb.append(String.format("%4d | %s%n", i + 1, lines.get(i)));
            ++i;
        }
        sb.append("```");
        if (end < lines.size()) {
            sb.append("\n\n*File truncated. Use start_line/end_line to read more.*");
        }
        return sb.toString();
    }

    private String normalizePath(String path) {
        if (path == null) {
            return null;
        }
        String normalized = path;
        if (normalized.startsWith("/") && !normalized.startsWith("//")) {
            normalized = normalized.substring(1);
        }
        return normalized.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    private IFile findWorkspaceFile(String path) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            IResource resource = root.findMember(path);
            if (resource instanceof IFile && resource.exists()) {
                return (IFile)resource;
            }
        }
        catch (Exception exception) {}
        try {
            IFile file = root.getFile(Path.fromOSString((String)path));
            if (file.exists()) {
                return file;
            }
        }
        catch (Exception exception) {}
        try {
            String forwardSlashPath = path.replace('\\', '/');
            IResource resource = root.findMember(forwardSlashPath);
            if (resource instanceof IFile && resource.exists()) {
                return (IFile)resource;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private List<String> readFileLines(IFile file) throws IOException {
        Object fileCharset;
        ArrayList<String> lines = new ArrayList<String>();
        Charset charset = StandardCharsets.UTF_8;
        try {
            fileCharset = file.getCharset();
            if (fileCharset != null) {
                charset = Charset.forName((String)fileCharset);
            }
        }
        catch (IllegalArgumentException | CoreException throwable) {}
        try {
            fileCharset = null;
            Object var5_7 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(file.getContents(), charset));){
                String line;
                boolean firstLine = true;
                while ((line = reader.readLine()) != null) {
                    if (firstLine) {
                        if (line.startsWith("\ufeff")) {
                            line = line.substring(1);
                        }
                        firstLine = false;
                    }
                    lines.add(line);
                }
            }
            catch (Throwable throwable) {
                if (fileCharset == null) {
                    fileCharset = throwable;
                } else if (fileCharset != throwable) {
                    ((Throwable)fileCharset).addSuppressed(throwable);
                }
                throw fileCharset;
            }
        }
        catch (CoreException e) {
            throw new IOException("Cannot read file: " + e.getMessage(), e);
        }
        return lines;
    }
}

