/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.tools;

import com.example.vibe.core.tools.ITool;
import com.example.vibe.core.tools.ToolResult;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class ListFilesTool
implements ITool {
    private static final String SCHEMA = "{\n    \"type\": \"object\",\n    \"properties\": {\n        \"path\": {\n            \"type\": \"string\",\n            \"description\": \"Directory path (workspace-relative). Leave empty to list projects.\"\n        },\n        \"pattern\": {\n            \"type\": \"string\",\n            \"description\": \"File name pattern to filter (e.g., '*.bsl')\"\n        },\n        \"recursive\": {\n            \"type\": \"boolean\",\n            \"description\": \"Whether to list files recursively (default: false)\"\n        }\n    }\n}\n";
    private static final int MAX_FILES = 100;

    @Override
    public String getName() {
        return "list_files";
    }

    @Override
    public String getDescription() {
        return "List files and directories in the workspace. Can filter by pattern and list recursively.";
    }

    @Override
    public String getParameterSchema() {
        return SCHEMA;
    }

    @Override
    public CompletableFuture<ToolResult> execute(Map<String, Object> parameters) {
        return CompletableFuture.supplyAsync(() -> {
            String path = (String)parameters.get("path");
            String pattern = (String)parameters.get("pattern");
            boolean recursive = Boolean.TRUE.equals(parameters.get("recursive"));
            try {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                if (path == null || path.isEmpty()) {
                    return this.listProjects(root);
                }
                String normalizedPath = this.normalizePath(path);
                IResource resource = this.findWorkspaceResource(normalizedPath);
                if (resource == null || !resource.exists()) {
                    return ToolResult.failure("Path not found: " + path);
                }
                if (!(resource instanceof IContainer)) {
                    return ToolResult.failure("Path is not a directory: " + path);
                }
                return this.listContents((IContainer)resource, pattern, recursive);
            }
            catch (CoreException e) {
                return ToolResult.failure("Error listing files: " + e.getMessage());
            }
        });
    }

    private String normalizePath(String path) {
        if (path == null) {
            return null;
        }
        String normalized = path;
        if (normalized.startsWith("/") && !normalized.startsWith("//")) {
            normalized = normalized.substring(1);
        }
        return normalized.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    private IResource findWorkspaceResource(String path) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember(path);
        if (resource != null && resource.exists()) {
            return resource;
        }
        String forwardSlashPath = path.replace('\\', '/');
        resource = root.findMember(forwardSlashPath);
        if (resource != null && resource.exists()) {
            return resource;
        }
        return null;
    }

    private ToolResult listProjects(IWorkspaceRoot root) {
        StringBuilder sb = new StringBuilder();
        sb.append("**Workspace Projects:**\n\n");
        IProject[] projects = root.getProjects();
        if (projects.length == 0) {
            sb.append("No projects in workspace.\n");
        } else {
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project.isOpen()) {
                    sb.append("  \ud83d\udcc1 ").append(project.getName()).append("/\n");
                } else {
                    sb.append("  \ud83d\udcc1 ").append(project.getName()).append("/ (closed)\n");
                }
                ++n2;
            }
        }
        return ToolResult.success(sb.toString(), ToolResult.ToolResultType.FILE_LIST);
    }

    private ToolResult listContents(IContainer container, String pattern, boolean recursive) throws CoreException {
        StringBuilder sb = new StringBuilder();
        sb.append("**Contents of:** `").append(container.getFullPath().toString()).append("`\n\n");
        ArrayList<String> files = new ArrayList<String>();
        this.collectFiles(container, pattern, recursive, "", files);
        if (files.isEmpty()) {
            sb.append("No files found");
            if (pattern != null) {
                sb.append(" matching pattern: ").append(pattern);
            }
            sb.append(".\n");
        } else {
            for (String file : files) {
                sb.append(file).append("\n");
            }
            if (files.size() == 100) {
                sb.append("\n*Results limited to ").append(100).append(" files.*\n");
            }
        }
        return ToolResult.success(sb.toString(), ToolResult.ToolResultType.FILE_LIST);
    }

    private void collectFiles(IContainer container, String pattern, boolean recursive, String prefix, List<String> files) throws CoreException {
        IResource[] members;
        if (files.size() >= 100) {
            return;
        }
        IResource[] iResourceArray = members = container.members();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            boolean matches;
            IResource member = iResourceArray[n2];
            if (files.size() >= 100) break;
            String name = member.getName();
            boolean bl = matches = pattern == null || this.matchesPattern(name, pattern);
            if (member instanceof IContainer) {
                if (recursive) {
                    files.add(prefix + "\ud83d\udcc1 " + name + "/");
                    this.collectFiles((IContainer)member, pattern, true, prefix + "  ", files);
                } else {
                    files.add(prefix + "\ud83d\udcc1 " + name + "/");
                }
            } else if (matches) {
                files.add(prefix + "\ud83d\udcc4 " + name);
            }
            ++n2;
        }
    }

    private boolean matchesPattern(String name, String pattern) {
        String regex = pattern.replace(".", "\\.").replace("*", ".*").replace("?", ".");
        return name.matches(regex);
    }
}

