/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.streaming;

import java.util.function.Consumer;

public interface IStreamObserver<T> {
    public void onNext(T var1);

    public void onComplete();

    public void onError(Throwable var1);

    public static <T> IStreamObserver<T> create(Consumer<T> onNext) {
        return IStreamObserver.create(onNext, () -> {}, e -> {});
    }

    public static <T> IStreamObserver<T> create(final Consumer<T> onNext, final Runnable onComplete, final Consumer<Throwable> onError) {
        return new IStreamObserver<T>(){

            @Override
            public void onNext(T chunk) {
                if (onNext != null) {
                    onNext.accept(chunk);
                }
            }

            @Override
            public void onComplete() {
                if (onComplete != null) {
                    onComplete.run();
                }
            }

            @Override
            public void onError(Throwable error) {
                if (onError != null) {
                    onError.accept(error);
                }
            }
        };
    }
}

