/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.settings;

import com.example.vibe.core.internal.VibeCorePlugin;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;

public final class SecureStorageUtil {
    private static final String SECURE_NODE_PATH = "/com.example.vibe.core";

    private SecureStorageUtil() {
    }

    public static boolean storeSecurely(String key, String value) {
        try {
            ISecurePreferences root = SecurePreferencesFactory.getDefault();
            ISecurePreferences node = root.node(SECURE_NODE_PATH);
            node.put(key, value, true);
            node.flush();
            return true;
        }
        catch (Exception e) {
            VibeCorePlugin.logError("Failed to store secure value for key: " + key, e);
            return false;
        }
    }

    public static String retrieveSecurely(String key, String defaultValue) {
        try {
            ISecurePreferences root = SecurePreferencesFactory.getDefault();
            ISecurePreferences node = root.node(SECURE_NODE_PATH);
            return node.get(key, defaultValue);
        }
        catch (StorageException storageException) {
            return defaultValue;
        }
    }

    public static void removeSecurely(String key) {
        try {
            ISecurePreferences root = SecurePreferencesFactory.getDefault();
            ISecurePreferences node = root.node(SECURE_NODE_PATH);
            node.remove(key);
            node.flush();
        }
        catch (Exception exception) {}
    }

    public static boolean isAvailable() {
        try {
            ISecurePreferences root = SecurePreferencesFactory.getDefault();
            return root != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean storeApiKey(String providerId, String apiKey) {
        return SecureStorageUtil.storeSecurely(providerId + ".apiKey", apiKey);
    }

    public static String retrieveApiKey(String providerId) {
        return SecureStorageUtil.retrieveSecurely(providerId + ".apiKey", "");
    }
}

