/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.settings;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;

public final class PromptTemplateService {
    private static final ILog LOG = Platform.getLog(PromptTemplateService.class);
    private static PromptTemplateService instance;

    private PromptTemplateService() {
    }

    public static synchronized PromptTemplateService getInstance() {
        if (instance == null) {
            instance = new PromptTemplateService();
        }
        return instance;
    }

    public String applySystemPrompt(String basePrompt) {
        String prefix = this.getPreference("prompt.systemPrefix");
        String suffix = this.getPreference("prompt.systemSuffix");
        String base = basePrompt != null ? basePrompt : "";
        StringBuilder sb = new StringBuilder();
        if (!PromptTemplateService.isBlank(prefix)) {
            sb.append(prefix.trim()).append("\n\n");
        }
        sb.append(base);
        if (!PromptTemplateService.isBlank(suffix)) {
            if (sb.length() > 0 && !base.endsWith("\n")) {
                sb.append("\n\n");
            }
            sb.append(suffix.trim());
        }
        return sb.toString();
    }

    public String applyTemplate(String preferenceKey, String defaultTemplate, Map<String, String> variables) {
        return this.applyTemplate(preferenceKey, defaultTemplate, variables, Set.of());
    }

    public String applyTemplate(String preferenceKey, String defaultTemplate, Map<String, String> variables, Set<String> requiredPlaceholders) {
        String template = this.resolveTemplateWithValidation(preferenceKey, defaultTemplate, requiredPlaceholders);
        if (variables == null || variables.isEmpty()) {
            return template;
        }
        String result = template;
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            String key = entry.getKey();
            if (key == null || key.isEmpty()) continue;
            String value = entry.getValue() != null ? entry.getValue() : "";
            result = result.replace("{{" + key + "}}", value);
        }
        return result;
    }

    private String resolveTemplateWithValidation(String preferenceKey, String defaultTemplate, Set<String> requiredPlaceholders) {
        String custom = this.getPreference(preferenceKey);
        if (PromptTemplateService.isBlank(custom)) {
            return defaultTemplate != null ? defaultTemplate : "";
        }
        if (requiredPlaceholders == null || requiredPlaceholders.isEmpty()) {
            return custom;
        }
        for (String placeholder : requiredPlaceholders) {
            String token;
            if (placeholder == null || placeholder.isBlank() || custom.contains(token = "{{" + placeholder + "}}")) continue;
            this.logWarning("\u0428\u0430\u0431\u043b\u043e\u043d '" + preferenceKey + "' \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043f\u043b\u0435\u0439\u0441\u0445\u043e\u043b\u0434\u0435\u0440 " + token + ". \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432\u0441\u0442\u0440\u043e\u0435\u043d\u043d\u044b\u0439 \u0448\u0430\u0431\u043b\u043e\u043d.");
            return defaultTemplate != null ? defaultTemplate : "";
        }
        return custom;
    }

    public String getTemplate(String preferenceKey, String defaultTemplate) {
        String custom = this.getPreference(preferenceKey);
        if (PromptTemplateService.isBlank(custom)) {
            return defaultTemplate != null ? defaultTemplate : "";
        }
        return custom;
    }

    private String getPreference(String key) {
        return this.getPreferences().get(key, "");
    }

    private IEclipsePreferences getPreferences() {
        return InstanceScope.INSTANCE.getNode("com.example.vibe.core");
    }

    private static boolean isBlank(String value) {
        return value == null || value.trim().isEmpty();
    }

    private void logWarning(String message) {
        LOG.log((IStatus)new Status(2, "com.example.vibe.core", message));
    }
}

