/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.settings;

import java.util.Map;
import java.util.Set;

public final class PromptCatalog {
    private static final Map<String, String> DEFAULT_TEMPLATES = Map.ofEntries(Map.entry("prompt.template.explainCode", "{{prompt}}"), Map.entry("prompt.template.generateCode", "\u0421\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u0443\u0439 \u043a\u043e\u0434 \u043d\u0430 \u044f\u0437\u044b\u043a\u0435 1\u0421 \u0434\u043b\u044f \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0439 \u0437\u0430\u0434\u0430\u0447\u0438:\n\n{{description}}\n\n\u0422\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u044f:\n- \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439 \u0440\u0443\u0441\u0441\u043a\u0438\u0439 \u0441\u0438\u043d\u0442\u0430\u043a\u0441\u0438\u0441 \u044f\u0437\u044b\u043a\u0430 1\u0421\n- \u0414\u043e\u0431\u0430\u0432\u044c \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0438 \u043a \u043a\u043e\u0434\u0443\n- \u0421\u043b\u0435\u0434\u0443\u0439 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u0430\u043c \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u043a\u0438 1\u0421\n"), Map.entry("prompt.template.fixCode", "Fix the following code. Identify any bugs, errors, or issues and provide the corrected version:\n\n```\n{{code}}\n```"), Map.entry("prompt.template.criticiseCode", "Review and critique the following code. Identify potential issues, suggest improvements, and highlight any best practice violations:\n\n```\n{{code}}\n```"), Map.entry("prompt.template.addCode", "Generate code for the following request. The code will be inserted at the current cursor position.\n\nContext (surrounding code):\n```\n{{context}}\n```\n\nRequest: {{request}}\n\nGenerate only the code to insert, without explanation."), Map.entry("prompt.template.docComments", "Generate documentation comments for the following 1C BSL method/procedure. Use the standard 1C documentation format with description, parameters, and return value:\n\n```bsl\n{{code}}\n```\n\nGenerate only the documentation comment block that should be placed above the method."), Map.entry("prompt.template.optimizeQuery", "\u041e\u043f\u0442\u0438\u043c\u0438\u0437\u0438\u0440\u0443\u0439 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u0437\u0430\u043f\u0440\u043e\u0441 1\u0421 (SDBL):\n\n```sdbl\n{{query}}\n```\n\n\u041f\u0440\u043e\u0430\u043d\u0430\u043b\u0438\u0437\u0438\u0440\u0443\u0439 \u0438 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0438:\n1. **\u041e\u043f\u0442\u0438\u043c\u0438\u0437\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438**:\n   - \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0438\u043d\u0434\u0435\u043a\u0441\u043e\u0432\n   - \u041e\u043f\u0442\u0438\u043c\u0438\u0437\u0430\u0446\u0438\u044f \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0439 (JOIN)\n   - \u0423\u043c\u0435\u043d\u044c\u0448\u0435\u043d\u0438\u0435 \u043e\u0431\u044a\u0451\u043c\u0430 \u0432\u044b\u0431\u043e\u0440\u043a\u0438\n\n2. **\u0421\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u043d\u044b\u0435 \u0443\u043b\u0443\u0447\u0448\u0435\u043d\u0438\u044f**:\n   - \u0423\u043f\u0440\u043e\u0449\u0435\u043d\u0438\u0435 \u0443\u0441\u043b\u043e\u0432\u0438\u0439\n   - \u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0438\u0437\u0431\u044b\u0442\u043e\u0447\u043d\u044b\u0445 \u043f\u043e\u043b\u0435\u0439\n   - \u041e\u043f\u0442\u0438\u043c\u0438\u0437\u0430\u0446\u0438\u044f \u0433\u0440\u0443\u043f\u043f\u0438\u0440\u043e\u0432\u043e\u043a\n\n3. **\u041b\u0443\u0447\u0448\u0438\u0435 \u043f\u0440\u0430\u043a\u0442\u0438\u043a\u0438**:\n   - \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0445 \u0442\u0430\u0431\u043b\u0438\u0446\n   - \u041f\u0430\u043a\u0435\u0442\u043d\u0430\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430\n   - \u0427\u0438\u0442\u0430\u0435\u043c\u043e\u0441\u0442\u044c \u043a\u043e\u0434\u0430\n\n\u041f\u043e\u043a\u0430\u0436\u0438 \u043e\u043f\u0442\u0438\u043c\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u0443\u044e \u0432\u0435\u0440\u0441\u0438\u044e \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u0441 \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u044f\u043c\u0438.\n"), Map.entry("prompt.template.findSimilar", "\u041d\u0430\u0439\u0434\u0438 \u043f\u043e\u0445\u043e\u0436\u0438\u0439 \u043a\u043e\u0434 \u0432 \u043a\u043e\u0434\u043e\u0432\u043e\u0439 \u0431\u0430\u0437\u0435 \u0434\u043b\u044f \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0433\u043e \u0444\u0440\u0430\u0433\u043c\u0435\u043d\u0442\u0430:\n\n```bsl\n{{code}}\n```\n\n\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439 \u0441\u0435\u043c\u0430\u043d\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u043f\u043e\u0438\u0441\u043a (RAG) \u0447\u0442\u043e\u0431\u044b \u043d\u0430\u0439\u0442\u0438:\n1. \u041f\u043e\u0445\u043e\u0436\u0438\u0435 \u043f\u0430\u0442\u0442\u0435\u0440\u043d\u044b \u043a\u043e\u0434\u0430\n2. \u041f\u0440\u0438\u043c\u0435\u0440\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u043f\u043e\u0445\u043e\u0436\u0435\u0439 \u043b\u043e\u0433\u0438\u043a\u0438\n3. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u044b\u0435 \u043c\u0435\u0441\u0442\u0430 \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f\n"));
    private static final Map<String, Set<String>> REQUIRED_PLACEHOLDERS = Map.ofEntries(Map.entry("prompt.template.explainCode", Set.of("prompt")), Map.entry("prompt.template.generateCode", Set.of("description")), Map.entry("prompt.template.fixCode", Set.of("code")), Map.entry("prompt.template.criticiseCode", Set.of("code")), Map.entry("prompt.template.addCode", Set.of("context", "request")), Map.entry("prompt.template.docComments", Set.of("code")), Map.entry("prompt.template.optimizeQuery", Set.of("query")), Map.entry("prompt.template.findSimilar", Set.of("code")));

    private PromptCatalog() {
    }

    public static String getDefaultTemplate(String preferenceKey) {
        if (preferenceKey == null) {
            return "";
        }
        return DEFAULT_TEMPLATES.getOrDefault(preferenceKey, "");
    }

    public static Set<String> getRequiredPlaceholders(String preferenceKey) {
        if (preferenceKey == null) {
            return Set.of();
        }
        return REQUIRED_PLACEHOLDERS.getOrDefault(preferenceKey, Set.of());
    }
}

