/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.session;

import com.example.vibe.core.model.ToolCall;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class SessionMessage {
    private final String id;
    private final MessageType type;
    private final String content;
    private final Instant timestamp;
    private final List<ToolCall> toolCalls;
    private final String toolCallId;
    private final String toolName;
    private final boolean isError;

    private SessionMessage(Builder builder) {
        this.id = builder.id != null ? builder.id : UUID.randomUUID().toString();
        this.type = Objects.requireNonNull(builder.type, "type");
        this.content = builder.content;
        this.timestamp = builder.timestamp != null ? builder.timestamp : Instant.now();
        this.toolCalls = builder.toolCalls != null ? Collections.unmodifiableList(builder.toolCalls) : Collections.emptyList();
        this.toolCallId = builder.toolCallId;
        this.toolName = builder.toolName;
        this.isError = builder.isError;
    }

    public String getId() {
        return this.id;
    }

    public MessageType getType() {
        return this.type;
    }

    public String getContent() {
        return this.content;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public List<ToolCall> getToolCalls() {
        return this.toolCalls;
    }

    public boolean hasToolCalls() {
        return !this.toolCalls.isEmpty();
    }

    public String getToolCallId() {
        return this.toolCallId;
    }

    public String getToolName() {
        return this.toolName;
    }

    public boolean isError() {
        return this.isError;
    }

    public static SessionMessage user(String content) {
        return SessionMessage.builder().type(MessageType.USER).content(content).build();
    }

    public static SessionMessage assistant(String content) {
        return SessionMessage.builder().type(MessageType.ASSISTANT).content(content).build();
    }

    public static SessionMessage assistantWithToolCalls(String content, List<ToolCall> toolCalls) {
        return SessionMessage.builder().type(MessageType.ASSISTANT).content(content).toolCalls(toolCalls).build();
    }

    public static SessionMessage system(String content) {
        return SessionMessage.builder().type(MessageType.SYSTEM).content(content).build();
    }

    public static SessionMessage toolCall(String toolName, String toolCallId, String arguments) {
        return SessionMessage.builder().type(MessageType.TOOL_CALL).toolName(toolName).toolCallId(toolCallId).content(arguments).build();
    }

    public static SessionMessage toolResult(String toolCallId, String content, boolean isError) {
        return SessionMessage.builder().type(MessageType.TOOL_RESULT).toolCallId(toolCallId).content(content).isError(isError).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "SessionMessage{type=" + String.valueOf((Object)this.type) + ", content='" + (String)(this.content != null && this.content.length() > 50 ? this.content.substring(0, 50) + "..." : this.content) + "', toolCalls=" + this.toolCalls.size() + "}";
    }

    public static class Builder {
        private String id;
        private MessageType type;
        private String content;
        private Instant timestamp;
        private List<ToolCall> toolCalls;
        private String toolCallId;
        private String toolName;
        private boolean isError;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder type(MessageType type) {
            this.type = type;
            return this;
        }

        public Builder content(String content) {
            this.content = content;
            return this;
        }

        public Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder toolCalls(List<ToolCall> toolCalls) {
            this.toolCalls = toolCalls;
            return this;
        }

        public Builder toolCallId(String toolCallId) {
            this.toolCallId = toolCallId;
            return this;
        }

        public Builder toolName(String toolName) {
            this.toolName = toolName;
            return this;
        }

        public Builder isError(boolean isError) {
            this.isError = isError;
            return this;
        }

        public SessionMessage build() {
            return new SessionMessage(this);
        }
    }

    public static enum MessageType {
        USER,
        ASSISTANT,
        SYSTEM,
        TOOL_CALL,
        TOOL_RESULT;

    }
}

