/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.session;

import com.example.vibe.core.session.FileSessionStore;
import com.example.vibe.core.session.ISessionStore;
import com.example.vibe.core.session.Session;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class SessionManager {
    private static final String PLUGIN_ID = "com.example.vibe.core";
    private static final ILog LOG = Platform.getLog(SessionManager.class);
    private static SessionManager instance;
    private final ISessionStore sessionStore;
    private final List<ISessionChangeListener> listeners = new CopyOnWriteArrayList<ISessionChangeListener>();
    private Session currentSession;

    public static synchronized SessionManager getInstance() {
        if (instance == null) {
            instance = new SessionManager(new FileSessionStore());
        }
        return instance;
    }

    public SessionManager(ISessionStore sessionStore) {
        this.sessionStore = sessionStore;
    }

    public Session createSession() {
        Session session = new Session();
        this.notifySessionCreated(session);
        return session;
    }

    public Session createSessionForProject(IProject project) {
        Session session = new Session();
        if (project != null && project.exists()) {
            session.setProjectName(project.getName());
            IPath location = project.getLocation();
            if (location != null) {
                session.setProjectPath(location.toOSString());
            }
        }
        this.notifySessionCreated(session);
        return session;
    }

    public Session createSessionForCurrentProject() {
        IProject project = this.getCurrentProject();
        if (project != null) {
            return this.createSessionForProject(project);
        }
        return this.createSession();
    }

    public boolean saveSession(Session session) {
        try {
            this.sessionStore.save(session);
            this.notifySessionSaved(session);
            return true;
        }
        catch (ISessionStore.SessionStoreException e) {
            this.logError("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0441\u0435\u0441\u0441\u0438\u0438: " + session.getId(), e);
            return false;
        }
    }

    public Optional<Session> loadSession(String sessionId) {
        try {
            Optional<Session> session = this.sessionStore.load(sessionId);
            session.ifPresent(this::notifySessionLoaded);
            return session;
        }
        catch (ISessionStore.SessionStoreException e) {
            this.logError("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0441\u0435\u0441\u0441\u0438\u0438: " + sessionId, e);
            return Optional.empty();
        }
    }

    public boolean deleteSession(String sessionId) {
        try {
            boolean deleted = this.sessionStore.delete(sessionId);
            if (deleted) {
                this.notifySessionDeleted(sessionId);
                if (this.currentSession != null && this.currentSession.getId().equals(sessionId)) {
                    this.currentSession = null;
                }
            }
            return deleted;
        }
        catch (ISessionStore.SessionStoreException e) {
            this.logError("\u041e\u0448\u0438\u0431\u043a\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f \u0441\u0435\u0441\u0441\u0438\u0438: " + sessionId, e);
            return false;
        }
    }

    public List<ISessionStore.SessionSummary> listAllSessions() {
        try {
            return this.sessionStore.listAll();
        }
        catch (ISessionStore.SessionStoreException e) {
            this.logError("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0441\u043f\u0438\u0441\u043a\u0430 \u0441\u0435\u0441\u0441\u0438\u0439", e);
            return List.of();
        }
    }

    public List<ISessionStore.SessionSummary> listSessionsForProject(IProject project) {
        if (project == null || !project.exists()) {
            return List.of();
        }
        IPath location = project.getLocation();
        if (location == null) {
            return List.of();
        }
        try {
            return this.sessionStore.listByProject(location.toOSString());
        }
        catch (ISessionStore.SessionStoreException e) {
            this.logError("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0441\u0435\u0441\u0441\u0438\u0439 \u0434\u043b\u044f \u043f\u0440\u043e\u0435\u043a\u0442\u0430: " + project.getName(), e);
            return List.of();
        }
    }

    public List<ISessionStore.SessionSummary> listRecentSessions(int limit) {
        try {
            return this.sessionStore.listRecent(limit);
        }
        catch (ISessionStore.SessionStoreException e) {
            this.logError("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u043d\u0435\u0434\u0430\u0432\u043d\u0438\u0445 \u0441\u0435\u0441\u0441\u0438\u0439", e);
            return List.of();
        }
    }

    public Session getCurrentSession() {
        return this.currentSession;
    }

    public void setCurrentSession(Session session) {
        Session oldSession = this.currentSession;
        this.currentSession = session;
        this.notifyCurrentSessionChanged(oldSession, session);
    }

    public Session getOrCreateCurrentSession() {
        if (this.currentSession == null) {
            this.currentSession = this.createSessionForCurrentProject();
        }
        return this.currentSession;
    }

    public Session startNewSession() {
        if (this.currentSession != null && !this.currentSession.isEmpty()) {
            this.currentSession.setStatus(Session.SessionStatus.COMPLETED);
            this.saveSession(this.currentSession);
        }
        this.currentSession = this.createSessionForCurrentProject();
        return this.currentSession;
    }

    public void archiveSession(String sessionId) {
        this.loadSession(sessionId).ifPresent(session -> {
            session.setStatus(Session.SessionStatus.ARCHIVED);
            this.saveSession((Session)session);
        });
    }

    public int purgeOldSessions(int maxAgeDays) {
        try {
            return this.sessionStore.purgeOldSessions(maxAgeDays);
        }
        catch (ISessionStore.SessionStoreException e) {
            this.logError("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0447\u0438\u0441\u0442\u043a\u0438 \u0441\u0442\u0430\u0440\u044b\u0445 \u0441\u0435\u0441\u0441\u0438\u0439", e);
            return 0;
        }
    }

    public IProject findProjectByPath(String projectPath) {
        if (projectPath == null || projectPath.isEmpty()) {
            return null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject[] iProjectArray = root.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPath location;
            IProject project = iProjectArray[n2];
            if (project.exists() && project.isOpen() && (location = project.getLocation()) != null && location.toOSString().equals(projectPath)) {
                return project;
            }
            ++n2;
        }
        return null;
    }

    private IProject getCurrentProject() {
        IProject[] projects;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject[] iProjectArray = projects = root.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.exists() && project.isOpen()) {
                return project;
            }
            ++n2;
        }
        return null;
    }

    public void bindSessionToProject(Session session, IProject project) {
        if (session == null) {
            return;
        }
        if (project != null && project.exists()) {
            session.setProjectName(project.getName());
            IPath location = project.getLocation();
            if (location != null) {
                session.setProjectPath(location.toOSString());
            }
        } else {
            session.setProjectName(null);
            session.setProjectPath(null);
        }
    }

    public void addListener(ISessionChangeListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(ISessionChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void notifySessionCreated(Session session) {
        for (ISessionChangeListener listener : this.listeners) {
            try {
                listener.onSessionCreated(session);
            }
            catch (Exception e) {
                this.logWarning("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0441\u043b\u0443\u0448\u0430\u0442\u0435\u043b\u0435 \u0441\u043e\u0431\u044b\u0442\u0438\u0439 \u0441\u0435\u0441\u0441\u0438\u0439", e);
            }
        }
    }

    private void notifySessionSaved(Session session) {
        for (ISessionChangeListener listener : this.listeners) {
            try {
                listener.onSessionSaved(session);
            }
            catch (Exception e) {
                this.logWarning("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0441\u043b\u0443\u0448\u0430\u0442\u0435\u043b\u0435 \u0441\u043e\u0431\u044b\u0442\u0438\u0439 \u0441\u0435\u0441\u0441\u0438\u0439", e);
            }
        }
    }

    private void notifySessionLoaded(Session session) {
        for (ISessionChangeListener listener : this.listeners) {
            try {
                listener.onSessionLoaded(session);
            }
            catch (Exception e) {
                this.logWarning("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0441\u043b\u0443\u0448\u0430\u0442\u0435\u043b\u0435 \u0441\u043e\u0431\u044b\u0442\u0438\u0439 \u0441\u0435\u0441\u0441\u0438\u0439", e);
            }
        }
    }

    private void notifySessionDeleted(String sessionId) {
        for (ISessionChangeListener listener : this.listeners) {
            try {
                listener.onSessionDeleted(sessionId);
            }
            catch (Exception e) {
                this.logWarning("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0441\u043b\u0443\u0448\u0430\u0442\u0435\u043b\u0435 \u0441\u043e\u0431\u044b\u0442\u0438\u0439 \u0441\u0435\u0441\u0441\u0438\u0439", e);
            }
        }
    }

    private void notifyCurrentSessionChanged(Session oldSession, Session newSession) {
        for (ISessionChangeListener listener : this.listeners) {
            try {
                listener.onCurrentSessionChanged(oldSession, newSession);
            }
            catch (Exception e) {
                this.logWarning("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0441\u043b\u0443\u0448\u0430\u0442\u0435\u043b\u0435 \u0441\u043e\u0431\u044b\u0442\u0438\u0439 \u0441\u0435\u0441\u0441\u0438\u0439", e);
            }
        }
    }

    private void logError(String message, Throwable error) {
        LOG.log((IStatus)new Status(4, PLUGIN_ID, message, error));
    }

    private void logWarning(String message, Throwable error) {
        LOG.log((IStatus)new Status(2, PLUGIN_ID, message, error));
    }

    public static interface ISessionChangeListener {
        default public void onSessionCreated(Session session) {
        }

        default public void onSessionSaved(Session session) {
        }

        default public void onSessionLoaded(Session session) {
        }

        default public void onSessionDeleted(String sessionId) {
        }

        default public void onCurrentSessionChanged(Session oldSession, Session newSession) {
        }
    }
}

