/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.session;

import com.example.vibe.core.session.Session;
import java.time.Instant;
import java.util.List;
import java.util.Optional;

public interface ISessionStore {
    public void save(Session var1) throws SessionStoreException;

    public Optional<Session> load(String var1) throws SessionStoreException;

    public boolean delete(String var1) throws SessionStoreException;

    public boolean exists(String var1);

    public List<SessionSummary> listAll() throws SessionStoreException;

    public List<SessionSummary> listByProject(String var1) throws SessionStoreException;

    public List<SessionSummary> listRecent(int var1) throws SessionStoreException;

    public int purgeOldSessions(int var1) throws SessionStoreException;

    public static class SessionStoreException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public SessionStoreException(String message) {
            super(message);
        }

        public SessionStoreException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class SessionSummary {
        private final String id;
        private final String title;
        private final String projectName;
        private final Session.SessionStatus status;
        private final Instant createdAt;
        private final Instant updatedAt;
        private final int messageCount;

        public SessionSummary(String id, String title, String projectName, Session.SessionStatus status, Instant createdAt, Instant updatedAt, int messageCount) {
            this.id = id;
            this.title = title;
            this.projectName = projectName;
            this.status = status;
            this.createdAt = createdAt;
            this.updatedAt = updatedAt;
            this.messageCount = messageCount;
        }

        public String getId() {
            return this.id;
        }

        public String getTitle() {
            return this.title;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public Session.SessionStatus getStatus() {
            return this.status;
        }

        public Instant getCreatedAt() {
            return this.createdAt;
        }

        public Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public int getMessageCount() {
            return this.messageCount;
        }

        public static SessionSummary from(Session session) {
            return new SessionSummary(session.getId(), session.getTitle(), session.getProjectName(), session.getStatus(), session.getCreatedAt(), session.getUpdatedAt(), session.getMessageCount());
        }

        public String toString() {
            return "SessionSummary{id='" + this.id + "', title='" + this.title + "', project='" + this.projectName + "', messages=" + this.messageCount + "}";
        }
    }
}

