/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.review;

import com.example.vibe.core.logging.VibeLogger;
import com.example.vibe.core.review.BslReviewIssue;
import com.example.vibe.core.review.BslReviewResult;
import com.example.vibe.core.review.BslSilentFailureHunter;
import java.util.ArrayList;
import java.util.List;

public class BslCodeReviewer {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(BslCodeReviewer.class);
    private final BslSilentFailureHunter silentFailureHunter = new BslSilentFailureHunter();

    public BslReviewResult review(String code, String filePath) {
        long startTime = System.currentTimeMillis();
        ArrayList<BslReviewIssue> allIssues = new ArrayList<BslReviewIssue>();
        try {
            List<BslReviewIssue> silentFailures = this.silentFailureHunter.analyze(code, filePath);
            allIssues.addAll(silentFailures);
            LOG.debug("Reviewed %s: found %d issues (%d reportable)", filePath, allIssues.size(), allIssues.stream().filter(BslReviewIssue::shouldReport).count());
        }
        catch (Exception e) {
            LOG.error("Error reviewing %s: %s", filePath, e.getMessage());
        }
        long elapsed = System.currentTimeMillis() - startTime;
        return new BslReviewResult(filePath, allIssues, elapsed);
    }

    public List<BslReviewIssue> reviewAndFilter(String code, String filePath) {
        return this.review(code, filePath).getReportableIssues();
    }

    public boolean hasCriticalIssues(String code, String filePath) {
        return this.review(code, filePath).hasCriticalIssues();
    }

    public String generateReport(String code, String filePath) {
        return this.review(code, filePath).toReport();
    }

    public List<BslReviewResult> reviewMultiple(List<FileContent> files) {
        ArrayList<BslReviewResult> results = new ArrayList<BslReviewResult>();
        for (FileContent file : files) {
            results.add(this.review(file.code(), file.path()));
        }
        return results;
    }

    public static String summarizeMultiple(List<BslReviewResult> results) {
        int totalFiles = results.size();
        int filesWithIssues = (int)results.stream().filter(BslReviewResult::hasReportableIssues).count();
        int totalIssues = results.stream().mapToInt(BslReviewResult::getReportableCount).sum();
        int criticalIssues = results.stream().mapToInt(BslReviewResult::getCriticalCount).sum();
        StringBuilder sb = new StringBuilder();
        sb.append("## \u0418\u0442\u043e\u0433\u0438 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043a\u043e\u0434\u0430\n\n");
        sb.append(String.format("- **\u041f\u0440\u043e\u0432\u0435\u0440\u0435\u043d\u043e \u0444\u0430\u0439\u043b\u043e\u0432:** %d\n", totalFiles));
        sb.append(String.format("- **\u0424\u0430\u0439\u043b\u043e\u0432 \u0441 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430\u043c\u0438:** %d\n", filesWithIssues));
        sb.append(String.format("- **\u0412\u0441\u0435\u0433\u043e \u043f\u0440\u043e\u0431\u043b\u0435\u043c:** %d\n", totalIssues));
        if (criticalIssues > 0) {
            sb.append(String.format("- **\ud83d\udd34 \u041a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0445:** %d\n", criticalIssues));
        }
        if (totalIssues == 0) {
            sb.append("\n\u2705 \u041a\u043e\u0434 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u0430\u043c \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0430.\n");
        } else {
            sb.append("\n### \u0414\u0435\u0442\u0430\u043b\u0438 \u043f\u043e \u0444\u0430\u0439\u043b\u0430\u043c\n\n");
            for (BslReviewResult result : results) {
                if (!result.hasReportableIssues()) continue;
                sb.append(String.format("- **%s**: %s\n", result.getFilePath(), result.getSummary()));
            }
        }
        return sb.toString();
    }

    public record FileContent(String path, String code) {
    }
}

