/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.provider;

import com.example.vibe.core.backend.BackendConfig;
import com.example.vibe.core.backend.BackendService;
import com.example.vibe.core.logging.VibeLogger;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;

public class ModelService {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(ModelService.class);
    private static volatile ModelService instance;
    private static final Map<String, String> DISPLAY_NAMES;
    private final List<ModelInfo> availableModels = new CopyOnWriteArrayList<ModelInfo>();
    private volatile String selectedModel = "auto";
    private final List<ModelChangeListener> listeners = new CopyOnWriteArrayList<ModelChangeListener>();
    private final HttpClient httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).connectTimeout(Duration.ofSeconds(10L)).build();

    static {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.put("auto", "\u0410\u0432\u0442\u043e (GLM-4.7)");
        m.put("glm-4.7", "GLM-4.7 (Z.ai)");
        m.put("minimax-m2.1", "MiniMax M2.1");
        m.put("kimi-k2.5", "Kimi K2.5");
        m.put("gemini-3-flash", "Gemini 3 Flash");
        DISPLAY_NAMES = Collections.unmodifiableMap(m);
    }

    private ModelService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ModelService getInstance() {
        if (instance != null) return instance;
        Class<ModelService> clazz = ModelService.class;
        synchronized (ModelService.class) {
            if (instance != null) return instance;
            instance = new ModelService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public CompletableFuture<List<ModelInfo>> fetchModels() {
        String apiKey = BackendService.getInstance().getApiKey();
        if (apiKey == null || apiKey.isEmpty()) {
            LOG.warn("Cannot fetch models: no API key configured");
            this.setDefaultModels();
            return CompletableFuture.completedFuture(this.availableModels);
        }
        String url = BackendConfig.LITELLM_BASE_URL + "/models";
        LOG.info("Fetching models from: %s", url);
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("Authorization", "Bearer " + apiKey).timeout(Duration.ofSeconds(15L)).GET().build();
        return ((CompletableFuture)this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(response -> {
            if (response.statusCode() != 200) {
                LOG.warn("Failed to fetch models: HTTP %d", response.statusCode());
                this.setDefaultModels();
                return this.availableModels;
            }
            return this.parseModelsResponse((String)response.body());
        })).exceptionally(ex -> {
            LOG.warn("Error fetching models: %s", ex.getMessage());
            this.setDefaultModels();
            return this.availableModels;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ModelInfo> parseModelsResponse(String body) {
        try {
            boolean hasAuto;
            JsonObject json = JsonParser.parseString((String)body).getAsJsonObject();
            JsonArray data = json.getAsJsonArray("data");
            ArrayList<ModelInfo> models = new ArrayList<ModelInfo>();
            if (data != null) {
                for (JsonElement element : data) {
                    JsonObject modelObj = element.getAsJsonObject();
                    String id = modelObj.get("id").getAsString();
                    String displayName = DISPLAY_NAMES.getOrDefault(id, id);
                    models.add(new ModelInfo(id, displayName));
                }
            }
            if (!(hasAuto = models.stream().anyMatch(m -> "auto".equals(m.getId())))) {
                models.add(0, new ModelInfo("auto", DISPLAY_NAMES.get("auto")));
            } else {
                models.sort((a, b) -> {
                    if ("auto".equals(a.getId())) {
                        return -1;
                    }
                    if ("auto".equals(b.getId())) {
                        return 1;
                    }
                    return 0;
                });
            }
            List<ModelInfo> list = this.availableModels;
            synchronized (list) {
                this.availableModels.clear();
                this.availableModels.addAll(models);
            }
            LOG.info("Loaded %d models", models.size());
        }
        catch (Exception e) {
            LOG.error("Failed to parse models response: %s", e.getMessage());
            this.setDefaultModels();
        }
        return this.availableModels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDefaultModels() {
        ArrayList<ModelInfo> defaults = new ArrayList<ModelInfo>();
        for (Map.Entry<String, String> entry : DISPLAY_NAMES.entrySet()) {
            defaults.add(new ModelInfo(entry.getKey(), entry.getValue()));
        }
        List<ModelInfo> list = this.availableModels;
        synchronized (list) {
            this.availableModels.clear();
            this.availableModels.addAll(defaults);
        }
    }

    public List<ModelInfo> getAvailableModels() {
        if (this.availableModels.isEmpty()) {
            this.setDefaultModels();
        }
        return Collections.unmodifiableList(new ArrayList<ModelInfo>(this.availableModels));
    }

    public String getSelectedModel() {
        return this.selectedModel;
    }

    public void setSelectedModel(String modelId) {
        if (modelId == null || modelId.equals(this.selectedModel)) {
            return;
        }
        this.selectedModel = modelId;
        LOG.info("Model changed to: %s", modelId);
        for (ModelChangeListener listener : this.listeners) {
            try {
                listener.onModelChanged(modelId);
            }
            catch (Exception e) {
                LOG.error("Error notifying model change listener: %s", e.getMessage());
            }
        }
    }

    public void addModelChangeListener(ModelChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeModelChangeListener(ModelChangeListener listener) {
        this.listeners.remove(listener);
    }

    public static interface ModelChangeListener {
        public void onModelChanged(String var1);
    }

    public static class ModelInfo {
        private final String id;
        private final String displayName;

        public ModelInfo(String id, String displayName) {
            this.id = id;
            this.displayName = displayName;
        }

        public String getId() {
            return this.id;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

