/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.provider;

public class LlmProviderException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final int statusCode;
    private final String errorType;

    public LlmProviderException(String message) {
        this(message, null, 0, null);
    }

    public LlmProviderException(String message, Throwable cause) {
        this(message, cause, 0, null);
    }

    public LlmProviderException(String message, Throwable cause, int statusCode, String errorType) {
        super(message, cause);
        this.statusCode = statusCode;
        this.errorType = errorType;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public boolean isRateLimitError() {
        return this.statusCode == 429 || "rate_limit_error".equals(this.errorType);
    }

    public boolean isAuthenticationError() {
        return this.statusCode == 401 || this.statusCode == 403 || "authentication_error".equals(this.errorType);
    }

    public boolean isBudgetExceeded() {
        return this.statusCode == 402 || this.statusCode == 400 && this.errorType != null && this.errorType.contains("ExceededBudget");
    }
}

