/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.permissions;

import com.example.vibe.core.permissions.PermissionDecision;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.regex.Pattern;

public class PermissionRule {
    private final String toolName;
    private final PermissionDecision decision;
    private final String resourcePattern;
    private final boolean isGlob;
    private final int priority;
    private final String description;
    private transient PathMatcher pathMatcher;
    private transient Pattern regexPattern;

    private PermissionRule(Builder builder) {
        this.toolName = Objects.requireNonNull(builder.toolName, "toolName");
        this.decision = Objects.requireNonNull(builder.decision, "decision");
        this.resourcePattern = builder.resourcePattern;
        this.isGlob = builder.isGlob;
        this.priority = builder.priority;
        this.description = builder.description;
    }

    public String getToolName() {
        return this.toolName;
    }

    public PermissionDecision getDecision() {
        return this.decision;
    }

    public String getResourcePattern() {
        return this.resourcePattern;
    }

    public boolean isGlob() {
        return this.isGlob;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean matches(String resource) {
        if (this.resourcePattern == null || this.resourcePattern.equals("*")) {
            return true;
        }
        if (resource == null || resource.isEmpty()) {
            return false;
        }
        if (this.isGlob) {
            return this.matchesGlob(resource);
        }
        return this.matchesRegex(resource);
    }

    public boolean matchesTool(String tool) {
        return this.toolName.equals("*") || this.toolName.equals(tool);
    }

    private boolean matchesGlob(String resource) {
        if (this.pathMatcher == null && this.resourcePattern != null) {
            try {
                this.pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + this.resourcePattern);
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (this.pathMatcher != null) {
            try {
                return this.pathMatcher.matches(Paths.get(resource, new String[0]));
            }
            catch (Exception exception) {
                return resource.matches(this.globToRegex(this.resourcePattern));
            }
        }
        return false;
    }

    private boolean matchesRegex(String resource) {
        if (this.regexPattern == null && this.resourcePattern != null) {
            try {
                this.regexPattern = Pattern.compile(this.resourcePattern);
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (this.regexPattern != null) {
            return this.regexPattern.matcher(resource).matches();
        }
        return false;
    }

    private String globToRegex(String glob) {
        StringBuilder regex = new StringBuilder("^");
        char[] cArray = glob.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '*': {
                    regex.append(".*");
                    break;
                }
                case '?': {
                    regex.append(".");
                    break;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    regex.append("\\").append(c);
                    break;
                }
                default: {
                    regex.append(c);
                }
            }
            ++n2;
        }
        regex.append("$");
        return regex.toString();
    }

    public static Builder allow(String toolName) {
        return new Builder(toolName, PermissionDecision.ALLOW);
    }

    public static Builder deny(String toolName) {
        return new Builder(toolName, PermissionDecision.DENY);
    }

    public static Builder ask(String toolName) {
        return new Builder(toolName, PermissionDecision.ASK);
    }

    public static Builder builder(String toolName, PermissionDecision decision) {
        return new Builder(toolName, decision);
    }

    public String toString() {
        return "PermissionRule{tool='" + this.toolName + "', decision=" + String.valueOf((Object)this.decision) + ", pattern='" + this.resourcePattern + "', priority=" + this.priority + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionRule that = (PermissionRule)o;
        return Objects.equals(this.toolName, that.toolName) && this.decision == that.decision && Objects.equals(this.resourcePattern, that.resourcePattern);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.toolName, this.decision, this.resourcePattern});
    }

    public static class Builder {
        private final String toolName;
        private final PermissionDecision decision;
        private String resourcePattern = "*";
        private boolean isGlob = true;
        private int priority = 0;
        private String description;

        private Builder(String toolName, PermissionDecision decision) {
            this.toolName = toolName;
            this.decision = decision;
        }

        public PermissionRule forAllResources() {
            this.resourcePattern = "*";
            return this.build();
        }

        public Builder forResourcePattern(String pattern) {
            this.resourcePattern = pattern;
            this.isGlob = true;
            return this;
        }

        public Builder forResourceRegex(String regex) {
            this.resourcePattern = regex;
            this.isGlob = false;
            return this;
        }

        public Builder withPriority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public PermissionRule build() {
            return new PermissionRule(this);
        }
    }
}

