/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.permissions;

import com.example.vibe.core.permissions.IPermissionCallback;
import com.example.vibe.core.permissions.IPermissionManager;
import com.example.vibe.core.permissions.PermissionDecision;
import com.example.vibe.core.permissions.PermissionRule;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class PermissionManager
implements IPermissionManager {
    private static final String PLUGIN_ID = "com.example.vibe.core";
    private static final String PREF_RULES = "permission.rules";
    private static final ILog LOG = Platform.getLog(PermissionManager.class);
    private static PermissionManager instance;
    private final List<PermissionRule> rules = new CopyOnWriteArrayList<PermissionRule>();
    private final Map<String, PermissionDecision> sessionPermissions = new ConcurrentHashMap<String, PermissionDecision>();
    private final Gson gson = new GsonBuilder().create();
    private volatile IPermissionCallback callback;

    public static synchronized PermissionManager getInstance() {
        if (instance == null) {
            instance = new PermissionManager();
            instance.loadRules();
        }
        return instance;
    }

    public PermissionManager() {
        this.loadDefaultRules();
    }

    @Override
    public CompletableFuture<PermissionDecision> check(String toolName, String action, Map<String, Object> context) {
        String resource = this.extractResource(context);
        String sessionKey = toolName + ":" + resource;
        PermissionDecision sessionDecision = this.sessionPermissions.get(sessionKey);
        if (sessionDecision != null) {
            return CompletableFuture.completedFuture(sessionDecision);
        }
        PermissionDecision ruleDecision = this.checkSync(toolName, resource);
        if (ruleDecision == PermissionDecision.ASK && this.callback != null) {
            return this.requestUserConfirmation(toolName, action, resource, context);
        }
        return CompletableFuture.completedFuture(ruleDecision);
    }

    @Override
    public PermissionDecision checkSync(String toolName, String resource) {
        String sessionKey = toolName + ":" + resource;
        PermissionDecision sessionDecision = this.sessionPermissions.get(sessionKey);
        if (sessionDecision != null) {
            return sessionDecision;
        }
        ArrayList<PermissionRule> matchingRules = new ArrayList<PermissionRule>();
        for (PermissionRule rule : this.rules) {
            if (!rule.matchesTool(toolName) || !rule.matches(resource)) continue;
            matchingRules.add(rule);
        }
        if (matchingRules.isEmpty()) {
            return PermissionDecision.ASK;
        }
        matchingRules.sort(Comparator.comparingInt(PermissionRule::getPriority).reversed());
        return ((PermissionRule)matchingRules.get(0)).getDecision();
    }

    private CompletableFuture<PermissionDecision> requestUserConfirmation(String toolName, String action, String resource, Map<String, Object> context) {
        IPermissionCallback cb = this.callback;
        if (cb == null) {
            return CompletableFuture.completedFuture(PermissionDecision.DENY);
        }
        IPermissionCallback.PermissionRequest request = new IPermissionCallback.PermissionRequest(toolName, this.getToolDescription(toolName), action, resource, context, this.isDestructiveTool(toolName));
        return ((CompletableFuture)cb.requestPermission(request).thenApply(response -> {
            PermissionDecision decision = response.getDecision();
            if (response.isRememberForSession()) {
                this.addSessionPermission(toolName, resource, decision);
            } else if (response.isRememberPermanently()) {
                PermissionRule rule = PermissionRule.builder(toolName, decision).forResourcePattern(resource).withPriority(100).withDescription("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u043e").build();
                this.addRule(rule);
                this.saveRules();
            }
            return decision;
        })).exceptionally(error -> {
            this.logError("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f", (Throwable)error);
            return PermissionDecision.DENY;
        });
    }

    private String extractResource(Map<String, Object> context) {
        if (context == null) {
            return "*";
        }
        String[] stringArray = new String[]{"path", "file", "filePath", "command", "resource"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            Object value = context.get(key);
            if (value != null) {
                return value.toString();
            }
            ++n2;
        }
        return "*";
    }

    private String getToolDescription(String toolName) {
        switch (toolName) {
            case "shell": {
                return "\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 shell \u043a\u043e\u043c\u0430\u043d\u0434";
            }
            case "read_file": {
                return "\u0427\u0442\u0435\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u043e\u0432";
            }
            case "write_file": {
                return "\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u043e\u0432";
            }
            case "edit_file": {
                return "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u043e\u0432";
            }
            case "glob": {
                return "\u041f\u043e\u0438\u0441\u043a \u0444\u0430\u0439\u043b\u043e\u0432 \u043f\u043e \u043f\u0430\u0442\u0442\u0435\u0440\u043d\u0443";
            }
            case "grep": {
                return "\u041f\u043e\u0438\u0441\u043a \u0432 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u043c \u0444\u0430\u0439\u043b\u043e\u0432";
            }
        }
        return "\u0418\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442: " + toolName;
    }

    private boolean isDestructiveTool(String toolName) {
        switch (toolName) {
            case "edit_file": 
            case "write_file": 
            case "shell": {
                return true;
            }
        }
        return false;
    }

    @Override
    public List<PermissionRule> getRulesForTool(String toolName) {
        ArrayList<PermissionRule> result = new ArrayList<PermissionRule>();
        for (PermissionRule rule : this.rules) {
            if (!rule.matchesTool(toolName)) continue;
            result.add(rule);
        }
        return result;
    }

    @Override
    public List<PermissionRule> getAllRules() {
        return Collections.unmodifiableList(new ArrayList<PermissionRule>(this.rules));
    }

    @Override
    public void addRule(PermissionRule rule) {
        if (rule != null) {
            this.rules.removeIf(r -> r.getToolName().equals(rule.getToolName()) && String.valueOf(r.getResourcePattern()).equals(String.valueOf(rule.getResourcePattern())));
            this.rules.add(rule);
        }
    }

    @Override
    public boolean removeRule(PermissionRule rule) {
        return this.rules.remove(rule);
    }

    @Override
    public void clearRules() {
        this.rules.clear();
    }

    @Override
    public void loadDefaultRules() {
        this.rules.clear();
        this.addRule(PermissionRule.allow("read_file").withPriority(10).withDescription("\u0427\u0442\u0435\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u043e\u0432 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043e").forAllResources());
        this.addRule(PermissionRule.allow("glob").withPriority(10).withDescription("\u041f\u043e\u0438\u0441\u043a \u0444\u0430\u0439\u043b\u043e\u0432 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d").forAllResources());
        this.addRule(PermissionRule.allow("grep").withPriority(10).withDescription("\u041f\u043e\u0438\u0441\u043a \u0432 \u0444\u0430\u0439\u043b\u0430\u0445 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d").forAllResources());
        this.addRule(PermissionRule.allow("list_files").withPriority(10).withDescription("\u0421\u043f\u0438\u0441\u043e\u043a \u0444\u0430\u0439\u043b\u043e\u0432 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d").forAllResources());
        this.addRule(PermissionRule.allow("search_codebase").withPriority(10).withDescription("\u041f\u043e\u0438\u0441\u043a \u043f\u043e \u043a\u043e\u0434\u043e\u0432\u043e\u0439 \u0431\u0430\u0437\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d").forAllResources());
        this.addRule(PermissionRule.ask("edit_file").withPriority(10).withDescription("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u043e\u0432 \u0442\u0440\u0435\u0431\u0443\u0435\u0442 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f").forAllResources());
        this.addRule(PermissionRule.ask("write_file").withPriority(10).withDescription("\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u043e\u0432 \u0442\u0440\u0435\u0431\u0443\u0435\u0442 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f").forAllResources());
        this.addRule(PermissionRule.deny("shell").forResourcePattern("rm -rf *").withPriority(100).withDescription("\u041e\u043f\u0430\u0441\u043d\u044b\u0435 \u043a\u043e\u043c\u0430\u043d\u0434\u044b \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u044b").build());
        this.addRule(PermissionRule.deny("shell").forResourcePattern("*rm -rf /*").withPriority(100).withDescription("\u041e\u043f\u0430\u0441\u043d\u044b\u0435 \u043a\u043e\u043c\u0430\u043d\u0434\u044b \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u044b").build());
        this.addRule(PermissionRule.deny("shell").forResourcePattern("*format*").withPriority(90).withDescription("\u041a\u043e\u043c\u0430\u043d\u0434\u044b \u0444\u043e\u0440\u043c\u0430\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u044b").build());
        this.addRule(PermissionRule.deny("shell").forResourcePattern("*shutdown*").withPriority(90).withDescription("\u0421\u0438\u0441\u0442\u0435\u043c\u043d\u044b\u0435 \u043a\u043e\u043c\u0430\u043d\u0434\u044b \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u044b").build());
        this.addRule(PermissionRule.deny("shell").forResourcePattern("*reboot*").withPriority(90).withDescription("\u0421\u0438\u0441\u0442\u0435\u043c\u043d\u044b\u0435 \u043a\u043e\u043c\u0430\u043d\u0434\u044b \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u044b").build());
        this.addRule(PermissionRule.allow("shell").forResourcePattern("git *").withPriority(50).withDescription("Git \u043a\u043e\u043c\u0430\u043d\u0434\u044b \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u044b").build());
        this.addRule(PermissionRule.allow("shell").forResourcePattern("mvn *").withPriority(50).withDescription("Maven \u043a\u043e\u043c\u0430\u043d\u0434\u044b \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u044b").build());
        this.addRule(PermissionRule.allow("shell").forResourcePattern("gradle *").withPriority(50).withDescription("Gradle \u043a\u043e\u043c\u0430\u043d\u0434\u044b \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u044b").build());
        this.addRule(PermissionRule.allow("shell").forResourcePattern("npm *").withPriority(50).withDescription("NPM \u043a\u043e\u043c\u0430\u043d\u0434\u044b \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u044b").build());
        this.addRule(PermissionRule.ask("shell").withPriority(1).withDescription("Shell \u043a\u043e\u043c\u0430\u043d\u0434\u044b \u0442\u0440\u0435\u0431\u0443\u044e\u0442 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f").forAllResources());
    }

    @Override
    public void setCallback(IPermissionCallback callback) {
        this.callback = callback;
    }

    @Override
    public IPermissionCallback getCallback() {
        return this.callback;
    }

    @Override
    public void addSessionPermission(String toolName, String resource, PermissionDecision decision) {
        String key = toolName + ":" + resource;
        this.sessionPermissions.put(key, decision);
    }

    @Override
    public void clearSessionPermissions() {
        this.sessionPermissions.clear();
    }

    @Override
    public void saveRules() {
        try {
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
            ArrayList<RuleData> ruleDataList = new ArrayList<RuleData>();
            for (PermissionRule rule : this.rules) {
                ruleDataList.add(RuleData.from(rule));
            }
            String json = this.gson.toJson(ruleDataList);
            prefs.put(PREF_RULES, json);
            prefs.flush();
            this.logInfo("\u041f\u0440\u0430\u0432\u0438\u043b\u0430 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u0439 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u044b: " + this.rules.size());
        }
        catch (BackingStoreException e) {
            this.logError("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u043f\u0440\u0430\u0432\u0438\u043b \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u0439", e);
        }
    }

    @Override
    public void loadRules() {
        try {
            List ruleDataList;
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
            String json = prefs.get(PREF_RULES, null);
            if (json != null && !json.isEmpty() && (ruleDataList = (List)this.gson.fromJson(json, new TypeToken<List<RuleData>>(){}.getType())) != null) {
                this.rules.clear();
                for (RuleData data : ruleDataList) {
                    this.rules.add(data.toRule());
                }
                this.logInfo("\u041f\u0440\u0430\u0432\u0438\u043b\u0430 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u044b: " + this.rules.size());
                return;
            }
        }
        catch (Exception e) {
            this.logError("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043f\u0440\u0430\u0432\u0438\u043b \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u0439", e);
        }
        this.loadDefaultRules();
    }

    private void logInfo(String message) {
        LOG.log((IStatus)new Status(1, PLUGIN_ID, message));
    }

    private void logError(String message, Throwable error) {
        LOG.log((IStatus)new Status(4, PLUGIN_ID, message, error));
    }

    private static class RuleData {
        String toolName;
        String decision;
        String resourcePattern;
        boolean isGlob;
        int priority;
        String description;

        private RuleData() {
        }

        static RuleData from(PermissionRule rule) {
            RuleData data = new RuleData();
            data.toolName = rule.getToolName();
            data.decision = rule.getDecision().name();
            data.resourcePattern = rule.getResourcePattern();
            data.isGlob = rule.isGlob();
            data.priority = rule.getPriority();
            data.description = rule.getDescription();
            return data;
        }

        PermissionRule toRule() {
            PermissionRule.Builder builder = PermissionRule.builder(this.toolName, PermissionDecision.valueOf(this.decision));
            if (this.isGlob) {
                builder.forResourcePattern(this.resourcePattern);
            } else {
                builder.forResourceRegex(this.resourcePattern);
            }
            return builder.withPriority(this.priority).withDescription(this.description).build();
        }
    }
}

