/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.model;

import java.util.Objects;

public class ToolDefinition {
    private final String name;
    private final String description;
    private final String parametersSchema;

    public ToolDefinition(String name, String description, String parametersSchema) {
        this.name = Objects.requireNonNull(name, "name");
        this.description = Objects.requireNonNull(description, "description");
        this.parametersSchema = Objects.requireNonNull(parametersSchema, "parametersSchema");
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getParametersSchema() {
        return this.parametersSchema;
    }

    public static class Builder {
        private String name;
        private String description;
        private String parametersSchema = "{}";

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder parametersSchema(String parametersSchema) {
            this.parametersSchema = parametersSchema;
            return this;
        }

        public ToolDefinition build() {
            return new ToolDefinition(this.name, this.description, this.parametersSchema);
        }
    }
}

