/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.model;

import com.example.vibe.core.model.LlmMessage;
import com.example.vibe.core.model.ToolDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class LlmRequest {
    private final List<LlmMessage> messages;
    private final List<ToolDefinition> tools;
    private final String model;
    private final int maxTokens;
    private final double temperature;
    private final boolean stream;
    private final ToolChoice toolChoice;

    private LlmRequest(Builder builder) {
        this.messages = Collections.unmodifiableList(new ArrayList<LlmMessage>(builder.messages));
        this.tools = builder.tools.isEmpty() ? null : Collections.unmodifiableList(new ArrayList<ToolDefinition>(builder.tools));
        this.model = builder.model;
        this.maxTokens = builder.maxTokens;
        this.temperature = builder.temperature;
        this.stream = builder.stream;
        this.toolChoice = builder.toolChoice;
    }

    public List<LlmMessage> getMessages() {
        return this.messages;
    }

    public List<ToolDefinition> getTools() {
        return this.tools;
    }

    public boolean hasTools() {
        return this.tools != null && !this.tools.isEmpty();
    }

    public String getModel() {
        return this.model;
    }

    public int getMaxTokens() {
        return this.maxTokens;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public boolean isStream() {
        return this.stream;
    }

    public ToolChoice getToolChoice() {
        return this.toolChoice;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<LlmMessage> messages = new ArrayList<LlmMessage>();
        private final List<ToolDefinition> tools = new ArrayList<ToolDefinition>();
        private String model;
        private int maxTokens = 4096;
        private double temperature = 0.7;
        private boolean stream = false;
        private ToolChoice toolChoice = ToolChoice.AUTO;

        public Builder addMessage(LlmMessage message) {
            this.messages.add(Objects.requireNonNull(message));
            return this;
        }

        public Builder messages(List<LlmMessage> messages) {
            this.messages.clear();
            if (messages != null) {
                this.messages.addAll(messages);
            }
            return this;
        }

        public Builder systemMessage(String content) {
            return this.addMessage(LlmMessage.system(content));
        }

        public Builder userMessage(String content) {
            return this.addMessage(LlmMessage.user(content));
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder maxTokens(int maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public Builder temperature(double temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder stream(boolean stream) {
            this.stream = stream;
            return this;
        }

        public Builder addTool(ToolDefinition tool) {
            this.tools.add(Objects.requireNonNull(tool));
            return this;
        }

        public Builder tools(List<ToolDefinition> tools) {
            this.tools.addAll(tools);
            return this;
        }

        public Builder toolChoice(ToolChoice toolChoice) {
            this.toolChoice = toolChoice;
            return this;
        }

        public LlmRequest build() {
            if (this.messages.isEmpty()) {
                throw new IllegalStateException("At least one message is required");
            }
            return new LlmRequest(this);
        }
    }

    public static enum ToolChoice {
        AUTO,
        REQUIRED,
        NONE;

    }
}

