/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.model;

import com.example.vibe.core.model.ToolCall;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class LlmMessage {
    private final Role role;
    private final String content;
    private final List<ToolCall> toolCalls;
    private final String toolCallId;

    public LlmMessage(Role role, String content) {
        this(role, content, null, null);
    }

    public LlmMessage(Role role, String content, List<ToolCall> toolCalls, String toolCallId) {
        this.role = Objects.requireNonNull(role, "role must not be null");
        this.content = content != null ? content : "";
        this.toolCalls = toolCalls != null ? Collections.unmodifiableList(toolCalls) : Collections.emptyList();
        this.toolCallId = toolCallId;
    }

    public static LlmMessage system(String content) {
        return new LlmMessage(Role.SYSTEM, content);
    }

    public static LlmMessage user(String content) {
        return new LlmMessage(Role.USER, content);
    }

    public static LlmMessage assistant(String content) {
        return new LlmMessage(Role.ASSISTANT, content);
    }

    public static LlmMessage assistantWithToolCalls(String content, List<ToolCall> toolCalls) {
        return new LlmMessage(Role.ASSISTANT, content, toolCalls, null);
    }

    public static LlmMessage toolResult(String toolCallId, String content) {
        return new LlmMessage(Role.TOOL, content, null, toolCallId);
    }

    public Role getRole() {
        return this.role;
    }

    public String getContent() {
        return this.content;
    }

    public List<ToolCall> getToolCalls() {
        return this.toolCalls;
    }

    public boolean hasToolCalls() {
        return !this.toolCalls.isEmpty();
    }

    public String getToolCallId() {
        return this.toolCallId;
    }

    public boolean isToolResult() {
        return this.role == Role.TOOL && this.toolCallId != null;
    }

    public String toString() {
        return String.format("LlmMessage[role=%s, content=%s]", new Object[]{this.role, this.content.length() > 50 ? this.content.substring(0, 50) + "..." : this.content});
    }

    public static enum Role {
        SYSTEM("system"),
        USER("user"),
        ASSISTANT("assistant"),
        TOOL("tool");

        private final String value;

        private Role(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

