/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.mcp.model;

import com.example.vibe.core.mcp.model.McpContent;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class McpToolResult {
    @SerializedName(value="content")
    private List<McpContent> content = new ArrayList<McpContent>();
    @SerializedName(value="isError")
    private boolean isError;

    public static McpToolResult text(String text) {
        McpToolResult result = new McpToolResult();
        result.content.add(McpContent.text(text));
        result.isError = false;
        return result;
    }

    public static McpToolResult error(String errorMessage) {
        McpToolResult result = new McpToolResult();
        result.content.add(McpContent.text(errorMessage));
        result.isError = true;
        return result;
    }

    public List<McpContent> getContent() {
        return this.content != null ? this.content : Collections.emptyList();
    }

    public void setContent(List<McpContent> content) {
        this.content = content;
    }

    public boolean isError() {
        return this.isError;
    }

    public void setError(boolean isError) {
        this.isError = isError;
    }

    public String getTextContent() {
        StringBuilder sb = new StringBuilder();
        for (McpContent c : this.getContent()) {
            if (c.getType() != McpContent.Type.TEXT || c.getText() == null) continue;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(c.getText());
        }
        return sb.toString();
    }

    public String toString() {
        return "McpToolResult[isError=" + this.isError + ", contentCount=" + this.getContent().size() + "]";
    }
}

