/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.mcp.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class McpServerCapabilities {
    private boolean supportsTools;
    private boolean supportsResources;
    private boolean supportsPrompts;
    private boolean supportsLogging;
    private String serverName;
    private String serverVersion;

    public static McpServerCapabilities fromInitializeResult(Object result) {
        McpServerCapabilities caps = new McpServerCapabilities();
        if (result == null) {
            return caps;
        }
        JsonObject json = null;
        if (result instanceof JsonObject) {
            json = (JsonObject)result;
        } else {
            Gson gson = new Gson();
            JsonElement element = gson.toJsonTree(result);
            if (element.isJsonObject()) {
                json = element.getAsJsonObject();
            }
        }
        if (json == null) {
            return caps;
        }
        if (json.has("capabilities")) {
            JsonObject capsObj = json.getAsJsonObject("capabilities");
            caps.supportsTools = capsObj.has("tools");
            caps.supportsResources = capsObj.has("resources");
            caps.supportsPrompts = capsObj.has("prompts");
            caps.supportsLogging = capsObj.has("logging");
        }
        if (json.has("serverInfo")) {
            JsonObject serverInfo = json.getAsJsonObject("serverInfo");
            if (serverInfo.has("name")) {
                caps.serverName = serverInfo.get("name").getAsString();
            }
            if (serverInfo.has("version")) {
                caps.serverVersion = serverInfo.get("version").getAsString();
            }
        }
        return caps;
    }

    public boolean supportsTools() {
        return this.supportsTools;
    }

    public void setSupportsTools(boolean supportsTools) {
        this.supportsTools = supportsTools;
    }

    public boolean supportsResources() {
        return this.supportsResources;
    }

    public void setSupportsResources(boolean supportsResources) {
        this.supportsResources = supportsResources;
    }

    public boolean supportsPrompts() {
        return this.supportsPrompts;
    }

    public void setSupportsPrompts(boolean supportsPrompts) {
        this.supportsPrompts = supportsPrompts;
    }

    public boolean supportsLogging() {
        return this.supportsLogging;
    }

    public void setSupportsLogging(boolean supportsLogging) {
        this.supportsLogging = supportsLogging;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public void setServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
    }

    public String toString() {
        return "McpServerCapabilities[tools=" + this.supportsTools + ", resources=" + this.supportsResources + ", prompts=" + this.supportsPrompts + ", server=" + this.serverName + " " + this.serverVersion + "]";
    }
}

