/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.mcp.model;

import com.example.vibe.core.mcp.model.McpError;
import com.google.gson.annotations.SerializedName;

public class McpMessage {
    @SerializedName(value="jsonrpc")
    private String jsonrpc = "2.0";
    @SerializedName(value="method")
    private String method;
    @SerializedName(value="params")
    private Object params;
    @SerializedName(value="id")
    private Object id;
    @SerializedName(value="result")
    private Object result;
    @SerializedName(value="error")
    private McpError error;

    public boolean isRequest() {
        return this.method != null && this.id != null;
    }

    public boolean isNotification() {
        return this.method != null && this.id == null;
    }

    public boolean isResponse() {
        return this.method == null && this.id != null;
    }

    public boolean isErrorResponse() {
        return this.isResponse() && this.error != null;
    }

    public String getJsonrpc() {
        return this.jsonrpc;
    }

    public void setJsonrpc(String jsonrpc) {
        this.jsonrpc = jsonrpc;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Object getParams() {
        return this.params;
    }

    public void setParams(Object params) {
        this.params = params;
    }

    public String getId() {
        return this.id != null ? String.valueOf(this.id) : null;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Object getRawId() {
        return this.id;
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public McpError getError() {
        return this.error;
    }

    public void setError(McpError error) {
        this.error = error;
    }

    public String toString() {
        if (this.isRequest()) {
            return "McpRequest[id=" + String.valueOf(this.id) + ", method=" + this.method + "]";
        }
        if (this.isNotification()) {
            return "McpNotification[method=" + this.method + "]";
        }
        if (this.isErrorResponse()) {
            return "McpErrorResponse[id=" + String.valueOf(this.id) + ", error=" + String.valueOf(this.error) + "]";
        }
        if (this.isResponse()) {
            return "McpResponse[id=" + String.valueOf(this.id) + "]";
        }
        return "McpMessage[invalid]";
    }
}

