/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.mcp.config;

import com.example.vibe.core.logging.VibeLogger;
import com.example.vibe.core.mcp.config.McpServerConfig;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class McpServerConfigStore {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(McpServerConfigStore.class);
    private static final String PREF_MCP_SERVERS = "mcp.servers";
    private static final String CORE_PLUGIN_ID = "com.example.vibe.core";
    private static McpServerConfigStore instance;
    private List<McpServerConfig> servers;

    public static synchronized McpServerConfigStore getInstance() {
        if (instance == null) {
            instance = new McpServerConfigStore();
        }
        return instance;
    }

    private McpServerConfigStore() {
    }

    public List<McpServerConfig> getServers() {
        if (this.servers == null) {
            this.loadServers();
        }
        return new ArrayList<McpServerConfig>(this.servers);
    }

    public List<McpServerConfig> getEnabledServers() {
        return this.getServers().stream().filter(McpServerConfig::isEnabled).collect(Collectors.toList());
    }

    public McpServerConfig getServer(String id) {
        return this.getServers().stream().filter(s -> s.getId().equals(id)).findFirst().orElse(null);
    }

    public void addServer(McpServerConfig server) {
        if (this.servers == null) {
            this.loadServers();
        }
        this.servers.add(server);
        this.saveServers();
    }

    public void updateServer(McpServerConfig server) {
        if (this.servers == null) {
            this.loadServers();
        }
        this.servers.removeIf(s -> s.getId().equals(server.getId()));
        this.servers.add(server);
        this.saveServers();
    }

    public void removeServer(String id) {
        if (this.servers == null) {
            this.loadServers();
        }
        this.servers.removeIf(s -> s.getId().equals(id));
        this.saveServers();
    }

    public void setServers(List<McpServerConfig> newServers) {
        this.servers = new ArrayList<McpServerConfig>(newServers);
        this.saveServers();
    }

    private void loadServers() {
        try {
            IPreferencesService prefsService = Platform.getPreferencesService();
            String json = prefsService.getString(CORE_PLUGIN_ID, PREF_MCP_SERVERS, "[]", null);
            this.servers = this.parseServersJson(json);
            LOG.debug("Loaded %d MCP server configurations", this.servers.size());
        }
        catch (Exception e) {
            LOG.error("Failed to load MCP server configs", e);
            this.servers = new ArrayList<McpServerConfig>();
        }
    }

    private void saveServers() {
        try {
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(CORE_PLUGIN_ID);
            prefs.put(PREF_MCP_SERVERS, this.serversToJson(this.servers));
            prefs.flush();
            LOG.debug("Saved %d MCP server configurations", this.servers.size());
        }
        catch (BackingStoreException e) {
            LOG.error("Failed to save MCP server configs", e);
        }
    }

    private List<McpServerConfig> parseServersJson(String json) {
        ArrayList<McpServerConfig> result = new ArrayList<McpServerConfig>();
        try {
            JsonElement element = JsonParser.parseString((String)json);
            if (element.isJsonArray()) {
                JsonArray array = element.getAsJsonArray();
                for (JsonElement elem : array) {
                    if (!elem.isJsonObject()) continue;
                    try {
                        result.add(McpServerConfig.fromJson(elem.getAsJsonObject()));
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to parse MCP server config: %s", e.getMessage());
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to parse MCP servers JSON: %s", e.getMessage());
        }
        return result;
    }

    private String serversToJson(List<McpServerConfig> servers) {
        JsonArray array = new JsonArray();
        for (McpServerConfig config : servers) {
            array.add((JsonElement)config.toJson());
        }
        return array.toString();
    }
}

