/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.mcp.config;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class McpServerConfig {
    private String id = UUID.randomUUID().toString();
    private String name;
    private boolean enabled = true;
    private TransportType transportType = TransportType.STDIO;
    private String command;
    private List<String> args = new ArrayList<String>();
    private Map<String, String> env = new HashMap<String, String>();
    private String workingDirectory;
    private String url;
    private Map<String, String> headers;
    private int connectionTimeoutMs = 30000;
    private int requestTimeoutMs = 60000;

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public TransportType getTransportType() {
        return this.transportType;
    }

    public String getCommand() {
        return this.command;
    }

    public List<String> getArgs() {
        return this.args != null ? this.args : Collections.emptyList();
    }

    public Map<String, String> getEnv() {
        return this.env != null ? this.env : Collections.emptyMap();
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public int getConnectionTimeoutMs() {
        return this.connectionTimeoutMs;
    }

    public int getRequestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, String> getHeaders() {
        return this.headers != null ? this.headers : Collections.emptyMap();
    }

    public boolean isValid() {
        if (this.name == null || this.name.isBlank()) {
            return false;
        }
        if (this.transportType == TransportType.STDIO) {
            return this.command != null && !this.command.isBlank();
        }
        return this.url != null && !this.url.isBlank();
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("id", this.id);
        json.addProperty("name", this.name);
        json.addProperty("enabled", Boolean.valueOf(this.enabled));
        json.addProperty("transportType", this.transportType.name());
        json.addProperty("command", this.command);
        json.add("args", new Gson().toJsonTree(this.args));
        json.add("env", new Gson().toJsonTree(this.env));
        if (this.workingDirectory != null) {
            json.addProperty("workingDirectory", this.workingDirectory);
        }
        json.addProperty("connectionTimeoutMs", (Number)this.connectionTimeoutMs);
        json.addProperty("requestTimeoutMs", (Number)this.requestTimeoutMs);
        return json;
    }

    public static McpServerConfig fromJson(JsonObject json) {
        Builder builder = McpServerConfig.builder().id(json.has("id") ? json.get("id").getAsString() : null).name(json.get("name").getAsString()).enabled(json.has("enabled") ? json.get("enabled").getAsBoolean() : true).command(json.has("command") ? json.get("command").getAsString() : null);
        if (json.has("transportType")) {
            try {
                builder.transportType(TransportType.valueOf(json.get("transportType").getAsString()));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (json.has("args") && json.get("args").isJsonArray()) {
            JsonArray argsArr = json.getAsJsonArray("args");
            argsArr.forEach(e -> {
                Builder builder2 = builder.addArg(e.getAsString());
            });
        }
        if (json.has("env") && json.get("env").isJsonObject()) {
            JsonObject envObj = json.getAsJsonObject("env");
            envObj.entrySet().forEach(e -> {
                Builder builder2 = builder.putEnv((String)e.getKey(), ((JsonElement)e.getValue()).getAsString());
            });
        }
        if (json.has("workingDirectory") && !json.get("workingDirectory").isJsonNull()) {
            builder.workingDirectory(json.get("workingDirectory").getAsString());
        }
        if (json.has("connectionTimeoutMs")) {
            builder.connectionTimeout(json.get("connectionTimeoutMs").getAsInt());
        }
        if (json.has("requestTimeoutMs")) {
            builder.requestTimeout(json.get("requestTimeoutMs").getAsInt());
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        McpServerConfig other = (McpServerConfig)obj;
        return Objects.equals(this.id, other.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "McpServerConfig[id=" + this.id + ", name=" + this.name + ", command=" + this.command + "]";
    }

    public static class Builder {
        private final McpServerConfig config = new McpServerConfig();

        public Builder id(String id) {
            if (id != null && !id.isBlank()) {
                this.config.id = id;
            }
            return this;
        }

        public Builder name(String name) {
            this.config.name = name;
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.config.enabled = enabled;
            return this;
        }

        public Builder transportType(TransportType type) {
            this.config.transportType = type;
            return this;
        }

        public Builder command(String command) {
            this.config.command = command;
            return this;
        }

        public Builder args(List<String> args) {
            this.config.args = new ArrayList<String>(args);
            return this;
        }

        public Builder addArg(String arg) {
            this.config.args.add(arg);
            return this;
        }

        public Builder env(Map<String, String> env) {
            this.config.env = new HashMap<String, String>(env);
            return this;
        }

        public Builder putEnv(String key, String value) {
            this.config.env.put(key, value);
            return this;
        }

        public Builder workingDirectory(String dir) {
            this.config.workingDirectory = dir;
            return this;
        }

        public Builder connectionTimeout(int ms) {
            this.config.connectionTimeoutMs = ms;
            return this;
        }

        public Builder requestTimeout(int ms) {
            this.config.requestTimeoutMs = ms;
            return this;
        }

        public McpServerConfig build() {
            Objects.requireNonNull(this.config.name, "name is required");
            Objects.requireNonNull(this.config.command, "command is required");
            return this.config;
        }
    }

    public static enum TransportType {
        STDIO,
        HTTP;

    }
}

