/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.mcp;

import com.example.vibe.core.mcp.client.McpClient;
import com.example.vibe.core.mcp.model.McpContent;
import com.example.vibe.core.mcp.model.McpTool;
import com.example.vibe.core.mcp.model.McpToolResult;
import com.example.vibe.core.tools.ITool;
import com.example.vibe.core.tools.ToolResult;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class McpToolAdapter
implements ITool {
    private final McpClient client;
    private final McpTool mcpTool;
    private final String serverName;

    public McpToolAdapter(McpClient client, McpTool mcpTool) {
        this.client = client;
        this.mcpTool = mcpTool;
        this.serverName = client.getServerName();
    }

    @Override
    public String getName() {
        String sanitizedName = this.serverName.replaceAll("[^a-zA-Z0-9_]", "_").toLowerCase();
        return "mcp_" + sanitizedName + "_" + this.mcpTool.getName();
    }

    @Override
    public String getDescription() {
        return "[MCP:" + this.serverName + "] " + this.mcpTool.getDescription();
    }

    @Override
    public String getParameterSchema() {
        if (this.mcpTool.getInputSchema() != null) {
            return this.mcpTool.getInputSchema().toString();
        }
        return "{\"type\":\"object\",\"properties\":{}}";
    }

    @Override
    public CompletableFuture<ToolResult> execute(Map<String, Object> params) {
        return ((CompletableFuture)this.client.callTool(this.mcpTool.getName(), params).thenApply(this::convertResult)).exceptionally(e -> {
            String errorMsg = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            return ToolResult.failure("MCP tool error: " + errorMsg);
        });
    }

    private ToolResult convertResult(McpToolResult mcpResult) {
        if (mcpResult.isError()) {
            return ToolResult.failure(this.extractErrorText(mcpResult));
        }
        StringBuilder text = new StringBuilder();
        for (McpContent content : mcpResult.getContent()) {
            if (content.getType() != McpContent.Type.TEXT) continue;
            if (text.length() > 0) {
                text.append("\n");
            }
            text.append(content.getText());
        }
        return ToolResult.success(text.toString().trim());
    }

    private String extractErrorText(McpToolResult mcpResult) {
        for (McpContent content : mcpResult.getContent()) {
            if (content.getType() != McpContent.Type.TEXT || content.getText() == null) continue;
            return content.getText();
        }
        return "Unknown MCP error";
    }

    @Override
    public boolean requiresConfirmation() {
        return false;
    }

    @Override
    public boolean isDestructive() {
        String name = this.mcpTool.getName().toLowerCase();
        return name.contains("delete") || name.contains("remove") || name.contains("write") || name.contains("create") || name.contains("update") || name.contains("modify");
    }

    public McpTool getMcpTool() {
        return this.mcpTool;
    }

    public String getServerName() {
        return this.serverName;
    }
}

