/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.mcp;

import com.example.vibe.core.logging.VibeLogger;
import com.example.vibe.core.mcp.IMcpServerListener;
import com.example.vibe.core.mcp.McpToolAdapter;
import com.example.vibe.core.mcp.client.McpClient;
import com.example.vibe.core.mcp.config.McpServerConfig;
import com.example.vibe.core.mcp.config.McpServerConfigStore;
import com.example.vibe.core.mcp.model.McpServerState;
import com.example.vibe.core.mcp.model.McpTool;
import com.example.vibe.core.mcp.transport.IMcpTransport;
import com.example.vibe.core.mcp.transport.McpStdioTransport;
import com.example.vibe.core.tools.ToolRegistry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class McpServerManager {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(McpServerManager.class);
    private static McpServerManager instance;
    private final Map<String, McpClient> clients = new ConcurrentHashMap<String, McpClient>();
    private final Map<String, McpServerState> serverStates = new ConcurrentHashMap<String, McpServerState>();
    private final Map<String, String> serverErrors = new ConcurrentHashMap<String, String>();
    private final Map<String, CompletableFuture<McpClient>> startingServers = new ConcurrentHashMap<String, CompletableFuture<McpClient>>();
    private final List<IMcpServerListener> listeners = new CopyOnWriteArrayList<IMcpServerListener>();

    public static synchronized McpServerManager getInstance() {
        if (instance == null) {
            instance = new McpServerManager();
        }
        return instance;
    }

    private McpServerManager() {
    }

    public void startEnabledServers() {
        List<McpServerConfig> configs = McpServerConfigStore.getInstance().getEnabledServers();
        LOG.info("Starting %d enabled MCP servers", configs.size());
        for (McpServerConfig config : configs) {
            this.startServer(config);
        }
    }

    public CompletableFuture<McpClient> startServer(McpServerConfig config) {
        String serverId = config.getId();
        if (this.clients.containsKey(serverId)) {
            LOG.debug("MCP server '%s' already running", config.getName());
            return CompletableFuture.completedFuture(this.clients.get(serverId));
        }
        CompletableFuture<McpClient> existingStart = this.startingServers.get(serverId);
        if (existingStart != null) {
            LOG.debug("MCP server '%s' already starting, waiting...", config.getName());
            return existingStart;
        }
        LOG.info("Starting MCP server: %s (%s %s)", config.getName(), config.getCommand(), String.join((CharSequence)" ", config.getArgs()));
        this.serverStates.put(serverId, McpServerState.STARTING);
        this.serverErrors.remove(serverId);
        this.notifyStateChanged(config, McpServerState.STARTING);
        IMcpTransport transport = this.createTransport(config);
        McpClient client = new McpClient(config.getName(), transport);
        CompletionStage startFuture = ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.runAsync(() -> {
            try {
                transport.connect();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to connect: " + e.getMessage(), e);
            }
        }).thenCompose(v -> client.initialize())).thenApply(v -> {
            this.clients.put(serverId, client);
            this.registerToolsFromServer(serverId, client);
            this.serverStates.put(serverId, McpServerState.RUNNING);
            this.notifyStateChanged(config, McpServerState.RUNNING);
            LOG.info("MCP server '%s' started with %d tools", config.getName(), client.getTools().size());
            return client;
        })).exceptionally(e -> {
            LOG.error("Failed to start MCP server '%s': %s", config.getName(), e.getMessage());
            this.serverStates.put(serverId, McpServerState.ERROR);
            this.serverErrors.put(serverId, e.getMessage());
            this.notifyStateChanged(config, McpServerState.ERROR);
            client.close();
            return null;
        })).whenComplete((result, error) -> this.startingServers.remove(serverId));
        this.startingServers.put(serverId, (CompletableFuture<McpClient>)startFuture);
        return startFuture;
    }

    public void stopServer(String serverId) {
        McpClient client = this.clients.remove(serverId);
        if (client != null) {
            this.unregisterToolsFromServer(serverId, client);
            client.close();
            this.serverStates.put(serverId, McpServerState.STOPPED);
            this.serverErrors.remove(serverId);
            LOG.info("MCP server stopped: %s", client.getServerName());
            this.notifyServerStopped(serverId);
        }
    }

    public void stopAllServers() {
        for (String serverId : new ArrayList<String>(this.clients.keySet())) {
            this.stopServer(serverId);
        }
    }

    public McpServerState getServerState(String serverId) {
        return this.serverStates.getOrDefault(serverId, McpServerState.STOPPED);
    }

    public String getServerError(String serverId) {
        return this.serverErrors.get(serverId);
    }

    public Collection<McpClient> getRunningClients() {
        return Collections.unmodifiableCollection(this.clients.values());
    }

    public McpClient getClient(String serverId) {
        return this.clients.get(serverId);
    }

    public boolean isServerRunning(String serverId) {
        return this.serverStates.get(serverId) == McpServerState.RUNNING;
    }

    public void addListener(IMcpServerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IMcpServerListener listener) {
        this.listeners.remove(listener);
    }

    private IMcpTransport createTransport(McpServerConfig config) {
        if (config.getTransportType() == McpServerConfig.TransportType.STDIO) {
            return new McpStdioTransport(config.getCommand(), config.getArgs(), config.getEnv(), config.getWorkingDirectory() != null ? new File(config.getWorkingDirectory()) : null, config.getRequestTimeoutMs());
        }
        throw new UnsupportedOperationException("HTTP transport not yet implemented");
    }

    private void registerToolsFromServer(String serverId, McpClient client) {
        ToolRegistry registry = ToolRegistry.getInstance();
        String prefix = "mcp_" + client.getServerName().replaceAll("[^a-zA-Z0-9_]", "_").toLowerCase() + "_";
        for (McpTool mcpTool : client.getTools()) {
            McpToolAdapter adapter = new McpToolAdapter(client, mcpTool);
            registry.registerDynamicTool(adapter);
            LOG.debug("Registered MCP tool: %s", adapter.getName());
        }
        client.setToolsChangedListener(newTools -> {
            LOG.info("Re-registering tools for %s due to list_changed notification", client.getServerName());
            registry.unregisterToolsByPrefix(prefix);
            for (McpTool mcpTool : newTools) {
                McpToolAdapter adapter = new McpToolAdapter(client, mcpTool);
                registry.registerDynamicTool(adapter);
                LOG.debug("Re-registered MCP tool: %s", adapter.getName());
            }
        });
    }

    private void unregisterToolsFromServer(String serverId, McpClient client) {
        ToolRegistry registry = ToolRegistry.getInstance();
        String prefix = "mcp_" + client.getServerName().replaceAll("[^a-zA-Z0-9_]", "_").toLowerCase() + "_";
        registry.unregisterToolsByPrefix(prefix);
    }

    private void notifyStateChanged(McpServerConfig config, McpServerState state) {
        for (IMcpServerListener listener : this.listeners) {
            try {
                listener.onServerStateChanged(config, state);
            }
            catch (Exception e) {
                LOG.warn("Listener error", e);
            }
        }
    }

    private void notifyServerStopped(String serverId) {
        for (IMcpServerListener listener : this.listeners) {
            try {
                listener.onServerStopped(serverId);
            }
            catch (Exception e) {
                LOG.warn("Listener error", e);
            }
        }
    }
}

