/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.internal;

import com.example.vibe.core.backend.BackendConfig;
import com.example.vibe.core.backend.BackendService;
import com.example.vibe.core.http.DefaultHttpClientFactory;
import com.example.vibe.core.http.HttpClientFactory;
import com.example.vibe.core.logging.VibeLogger;
import com.example.vibe.core.mcp.McpServerManager;
import com.example.vibe.core.provider.LlmProviderRegistry;
import com.example.vibe.core.provider.ModelService;
import com.example.vibe.core.provider.config.DynamicLlmProvider;
import com.example.vibe.core.provider.config.LlmProviderConfig;
import com.example.vibe.core.provider.config.ProviderType;
import com.example.vibe.core.state.VibeStateService;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class VibeCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.example.vibe.core";
    private static VibeCorePlugin plugin;
    private static ILog logger;
    private HttpClientFactory httpClientFactory;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        logger = Platform.getLog(((Object)((Object)this)).getClass());
        this.httpClientFactory = new DefaultHttpClientFactory();
        VibeLogger vibeLogger = VibeLogger.getInstance();
        vibeLogger.setMinLevel(VibeLogger.Level.DEBUG);
        vibeLogger.setLogToFile(true);
        vibeLogger.setLogToEclipse(true);
        VibeCorePlugin.logInfo("1C Copilot Core plugin started");
        vibeLogger.info("Core", "VibeLogger initialized. Log file: %s", vibeLogger.getLogFilePath());
        BackendService backendService = BackendService.getInstance();
        if (backendService.isConfigured()) {
            VibeCorePlugin.initializeLlmProvider(backendService.getApiKey());
            CompletableFuture.runAsync(() -> backendService.refreshUsage());
            VibeCorePlugin.logInfo("Backend provider initialized successfully");
            vibeLogger.info("Core", "Backend configured: endpoint=%s", BackendConfig.LITELLM_BASE_URL);
        } else {
            VibeCorePlugin.logWarn("Backend not configured: registration required");
            vibeLogger.warn("Core", "Backend not configured. Registration required to enable AI features.");
            VibeStateService.getInstance().setNotConfigured("\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0432\u0445\u043e\u0434");
        }
        CompletableFuture.runAsync(() -> {
            try {
                McpServerManager.getInstance().startEnabledServers();
            }
            catch (Exception e) {
                vibeLogger.error("Core", "Failed to start MCP servers", e);
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        VibeCorePlugin.logInfo("1C Copilot Core plugin stopping");
        try {
            McpServerManager.getInstance().stopAllServers();
        }
        catch (Exception e) {
            VibeCorePlugin.logWarn("Error stopping MCP servers", e);
        }
        if (this.httpClientFactory != null) {
            try {
                this.httpClientFactory.dispose();
            }
            catch (Exception e) {
                VibeCorePlugin.logWarn("Error disposing HTTP client factory", e);
            }
            this.httpClientFactory = null;
        }
        try {
            LlmProviderRegistry.getInstance().dispose();
        }
        catch (Exception e) {
            VibeCorePlugin.logWarn("Error disposing LLM provider registry", e);
        }
        plugin = null;
        super.stop(context);
    }

    public static VibeCorePlugin getDefault() {
        return plugin;
    }

    public HttpClientFactory getHttpClientFactory() {
        return this.httpClientFactory;
    }

    public static void initializeLlmProvider(String apiKey) {
        LlmProviderConfig config = new LlmProviderConfig("backend", "AI Service", ProviderType.OPENAI_COMPATIBLE, BackendConfig.LITELLM_BASE_URL, apiKey, "auto", 4096);
        config.setStreamingEnabled(true);
        DynamicLlmProvider provider = new DynamicLlmProvider(config);
        LlmProviderRegistry.getInstance().setBackendProvider(provider);
        ((CompletableFuture)ModelService.getInstance().fetchModels().thenAccept(models -> VibeLogger.forClass(VibeCorePlugin.class).info("Loaded %d available models", models.size()))).exceptionally(ex -> {
            VibeLogger.forClass(VibeCorePlugin.class).error("Failed to fetch models: %s", ex.getMessage());
            return null;
        });
    }

    public static void logInfo(String message) {
        if (logger != null) {
            logger.log((IStatus)new Status(1, PLUGIN_ID, message));
        }
    }

    public static void logError(String message, Throwable e) {
        if (logger != null) {
            logger.log((IStatus)new Status(4, PLUGIN_ID, message, e));
        }
    }

    public static void logError(Throwable e) {
        VibeCorePlugin.logError(e.getMessage(), e);
    }

    public static void logWarn(String message) {
        if (logger != null) {
            logger.log((IStatus)new Status(2, PLUGIN_ID, message));
        }
    }

    public static void logWarn(String message, Throwable e) {
        if (logger != null) {
            logger.log((IStatus)new Status(2, PLUGIN_ID, message, e));
        }
    }
}

