/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.http;

import com.example.vibe.core.http.HttpClientConfig;
import com.example.vibe.core.internal.VibeCorePlugin;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPOutputStream;

public final class HttpRequestBodies {
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    private static final String CONTENT_TYPE_JSON = "application/json";
    private static final String ENCODING_GZIP = "gzip";

    private HttpRequestBodies() {
    }

    public static HttpRequest.Builder postJson(HttpRequest.Builder builder, String json, HttpClientConfig config) {
        byte[] jsonBytes = json.getBytes(StandardCharsets.UTF_8);
        builder.header(HEADER_CONTENT_TYPE, CONTENT_TYPE_JSON);
        if (config.isGzipRequestEnabled() && jsonBytes.length >= config.getGzipMinBytes()) {
            try {
                byte[] gzippedBytes = HttpRequestBodies.gzip(jsonBytes);
                if (gzippedBytes.length < jsonBytes.length) {
                    builder.header(HEADER_CONTENT_ENCODING, ENCODING_GZIP);
                    builder.POST(HttpRequest.BodyPublishers.ofByteArray(gzippedBytes));
                    VibeCorePlugin.logInfo(String.format("GZIP compressed request: %d -> %d bytes (%.1f%%)", jsonBytes.length, gzippedBytes.length, 100.0 * (double)gzippedBytes.length / (double)jsonBytes.length));
                    return builder;
                }
            }
            catch (IOException e) {
                VibeCorePlugin.logWarn("Failed to GZIP compress request, sending uncompressed", e);
            }
        }
        builder.POST(HttpRequest.BodyPublishers.ofString(json, StandardCharsets.UTF_8));
        return builder;
    }

    public static HttpRequest.Builder postJsonUncompressed(HttpRequest.Builder builder, String json) {
        return builder.header(HEADER_CONTENT_TYPE, CONTENT_TYPE_JSON).POST(HttpRequest.BodyPublishers.ofString(json, StandardCharsets.UTF_8));
    }

    private static byte[] gzip(byte[] data) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length);
        Throwable throwable = null;
        Object var3_4 = null;
        try (GZIPOutputStream gzip = new GZIPOutputStream(bos);){
            gzip.write(data);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return bos.toByteArray();
    }

    public static boolean shouldCompress(int bodySize, HttpClientConfig config) {
        return config.isGzipRequestEnabled() && bodySize >= config.getGzipMinBytes();
    }
}

