/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.http;

import java.net.http.HttpClient;
import java.time.Duration;

public final class HttpClientConfig {
    private final Duration connectTimeout;
    private final Duration requestTimeout;
    private final boolean http2Enabled;
    private final boolean useSystemProxy;
    private final HttpClient.Redirect redirectPolicy;
    private final boolean gzipRequestEnabled;
    private final int gzipMinBytes;

    private HttpClientConfig(Builder builder) {
        this.connectTimeout = builder.connectTimeout;
        this.requestTimeout = builder.requestTimeout;
        this.http2Enabled = builder.http2Enabled;
        this.useSystemProxy = builder.useSystemProxy;
        this.redirectPolicy = builder.redirectPolicy;
        this.gzipRequestEnabled = builder.gzipRequestEnabled;
        this.gzipMinBytes = builder.gzipMinBytes;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public boolean isHttp2Enabled() {
        return this.http2Enabled;
    }

    public boolean isUseSystemProxy() {
        return this.useSystemProxy;
    }

    public HttpClient.Redirect getRedirectPolicy() {
        return this.redirectPolicy;
    }

    public boolean isGzipRequestEnabled() {
        return this.gzipRequestEnabled;
    }

    public int getGzipMinBytes() {
        return this.gzipMinBytes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Duration connectTimeout = Duration.ofSeconds(60L);
        private Duration requestTimeout = Duration.ofSeconds(180L);
        private boolean http2Enabled = true;
        private boolean useSystemProxy = true;
        private HttpClient.Redirect redirectPolicy = HttpClient.Redirect.NORMAL;
        private boolean gzipRequestEnabled = true;
        private int gzipMinBytes = 1024;

        private Builder() {
        }

        public Builder connectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder requestTimeout(Duration requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }

        public Builder http2Enabled(boolean http2Enabled) {
            this.http2Enabled = http2Enabled;
            return this;
        }

        public Builder useSystemProxy(boolean useSystemProxy) {
            this.useSystemProxy = useSystemProxy;
            return this;
        }

        public Builder redirectPolicy(HttpClient.Redirect redirectPolicy) {
            this.redirectPolicy = redirectPolicy;
            return this;
        }

        public Builder gzipRequestEnabled(boolean gzipRequestEnabled) {
            this.gzipRequestEnabled = gzipRequestEnabled;
            return this;
        }

        public Builder gzipMinBytes(int gzipMinBytes) {
            this.gzipMinBytes = gzipMinBytes;
            return this;
        }

        public HttpClientConfig build() {
            return new HttpClientConfig(this);
        }
    }
}

